/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.internal;

import io.siddhi.core.stream.input.source.Source;
import io.siddhi.distribution.editor.core.commons.configs.DockerConfigs;
import io.siddhi.distribution.editor.core.commons.kubernetes.Env;
import io.siddhi.distribution.editor.core.commons.kubernetes.KubernetesConfig;
import io.siddhi.distribution.editor.core.commons.kubernetes.SiddhiProcess;
import io.siddhi.distribution.editor.core.commons.kubernetes.SiddhiProcessApp;
import io.siddhi.distribution.editor.core.commons.kubernetes.SiddhiProcessContainer;
import io.siddhi.distribution.editor.core.commons.kubernetes.SiddhiProcessSpec;
import io.siddhi.distribution.editor.core.commons.request.ExportAppsRequest;
import io.siddhi.distribution.editor.core.exception.DockerGenerationException;
import io.siddhi.distribution.editor.core.exception.KubernetesGenerationException;
import io.siddhi.distribution.editor.core.internal.EditorDataHolder;
import io.siddhi.distribution.editor.core.util.Constants;
import io.siddhi.distribution.editor.core.util.SourceEditorUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class ExportUtils {
    private static final Logger log = LoggerFactory.getLogger(ExportUtils.class);
    private static final String CONFIG_BLOCK_TEMPLATE = "\\{\\{CONFIGURATION_BLOCK}}";
    private static final String CONFIG_PARAMETER_TEMPLATE = "\\{\\{CONFIGURATION_PARAMETER_BLOCK}}";
    private static final String JARS_BLOCK_TEMPLATE = "\\{\\{JARS_BLOCK}}";
    private static final String BUNDLES_BLOCK_TEMPLATE = "\\{\\{BUNDLES_BLOCK}}";
    private static final String ENV_BLOCK_TEMPLATE = "\\{\\{ENV_BLOCK}}";
    private static final String APPS_BLOCK_TEMPLATE = "\\{\\{APPS_BLOCK}}";
    private static final String EXPOSE_PORTS_BLOCK_TEMPLATE = "\\{\\{EXPORT_PORTS_BLOCK}}";
    private static final String DOCKER_BASE_IMAGE_TEMPLATE = "\\{\\{SIDDHI_RUNNER_BASE_IMAGE}}";
    private static final String PORT_BIND_TEMPLATE = "\\{\\{BIND_PORTS}}";
    private static final String CONFIG_BLOCK_VALUE = "COPY --chown=siddhi_user:siddhi_io \\$\\{CONFIG_FILE}/ \\$\\{USER_HOME}";
    private static final String CONFIG_PARAMETER_VALUE = ", \"-Dconfig=/home/siddhi_user/configurations.yaml\"";
    private static final String JARS_BLOCK_VALUE = "COPY --chown=siddhi_user:siddhi_io \\$\\{HOST_JARS_DIR}/ \\$\\{JARS}";
    private static final String BUNDLES_BLOCK_VALUE = "COPY --chown=siddhi_user:siddhi_io \\$\\{HOST_BUNDLES_DIR}/ \\$\\{BUNDLES}";
    private static final String APPS_BLOCK_VALUE = "COPY --chown=siddhi_user:siddhi_io \\$\\{HOST_APPS_DIR}/ \\$\\{APPS}";
    private static final String SIDDHI_PROCESS_SPEC_TEMPLATE = "\\{\\{SIDDHI_PROCESS_SPEC}}";
    private static final String SIDDHI_PROCESS_NAME_TEMPLATE = "\\{\\{SIDDHI_PROCESS_NAME}}";
    private static final String SIDDHI_PROCESS_DEFAULT_NAME = "sample-siddhi-process";
    private static final String SIDDHI_APP_NAME_ENTRY = "appName";
    private static final String SIDDHI_APP_CONTENT_ENTRY = "appContent";
    private static final String SIDDHI_TEMPLATED_VAR_KEY_ENTRY = "key";
    private static final String SIDDHI_TEMPLATED_VAR_VALUE_ENTRY = "value";
    private static final String RESOURCES_DIR = "resources/docker-export";
    private static final String DOCKER_FILE_NAME = "Dockerfile";
    private static final String DOCKER_README_FILE_NAME = "DOCKER-README.md";
    private static final String KUBERNETES_README_FILE_NAME = "K8S-README.md";
    private static final String GENERIC_README_FILE_NAME = "README.md";
    private static final String KUBERNETES_FILE_NAME = "siddhi-process.yaml";
    private static final String JARS_DIR = "jars/";
    private static final String BUNDLE_DIR = "bundles/";
    private static final String APPS_DIR = "siddhi-files/";
    private static final String CONFIG_FILE = "configurations.yaml";
    private static final String EXPORT_TYPE_KUBERNETES = "kubernetes";
    private static final String RUNNER_DEPLOYMENT_YAML_FILE = "runner-deployment.yaml";
    private static final String TOOLING_DEPLOYMENT_YAML_FILE = "deployment.yaml";
    private static final String DIRECTORY_CONF = "conf";
    private static final String DIRECTORY_PROFILE = "tooling";
    private static final String SIDDHI_NAMESPACE = "siddhi";
    private static final String DATA_SOURCES_NAMESPACE = "dataSources";
    private final ConfigProvider configProvider;
    private DockerConfigs dockerConfigs;
    private ExportAppsRequest exportAppsRequest;
    private String exportType;
    Path tempDockerDirectoryPath;
    private Set<Integer> exposePorts = new HashSet<Integer>();

    ExportUtils(ConfigProvider configProvider, ExportAppsRequest exportAppsRequest, String exportType) {
        this.configProvider = configProvider;
        this.exportAppsRequest = exportAppsRequest;
        this.exportType = exportType;
    }

    ExportUtils(ConfigProvider configProvider) {
        this.configProvider = configProvider;
    }

    public File createZipFile() throws DockerGenerationException, KubernetesGenerationException {
        boolean jarsAdded = false;
        boolean bundlesAdded = false;
        boolean configChanged = false;
        boolean envChanged = false;
        boolean buildDocker = false;
        String zipFileName = "siddhi-docker.zip";
        String zipFileRoot = "siddhi-docker/";
        if (this.exportType != null && this.exportType.equals(EXPORT_TYPE_KUBERNETES)) {
            zipFileName = "siddhi-kubernetes.zip";
            zipFileRoot = "siddhi-kubernetes/";
        }
        Path dockerFilePath = Paths.get(Constants.RUNTIME_PATH, RESOURCES_DIR, DOCKER_FILE_NAME);
        Path dockerReadmeFilePath = Paths.get(Constants.RUNTIME_PATH, RESOURCES_DIR, DOCKER_README_FILE_NAME);
        Path kubernetesReadmeFilePath = Paths.get(Constants.RUNTIME_PATH, RESOURCES_DIR, KUBERNETES_README_FILE_NAME);
        File zipFile = new File(zipFileName);
        ZipOutputStream zipOutputStream = null;
        ZipEntry dockerFileEntry = new ZipEntry(Paths.get(zipFileRoot, DOCKER_FILE_NAME).toString());
        if (this.exportAppsRequest.getDockerConfiguration() != null) {
            UUID uuid = UUID.randomUUID();
            this.tempDockerDirectoryPath = Paths.get(RESOURCES_DIR, uuid.toString());
            if (!Files.exists(this.tempDockerDirectoryPath, new LinkOption[0]) && !new File(this.tempDockerDirectoryPath.toString()).mkdir()) {
                throw new DockerGenerationException("Failed to create the sample directory " + this.tempDockerDirectoryPath.toString());
            }
            if (Files.isWritable(this.tempDockerDirectoryPath)) {
                buildDocker = true;
            }
        }
        try {
            Object kubernetesFileEntry;
            Object app;
            Object populatedSiddhiApps;
            Object envKey;
            zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));
            if (this.exportAppsRequest.getJars() != null && this.exportAppsRequest.getJars().size() > 0) {
                jarsAdded = true;
                String jarRootDir = Paths.get(Constants.CARBON_HOME, JARS_DIR).toString();
                String jarEntryRootDir = Paths.get(zipFileRoot, JARS_DIR).toString();
                Path tempDockerJarDirPath = Paths.get(this.tempDockerDirectoryPath.toString(), JARS_DIR);
                if (buildDocker && !Files.exists(tempDockerJarDirPath, new LinkOption[0]) && !new File(tempDockerJarDirPath.toString()).mkdir()) {
                    throw new DockerGenerationException("Failed to create the sample jars directory " + tempDockerJarDirPath.toString());
                }
                for (String jar : this.exportAppsRequest.getJars()) {
                    Path jarPath = Paths.get(jarRootDir, jar);
                    ZipEntry jarEntry = new ZipEntry(Paths.get(jarEntryRootDir, jar).toString());
                    if (Files.isReadable(jarPath)) {
                        zipOutputStream.putNextEntry(jarEntry);
                        byte[] jarData = Files.readAllBytes(jarPath);
                        zipOutputStream.write(jarData, 0, jarData.length);
                        zipOutputStream.closeEntry();
                        if (!buildDocker) continue;
                        Files.write(Paths.get(tempDockerJarDirPath.toString(), jar), jarData, new OpenOption[0]);
                        continue;
                    }
                    log.error("JAR file" + jarPath.toString() + " is not readable.");
                }
            }
            if (this.exportAppsRequest.getBundles() != null && this.exportAppsRequest.getBundles().size() > 0) {
                bundlesAdded = true;
                String bundleRootDir = Paths.get(Constants.CARBON_HOME, BUNDLE_DIR).toString();
                String bundleEntryRootDir = Paths.get(zipFileRoot, BUNDLE_DIR).toString();
                Path tempDockerBundleDirPath = Paths.get(this.tempDockerDirectoryPath.toString(), BUNDLE_DIR);
                if (buildDocker && !Files.exists(tempDockerBundleDirPath, new LinkOption[0]) && !new File(tempDockerBundleDirPath.toString()).mkdir()) {
                    throw new DockerGenerationException("Failed to create the sample bundles directory " + tempDockerBundleDirPath.toString());
                }
                for (String bundle : this.exportAppsRequest.getBundles()) {
                    Path bundlePath = Paths.get(bundleRootDir, bundle);
                    ZipEntry bundleEntry = new ZipEntry(Paths.get(bundleEntryRootDir, bundle).toString());
                    if (Files.isReadable(bundlePath)) {
                        zipOutputStream.putNextEntry(bundleEntry);
                        byte[] bundleData = Files.readAllBytes(bundlePath);
                        zipOutputStream.write(bundleData, 0, bundleData.length);
                        zipOutputStream.closeEntry();
                        if (!buildDocker) continue;
                        Files.write(Paths.get(tempDockerBundleDirPath.toString(), bundle), bundleData, new OpenOption[0]);
                        continue;
                    }
                    log.error("Bundle file" + bundlePath.toString() + " is not readable.");
                }
            }
            ArrayList<String> userGivenSiddhiApps = new ArrayList<String>();
            String appsEntryRootDir = Paths.get(zipFileRoot, APPS_DIR).toString();
            Path tempDockerAppDirPath = Paths.get(this.tempDockerDirectoryPath.toString(), APPS_DIR);
            if (buildDocker && !Files.exists(tempDockerAppDirPath, new LinkOption[0]) && !new File(tempDockerAppDirPath.toString()).mkdir()) {
                throw new DockerGenerationException("Failed to create the sample apps directory " + tempDockerAppDirPath.toString());
            }
            if (this.exportAppsRequest.getTemplatedSiddhiApps() != null) {
                for (Map<String, String> app2 : this.exportAppsRequest.getTemplatedSiddhiApps()) {
                    String appName = app2.get(SIDDHI_APP_NAME_ENTRY);
                    ZipEntry appEntry = new ZipEntry(Paths.get(appsEntryRootDir, appName).toString());
                    zipOutputStream.putNextEntry(appEntry);
                    String siddhiAppContent = app2.get(SIDDHI_APP_CONTENT_ENTRY);
                    userGivenSiddhiApps.add(siddhiAppContent);
                    byte[] appData = siddhiAppContent.getBytes(StandardCharsets.UTF_8);
                    zipOutputStream.write(appData, 0, appData.length);
                    zipOutputStream.closeEntry();
                    if (!buildDocker) continue;
                    Files.write(Paths.get(tempDockerAppDirPath.toString(), appName), appData, new OpenOption[0]);
                }
            }
            if (this.exportAppsRequest.getConfiguration() != null && !this.exportAppsRequest.getConfiguration().isEmpty()) {
                configChanged = true;
                ZipEntry configFileEntry = new ZipEntry(Paths.get(zipFileRoot, CONFIG_FILE).toString());
                zipOutputStream.putNextEntry(configFileEntry);
                byte[] configData = this.exportAppsRequest.getConfiguration().getBytes(StandardCharsets.UTF_8);
                zipOutputStream.write(configData, 0, configData.length);
                zipOutputStream.closeEntry();
                if (buildDocker) {
                    Path tempDockerConfigPath = Paths.get(this.tempDockerDirectoryPath.toString(), CONFIG_FILE);
                    Files.write(tempDockerConfigPath, configData, new OpenOption[0]);
                }
            }
            StringBuilder envStringBuilder = new StringBuilder();
            HashMap<String, String> envMap = new HashMap<String, String>();
            if (this.exportAppsRequest.getTemplatedVariables() != null && !this.exportAppsRequest.getTemplatedVariables().isEmpty()) {
                envChanged = true;
                for (Map<String, String> env : this.exportAppsRequest.getTemplatedVariables()) {
                    envKey = env.get(SIDDHI_TEMPLATED_VAR_KEY_ENTRY);
                    String envVal = env.get(SIDDHI_TEMPLATED_VAR_VALUE_ENTRY);
                    envMap.put((String)envKey, envVal);
                    envStringBuilder.append("ENV ").append((String)envKey).append(" ").append(envVal).append("\n");
                }
            }
            this.exposePorts.addAll(Arrays.asList(9090, 9443));
            Object siddhiApps = userGivenSiddhiApps;
            if (envMap.size() != 0 && !userGivenSiddhiApps.isEmpty()) {
                populatedSiddhiApps = new ArrayList();
                envKey = siddhiApps.iterator();
                while (envKey.hasNext()) {
                    String siddhiApp = (String)envKey.next();
                    String populatedSiddhiApp = SourceEditorUtils.populateSiddhiAppWithVars(envMap, siddhiApp);
                    populatedSiddhiApps.add(populatedSiddhiApp);
                }
                siddhiApps = populatedSiddhiApps;
            }
            populatedSiddhiApps = siddhiApps.iterator();
            while (populatedSiddhiApps.hasNext()) {
                app = (String)populatedSiddhiApps.next();
                try {
                    Collection sources = EditorDataHolder.getSiddhiManager().createSiddhiAppRuntime((String)app).getSources();
                    for (List sourceList : sources) {
                        for (Source source : sourceList) {
                            if (source.getServiceDeploymentInfo() == null) continue;
                            this.exposePorts.add(source.getServiceDeploymentInfo().getPort());
                        }
                    }
                }
                catch (Exception ignored) {
                    if (!log.isDebugEnabled()) continue;
                    log.error("Exception caught while parsing the exported Siddhi applications.", (Throwable)ignored);
                }
            }
            StringBuilder exposePortsStr = new StringBuilder();
            if (!this.exposePorts.isEmpty()) {
                exposePortsStr.append("EXPOSE ");
                app = this.exposePorts.iterator();
                while (app.hasNext()) {
                    int port = (Integer)app.next();
                    exposePortsStr.append(port).append(" ");
                }
                exposePortsStr.append("\n");
            }
            zipOutputStream.putNextEntry(dockerFileEntry);
            byte[] dockerContent = this.getDockerFile(dockerFilePath, jarsAdded, bundlesAdded, configChanged, envChanged, envStringBuilder.toString(), exposePortsStr.toString());
            zipOutputStream.write(dockerContent, 0, dockerContent.length);
            zipOutputStream.closeEntry();
            if (buildDocker) {
                Path tempDockerFilePath = Paths.get(this.tempDockerDirectoryPath.toString(), DOCKER_FILE_NAME);
                Files.write(tempDockerFilePath, dockerContent, new OpenOption[0]);
            }
            ZipEntry readmeEntry = new ZipEntry(Paths.get(zipFileRoot, GENERIC_README_FILE_NAME).toString());
            zipOutputStream.putNextEntry(readmeEntry);
            if (this.exportType != null && this.exportType.equals(EXPORT_TYPE_KUBERNETES)) {
                if (!Files.isReadable(kubernetesReadmeFilePath)) {
                    throw new KubernetesGenerationException("Readme file " + kubernetesReadmeFilePath.toString() + " is not readable.");
                }
                byte[] readmeContent = Files.readAllBytes(kubernetesReadmeFilePath);
                zipOutputStream.write(readmeContent, 0, readmeContent.length);
                zipOutputStream.closeEntry();
                kubernetesFileEntry = new ZipEntry(Paths.get(zipFileRoot, KUBERNETES_FILE_NAME).toString());
                zipOutputStream.putNextEntry((ZipEntry)kubernetesFileEntry);
                byte[] kubernetesFileData = this.getKubernetesFile(Paths.get(Constants.RUNTIME_PATH, RESOURCES_DIR, KUBERNETES_FILE_NAME));
                zipOutputStream.write(kubernetesFileData, 0, kubernetesFileData.length);
                zipOutputStream.closeEntry();
            } else {
                StringBuilder portBindingStr = new StringBuilder();
                kubernetesFileEntry = this.exposePorts.iterator();
                while (kubernetesFileEntry.hasNext()) {
                    int port = kubernetesFileEntry.next();
                    portBindingStr.append("-p ");
                    portBindingStr.append(port);
                    portBindingStr.append(":");
                    portBindingStr.append(port);
                    portBindingStr.append(" ");
                }
                if (!Files.isReadable(dockerReadmeFilePath)) {
                    throw new DockerGenerationException("Readme file " + dockerReadmeFilePath.toString() + " is not readable.");
                }
                byte[] data = Files.readAllBytes(dockerReadmeFilePath);
                String content = new String(data, StandardCharsets.UTF_8);
                content = content.replaceAll(PORT_BIND_TEMPLATE, portBindingStr.toString());
                byte[] readmeContent = content.getBytes(StandardCharsets.UTF_8);
                zipOutputStream.write(readmeContent, 0, readmeContent.length);
                zipOutputStream.closeEntry();
            }
        }
        catch (IOException e) {
            throw new DockerGenerationException("Cannot write to the zip file " + dockerFilePath.toString(), e);
        }
        catch (ConfigurationException e) {
            throw new DockerGenerationException("Cannot read configurations from the deployment.yaml", (Exception)((Object)e));
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    log.error("Cannot close the zip file " + zipFileName, (Throwable)e);
                }
            }
        }
        return zipFile;
    }

    public Path getTempDockerPath() {
        if (this.tempDockerDirectoryPath != null) {
            return this.tempDockerDirectoryPath;
        }
        return Paths.get("", new String[0]);
    }

    private byte[] getDockerFile(Path dockerFilePath, boolean jarsAdded, boolean bundlesAdded, boolean configChanged, boolean envChanged, String envList, String exportPortList) throws IOException, DockerGenerationException, ConfigurationException {
        if (!Files.isReadable(dockerFilePath)) {
            throw new DockerGenerationException("Docker file " + dockerFilePath.toString() + " is not readable.");
        }
        byte[] data = Files.readAllBytes(dockerFilePath);
        String content = new String(data, StandardCharsets.UTF_8);
        String dockerBaseImgName = "siddhiio/siddhi-runner-base-alpine";
        String version = EditorDataHolder.getBundleContext().getBundle().getVersion().toString();
        if (version != null && !version.isEmpty()) {
            dockerBaseImgName = dockerBaseImgName.concat(":").concat(version.toLowerCase());
        }
        if (this.configProvider.getConfigurationObject("exportConfigs") != null) {
            dockerBaseImgName = (String)((Map)this.configProvider.getConfigurationObject("exportConfigs")).get("dockerBaseImage");
        }
        content = content.replaceAll(DOCKER_BASE_IMAGE_TEMPLATE, dockerBaseImgName);
        content = this.exportType != null && this.exportType.equals(EXPORT_TYPE_KUBERNETES) ? content.replaceAll(APPS_BLOCK_TEMPLATE, "") : content.replaceAll(APPS_BLOCK_TEMPLATE, APPS_BLOCK_VALUE);
        content = jarsAdded ? content.replaceAll(JARS_BLOCK_TEMPLATE, JARS_BLOCK_VALUE) : content.replaceAll(JARS_BLOCK_TEMPLATE, "");
        content = bundlesAdded ? content.replaceAll(BUNDLES_BLOCK_TEMPLATE, BUNDLES_BLOCK_VALUE) : content.replaceAll(BUNDLES_BLOCK_TEMPLATE, "");
        if (configChanged) {
            content = content.replaceAll(CONFIG_BLOCK_TEMPLATE, CONFIG_BLOCK_VALUE);
            content = content.replaceAll(CONFIG_PARAMETER_TEMPLATE, CONFIG_PARAMETER_VALUE);
        } else {
            content = content.replaceAll(CONFIG_BLOCK_TEMPLATE, "");
            content = content.replaceAll(CONFIG_PARAMETER_TEMPLATE, "");
        }
        content = envChanged ? content.replaceAll(ENV_BLOCK_TEMPLATE, envList) : content.replaceAll(ENV_BLOCK_TEMPLATE, "");
        content = content.replaceAll(EXPOSE_PORTS_BLOCK_TEMPLATE, exportPortList);
        return content.getBytes(StandardCharsets.UTF_8);
    }

    private byte[] getKubernetesFile(Path kubernetesFilePath) throws KubernetesGenerationException, IOException {
        if (!Files.isReadable(kubernetesFilePath)) {
            throw new KubernetesGenerationException("Kubernetes file " + kubernetesFilePath.toString() + " is not readable.");
        }
        byte[] data = Files.readAllBytes(kubernetesFilePath);
        String content = new String(data, StandardCharsets.UTF_8);
        if (this.exportAppsRequest.getKubernetesConfiguration() != null) {
            CustomClassLoaderConstructor customClassLoaderConstructor = new CustomClassLoaderConstructor(this.getClass().getClassLoader());
            Yaml kubernetesConfigYaml = new Yaml((BaseConstructor)customClassLoaderConstructor);
            String kubernetesConfigString = this.exportAppsRequest.getKubernetesConfiguration();
            KubernetesConfig kubernetesConfig = (KubernetesConfig)kubernetesConfigYaml.loadAs(kubernetesConfigString, KubernetesConfig.class);
            SiddhiProcessSpec siddhiProcessSpec = new SiddhiProcessSpec();
            if (kubernetesConfig != null) {
                if (kubernetesConfig.getMessagingSystem() != null) {
                    siddhiProcessSpec.setMessagingSystem(kubernetesConfig.getMessagingSystem());
                }
                if (kubernetesConfig.getPersistentVolumeClaim() != null) {
                    siddhiProcessSpec.setPersistentVolumeClaim(kubernetesConfig.getPersistentVolumeClaim());
                }
            }
            SiddhiProcessContainer siddhiProcessContainer = new SiddhiProcessContainer();
            boolean changedContainerSpec = false;
            if (this.exportAppsRequest.getTemplatedVariables() != null && this.exportAppsRequest.getTemplatedVariables().size() > 0) {
                ArrayList<Env> envs = new ArrayList<Env>();
                for (Map<String, String> templatedVariable : this.exportAppsRequest.getTemplatedVariables()) {
                    Env env = new Env(templatedVariable.get(SIDDHI_TEMPLATED_VAR_KEY_ENTRY), templatedVariable.get(SIDDHI_TEMPLATED_VAR_VALUE_ENTRY));
                    envs.add(env);
                }
                siddhiProcessContainer.setEnv(envs);
                siddhiProcessSpec.setContainer(siddhiProcessContainer);
                changedContainerSpec = true;
            }
            if (this.exportAppsRequest.getDockerConfiguration() != null && this.exportAppsRequest.getDockerConfiguration().getImageName() != null) {
                siddhiProcessContainer.setImage(this.exportAppsRequest.getDockerConfiguration().getImageName());
                changedContainerSpec = true;
            }
            if (changedContainerSpec) {
                siddhiProcessSpec.setContainer(siddhiProcessContainer);
            }
            if (this.exportAppsRequest.getTemplatedSiddhiApps() != null && this.exportAppsRequest.getTemplatedSiddhiApps().size() > 0) {
                ArrayList<SiddhiProcessApp> siddhiProcessApps = new ArrayList<SiddhiProcessApp>();
                for (Map<String, String> app : this.exportAppsRequest.getTemplatedSiddhiApps()) {
                    String escapedApp = app.get(SIDDHI_APP_CONTENT_ENTRY).replaceAll("( |\\t)*\\n", "\n").replaceAll("(\t)+", "");
                    SiddhiProcessApp siddhiProcessApp = new SiddhiProcessApp(escapedApp);
                    siddhiProcessApps.add(siddhiProcessApp);
                }
                siddhiProcessSpec.setApps(siddhiProcessApps);
            }
            if (this.exportAppsRequest.getConfiguration() != null && !this.exportAppsRequest.getConfiguration().isEmpty()) {
                String escapedConfig = this.exportAppsRequest.getConfiguration().replaceAll("( |\\t)*\\n", "\n");
                siddhiProcessSpec.setRunner(escapedConfig);
            }
            SiddhiProcess siddhiProcess = new SiddhiProcess(siddhiProcessSpec);
            Representer representer = new Representer(){

                protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
                    if (propertyValue == null) {
                        return null;
                    }
                    return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
                }
            };
            representer.addClassTag(SiddhiProcess.class, Tag.MAP);
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(representer, options);
            String spec = yaml.dump((Object)siddhiProcess);
            spec = spec.replaceAll("\\$", "\\\\\\$");
            spec = spec.replaceAll("\\{", "\\\\\\{");
            content = content.replaceAll(SIDDHI_PROCESS_SPEC_TEMPLATE, spec);
            content = kubernetesConfig != null ? (kubernetesConfig.getSiddhiProcessName() != null ? content.replaceAll(SIDDHI_PROCESS_NAME_TEMPLATE, kubernetesConfig.getSiddhiProcessName()) : content.replaceAll(SIDDHI_PROCESS_NAME_TEMPLATE, SIDDHI_PROCESS_DEFAULT_NAME)) : content.replaceAll(SIDDHI_PROCESS_NAME_TEMPLATE, SIDDHI_PROCESS_DEFAULT_NAME);
        }
        return content.getBytes(StandardCharsets.UTF_8);
    }

    private DockerConfigs getConfigurations() throws ConfigurationException {
        if (this.dockerConfigs == null) {
            this.dockerConfigs = (DockerConfigs)this.configProvider.getConfigurationObject(DockerConfigs.class);
        }
        return this.dockerConfigs;
    }

    public String exportConfigs() throws IOException {
        Path toolingConfigFile = Paths.get(Constants.CARBON_HOME, DIRECTORY_CONF, DIRECTORY_PROFILE, TOOLING_DEPLOYMENT_YAML_FILE);
        Path runnerConfigFile = Paths.get(Constants.RUNTIME_PATH, RESOURCES_DIR, RUNNER_DEPLOYMENT_YAML_FILE);
        if (!Files.isReadable(toolingConfigFile)) {
            throw new IOException("Config file " + toolingConfigFile.toString() + " is not readable.");
        }
        if (!Files.isReadable(runnerConfigFile)) {
            throw new IOException("Config file " + runnerConfigFile.toString() + " is not readable.");
        }
        String toolingDeploymentYamlContent = new String(Files.readAllBytes(toolingConfigFile), StandardCharsets.UTF_8);
        String runnerDeploymentYamlContent = new String(Files.readAllBytes(runnerConfigFile), StandardCharsets.UTF_8);
        Yaml loadYaml = new Yaml();
        Map runnerConfigMap = (Map)loadYaml.load(runnerDeploymentYamlContent);
        Map toolingConfigMap = (Map)loadYaml.load(toolingDeploymentYamlContent);
        if (runnerConfigMap != null) {
            if (toolingConfigMap.get(DATA_SOURCES_NAMESPACE) != null) {
                runnerConfigMap.put(DATA_SOURCES_NAMESPACE, toolingConfigMap.get(DATA_SOURCES_NAMESPACE));
            }
            if (toolingConfigMap.get(SIDDHI_NAMESPACE) != null) {
                runnerConfigMap.put(SIDDHI_NAMESPACE, toolingConfigMap.get(SIDDHI_NAMESPACE));
            }
            Representer representer = new Representer();
            representer.addClassTag(SiddhiProcess.class, Tag.MAP);
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml dumpYaml = new Yaml(representer, options);
            return dumpYaml.dump((Object)runnerConfigMap);
        }
        return "";
    }
}

