/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.siddhi.distribution.editor.core.util.Constants;
import io.siddhi.distribution.editor.core.util.LogEncoder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileJsonObjectReaderUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileJsonObjectReaderUtil.class);

    public static JsonArray listDirectoryInPath(String path, List<String> directories) throws IOException {
        Path ioPath = Paths.get(path, new String[0]);
        JsonArray dirs = new JsonArray();
        Iterator iterator = Files.list(ioPath).iterator();
        while (iterator.hasNext()) {
            JsonObject jsnObj;
            Path next = (Path)iterator.next();
            if (!Files.isDirectory(next, new LinkOption[0]) || Files.isHidden(next) || !directories.contains((jsnObj = FileJsonObjectReaderUtil.getJsonObjForFile(next, true)).get("text").toString())) continue;
            dirs.add((JsonElement)jsnObj);
        }
        return dirs;
    }

    public static JsonObject getJsonObjForFile(Path root, boolean checkChildren) {
        JsonObject rootObj;
        block6: {
            rootObj = new JsonObject();
            Path path = root.getFileName();
            rootObj.addProperty("text", path != null ? path.toString() : root.toString());
            rootObj.addProperty("id", Paths.get(Constants.CARBON_HOME, new String[0]).relativize(root).toString());
            if (Files.isDirectory(root, new LinkOption[0]) && checkChildren) {
                rootObj.addProperty("type", "folder");
                try {
                    if (Files.list(root).count() > 0L) {
                        rootObj.addProperty("children", Boolean.TRUE);
                        break block6;
                    }
                    rootObj.addProperty("children", Boolean.FALSE);
                }
                catch (IOException e) {
                    logger.debug("Error while fetching children of " + LogEncoder.removeCRLFCharacters(root.toString()), (Throwable)e);
                    rootObj.addProperty("error", e.toString());
                }
            } else if (Files.isRegularFile(root, new LinkOption[0]) && checkChildren) {
                rootObj.addProperty("type", "file");
                rootObj.addProperty("children", Boolean.FALSE);
            }
        }
        return rootObj;
    }

    public static JsonArray listFilesInPath(Path path, String fileExtension) throws IOException {
        JsonArray dirs = new JsonArray();
        Iterator iterator = Files.list(path).iterator();
        while (iterator.hasNext()) {
            Path next = (Path)iterator.next();
            if (!Files.isDirectory(next, new LinkOption[0]) && !Files.isRegularFile(next, new LinkOption[0]) || Files.isHidden(next)) continue;
            JsonObject jsnObj = FileJsonObjectReaderUtil.getJsonObjForFile(next, true);
            if (Files.isRegularFile(next, new LinkOption[0])) {
                Path aPath = next.getFileName();
                if (aPath == null || !aPath.toString().endsWith(fileExtension)) continue;
                dirs.add((JsonElement)jsnObj);
                continue;
            }
            dirs.add((JsonElement)jsnObj);
        }
        return dirs;
    }

    public static JsonObject getJsonRootObject(JsonArray filteredDirectoryFiles) {
        JsonObject rootObj = new JsonObject();
        rootObj.add("id", (JsonElement)new JsonPrimitive("root"));
        rootObj.add("text", (JsonElement)new JsonPrimitive(""));
        rootObj.addProperty("type", "folder");
        rootObj.add("children", (JsonElement)filteredDirectoryFiles);
        return rootObj;
    }
}

