/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.codegenerator.elements;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.join.JoinConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.patternsequence.PatternSequenceConditionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.patternsequence.PatternSequenceConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.windowfilterprojection.WindowFilterProjectionConfig;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.CodeGeneratorUtils;
import java.util.LinkedList;
import java.util.List;

public class ExecutionElementConfig {
    private String type;
    private Object value;
    private List<String> inputStreams;
    private List<String> outputStreams;

    public ExecutionElementConfig(QueryConfig query) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(query);
        this.type = "QUERY";
        this.value = query;
        this.inputStreams = this.extractInputStreams(query);
        this.outputStreams = this.extractOutputStreams(query);
    }

    public ExecutionElementConfig(PartitionConfig partition) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(partition);
        this.type = "PARTITION";
        this.value = partition;
        this.inputStreams = this.extractInputStreams(partition);
        this.outputStreams = this.extractOutputStreams(partition);
    }

    private List<String> extractInputStreams(QueryConfig query) throws CodeGenerationException {
        LinkedList<String> inputStreamList = new LinkedList<String>();
        switch (query.getQueryInput().getType().toUpperCase()) {
            case "WINDOW": 
            case "FILTER": 
            case "PROJECTION": 
            case "FUNCTION": {
                WindowFilterProjectionConfig windowFilterProjection = (WindowFilterProjectionConfig)query.getQueryInput();
                CodeGeneratorUtils.NullValidator.validateConfigObject(windowFilterProjection);
                inputStreamList.add(windowFilterProjection.getFrom());
                break;
            }
            case "JOIN": {
                JoinConfig join = (JoinConfig)query.getQueryInput();
                CodeGeneratorUtils.NullValidator.validateConfigObject(join);
                inputStreamList.add(join.getLeft().getFrom());
                inputStreamList.add(join.getRight().getFrom());
                break;
            }
            case "PATTERN": 
            case "SEQUENCE": {
                PatternSequenceConfig patternSequence = (PatternSequenceConfig)query.getQueryInput();
                CodeGeneratorUtils.NullValidator.validateConfigObject(patternSequence);
                for (PatternSequenceConditionConfig condition : patternSequence.getConditionList()) {
                    if (inputStreamList.contains(condition.getStreamName())) continue;
                    inputStreamList.add(condition.getStreamName());
                }
                break;
            }
            default: {
                throw new CodeGenerationException("Unidentified Query Input Type: " + query.getQueryInput().getType());
            }
        }
        return inputStreamList;
    }

    private List<String> extractInputStreams(PartitionConfig partition) throws CodeGenerationException {
        LinkedList<String> inputStreamList = new LinkedList<String>();
        for (List<QueryConfig> queryList : partition.getQueryLists().values()) {
            for (QueryConfig query : queryList) {
                List<String> queryInputStreams = this.extractInputStreams(query);
                for (String inputStreamName : queryInputStreams) {
                    if (inputStreamList.contains(inputStreamName) || inputStreamName.substring(0, 1).equals("#")) continue;
                    inputStreamList.add(inputStreamName);
                }
            }
        }
        return inputStreamList;
    }

    private List<String> extractOutputStreams(QueryConfig query) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(query.getQueryOutput());
        LinkedList<String> outputStreamList = new LinkedList<String>();
        outputStreamList.add(query.getQueryOutput().getTarget());
        return outputStreamList;
    }

    private List<String> extractOutputStreams(PartitionConfig partition) throws CodeGenerationException {
        LinkedList<String> outputStreamList = new LinkedList<String>();
        for (List<QueryConfig> queryList : partition.getQueryLists().values()) {
            for (QueryConfig query : queryList) {
                String outputStream = this.extractOutputStreams(query).get(0);
                if (outputStreamList.contains(outputStream) || outputStream.substring(0, 1).equals("#")) continue;
                outputStreamList.add(this.extractOutputStreams(query).get(0));
            }
        }
        return outputStreamList;
    }

    public String getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public List<String> getInputStreams() {
        return this.inputStreams;
    }

    public List<String> getOutputStreams() {
        return this.outputStreams;
    }
}

