/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.codegenerator.generators;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionWithElement;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryConfig;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.SubElementCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.query.QueryCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.CodeGeneratorUtils;
import java.util.LinkedList;
import java.util.List;

public class PartitionCodeGenerator {
    public String generatePartition(PartitionConfig partition, List<String> definitionNames, boolean isGeneratingToolTip) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(partition);
        StringBuilder partitionStringBuilder = new StringBuilder();
        if (!isGeneratingToolTip) {
            partitionStringBuilder.append(SubElementCodeGenerator.generateComment(partition.getPreviousCommentSegment()));
        }
        partitionStringBuilder.append(SubElementCodeGenerator.generateAnnotations(partition.getAnnotationList())).append('\n').append("partition with").append(' ').append('(').append(this.generatePartitionWith(partition.getPartitionWith())).append(')').append('\n').append("begin").append('\n');
        LinkedList<QueryConfig> queries = new LinkedList<QueryConfig>();
        for (List<QueryConfig> queryList : partition.getQueryLists().values()) {
            queries.addAll(queryList);
        }
        if (!queries.isEmpty()) {
            QueryCodeGenerator queryCodeGenerator = new QueryCodeGenerator();
            int queriesLeft = queries.size();
            for (QueryConfig query : CodeGeneratorUtils.reorderQueries(queries, definitionNames)) {
                partitionStringBuilder.append('\n').append(queryCodeGenerator.generateQuery(query, isGeneratingToolTip));
                if (queriesLeft != 1) {
                    partitionStringBuilder.append('\n');
                }
                --queriesLeft;
            }
        }
        partitionStringBuilder.append('\n').append('\n').append("end").append(';').append('\n');
        return partitionStringBuilder.toString();
    }

    private String generatePartitionWith(List<PartitionWithElement> partitionWith) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(partitionWith);
        StringBuilder partitionWithStringBuilder = new StringBuilder();
        int partitionWithElementsLeft = partitionWith.size();
        for (PartitionWithElement partitionWithElement : partitionWith) {
            partitionWithStringBuilder.append(this.generatePartitionWithElement(partitionWithElement));
            if (partitionWithElementsLeft != 1) {
                partitionWithStringBuilder.append(',');
            }
            --partitionWithElementsLeft;
        }
        return partitionWithStringBuilder.toString();
    }

    private String generatePartitionWithElement(PartitionWithElement partitionWithElement) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(partitionWithElement);
        return partitionWithElement.getExpression() + ' ' + "of" + ' ' + partitionWithElement.getStreamName();
    }
}

