/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.codegenerator.generators;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.WindowConfig;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.SubElementCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.CodeGeneratorUtils;

public class WindowCodeGenerator {
    public String generateWindow(WindowConfig window, boolean isGeneratingToolTip) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(window);
        StringBuilder windowStringBuilder = new StringBuilder();
        if (!isGeneratingToolTip) {
            windowStringBuilder.append(SubElementCodeGenerator.generateComment(window.getPreviousCommentSegment()));
        }
        windowStringBuilder.append(SubElementCodeGenerator.generateAnnotations(window.getAnnotationList())).append('\n').append("define window").append(' ').append(window.getName()).append('\n').append('(').append(SubElementCodeGenerator.generateAttributes(window.getAttributeList())).append(')').append('\n').append(window.getType()).append('(').append(SubElementCodeGenerator.generateParameterList(window.getParameters())).append(')');
        if (window.getOutputEventType() != null && !window.getOutputEventType().isEmpty()) {
            windowStringBuilder.append('\n').append("output").append(' ');
            switch (window.getOutputEventType().toUpperCase()) {
                case "CURRENT_EVENTS": {
                    windowStringBuilder.append("current events");
                    break;
                }
                case "EXPIRED_EVENTS": {
                    windowStringBuilder.append("expired events");
                    break;
                }
                case "ALL_EVENTS": {
                    windowStringBuilder.append("all events");
                    break;
                }
                default: {
                    throw new CodeGenerationException("Unidentified window output event type: " + window.getOutputEventType());
                }
            }
        }
        windowStringBuilder.append(';');
        return windowStringBuilder.toString();
    }
}

