/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.builders;

import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.distribution.editor.core.util.designview.beans.EventFlow;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.Edge;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.SiddhiAppConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.SourceSinkConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.AggregationConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.AnnotationConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.EdgesGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.FunctionConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.PartitionConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.SourceSinkConfigsGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.StreamDefinitionConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.TableConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.TriggerConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.WindowConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.commentspreserver.OuterScopeCommentsPreserver;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.commentspreserver.PartitionScopeCommentsPreserver;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.QueryConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.query.api.SiddhiApp;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.annotation.Element;
import io.siddhi.query.api.definition.AggregationDefinition;
import io.siddhi.query.api.definition.FunctionDefinition;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.definition.TriggerDefinition;
import io.siddhi.query.api.definition.WindowDefinition;
import io.siddhi.query.api.execution.ExecutionElement;
import io.siddhi.query.api.execution.partition.Partition;
import io.siddhi.query.api.execution.query.Query;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventFlowBuilder {
    private String siddhiAppString;
    private SiddhiApp siddhiApp;
    private SiddhiAppRuntime siddhiAppRuntime;
    private SiddhiAppConfig siddhiAppConfig;
    private Set<Edge> edges;

    public EventFlowBuilder(String siddhiAppString, SiddhiApp siddhiApp, SiddhiAppRuntime siddhiAppRuntime) {
        this.siddhiAppString = siddhiAppString;
        this.siddhiApp = siddhiApp;
        this.siddhiAppRuntime = siddhiAppRuntime;
        this.siddhiAppConfig = new SiddhiAppConfig();
        this.edges = new HashSet<Edge>();
    }

    public EventFlow create() {
        return new EventFlow(this.siddhiAppConfig, this.edges);
    }

    public EventFlowBuilder loadAppAnnotations() {
        String siddhiAppName = "";
        String siddhiAppDescription = "";
        ArrayList<String> appAnnotations = new ArrayList<String>();
        ArrayList<Annotation> appAnnotationsObjects = new ArrayList<Annotation>();
        AnnotationConfigGenerator annotationConfigGenerator = new AnnotationConfigGenerator();
        for (Annotation annotation : this.siddhiApp.getAnnotations()) {
            if (annotation.getName().equalsIgnoreCase("NAME")) {
                siddhiAppName = ((Element)annotation.getElements().get(0)).getValue();
                annotationConfigGenerator.preserveCodeSegment((SiddhiElement)annotation);
                continue;
            }
            if (annotation.getName().equalsIgnoreCase("DESCRIPTION")) {
                siddhiAppDescription = ((Element)annotation.getElements().get(0)).getValue();
                annotationConfigGenerator.preserveCodeSegment((SiddhiElement)annotation);
                continue;
            }
            appAnnotationsObjects.add(annotation);
            appAnnotations.add("@App:" + annotationConfigGenerator.generateAnnotationConfig(annotation).split("@")[1]);
        }
        this.siddhiAppConfig.setSiddhiAppName(siddhiAppName);
        this.siddhiAppConfig.setSiddhiAppDescription(siddhiAppDescription);
        this.siddhiAppConfig.setAppAnnotationList(appAnnotations);
        this.siddhiAppConfig.setAppAnnotationListObjects(appAnnotationsObjects);
        this.siddhiAppConfig.addElementCodeSegments(annotationConfigGenerator.getPreservedCodeSegments());
        return this;
    }

    public EventFlowBuilder loadTriggers() throws DesignGenerationException {
        TriggerConfigGenerator triggerConfigGenerator = new TriggerConfigGenerator(this.siddhiAppString, this.siddhiAppRuntime.getStreamDefinitionMap());
        for (TriggerDefinition triggerDefinition : this.siddhiApp.getTriggerDefinitionMap().values()) {
            this.siddhiAppConfig.add(triggerConfigGenerator.generateTriggerConfig(triggerDefinition));
        }
        this.siddhiAppConfig.addElementCodeSegments(triggerConfigGenerator.getPreservedCodeSegments());
        return this;
    }

    private boolean isTriggerDefined(String streamName, SiddhiApp siddhiApp) {
        return siddhiApp.getTriggerDefinitionMap().size() != 0 && siddhiApp.getTriggerDefinitionMap().containsKey(streamName);
    }

    public EventFlowBuilder loadStreams() {
        StreamDefinitionConfigGenerator streamDefinitionConfigGenerator = new StreamDefinitionConfigGenerator();
        Map streamDefinitionMap = this.siddhiAppRuntime.getStreamDefinitionMap();
        for (Map.Entry streamDefinitionEntry : streamDefinitionMap.entrySet()) {
            if (this.isTriggerDefined((String)streamDefinitionEntry.getKey(), this.siddhiApp)) continue;
            this.siddhiAppConfig.add(streamDefinitionConfigGenerator.generateStreamConfig((StreamDefinition)streamDefinitionEntry.getValue()));
        }
        this.siddhiAppConfig.addElementCodeSegments(streamDefinitionConfigGenerator.getPreservedCodeSegments());
        return this;
    }

    public EventFlowBuilder loadSources() throws DesignGenerationException {
        SourceSinkConfigsGenerator sourceConfigsGenerator = new SourceSinkConfigsGenerator();
        for (List sourceList : this.siddhiAppRuntime.getSources()) {
            for (SourceSinkConfig sourceConfig : sourceConfigsGenerator.generateSourceConfigs(sourceList)) {
                this.siddhiAppConfig.addSource(sourceConfig);
            }
        }
        this.siddhiAppConfig.addElementCodeSegments(sourceConfigsGenerator.getPreservedCodeSegments());
        return this;
    }

    public EventFlowBuilder loadSinks() throws DesignGenerationException {
        SourceSinkConfigsGenerator sinkConfigsGenerator = new SourceSinkConfigsGenerator();
        for (List sinkList : this.siddhiAppRuntime.getSinks()) {
            for (SourceSinkConfig sinkConfig : sinkConfigsGenerator.generateSinkConfigs(sinkList)) {
                this.siddhiAppConfig.addSink(sinkConfig);
            }
        }
        this.siddhiAppConfig.addElementCodeSegments(sinkConfigsGenerator.getPreservedCodeSegments());
        return this;
    }

    public EventFlowBuilder loadTables() throws DesignGenerationException {
        TableConfigGenerator tableConfigGenerator = new TableConfigGenerator();
        for (TableDefinition tableDefinition : this.siddhiApp.getTableDefinitionMap().values()) {
            this.siddhiAppConfig.add(tableConfigGenerator.generateTableConfig(tableDefinition));
        }
        this.siddhiAppConfig.addElementCodeSegments(tableConfigGenerator.getPreservedCodeSegments());
        return this;
    }

    public EventFlowBuilder loadWindows() throws DesignGenerationException {
        WindowConfigGenerator windowConfigGenerator = new WindowConfigGenerator(this.siddhiAppString);
        for (WindowDefinition windowDefinition : this.siddhiApp.getWindowDefinitionMap().values()) {
            this.siddhiAppConfig.add(windowConfigGenerator.generateWindowConfig(windowDefinition));
        }
        this.siddhiAppConfig.addElementCodeSegments(windowConfigGenerator.getPreservedCodeSegments());
        return this;
    }

    public EventFlowBuilder loadAggregations() throws DesignGenerationException {
        AggregationConfigGenerator aggregationConfigGenerator = new AggregationConfigGenerator(this.siddhiAppString);
        for (AggregationDefinition aggregationDefinition : this.siddhiApp.getAggregationDefinitionMap().values()) {
            this.siddhiAppConfig.add(aggregationConfigGenerator.generateAggregationConfig(aggregationDefinition));
        }
        this.siddhiAppConfig.addElementCodeSegments(aggregationConfigGenerator.getPreservedCodeSegments());
        return this;
    }

    public EventFlowBuilder loadFunctions() {
        FunctionConfigGenerator functionConfigGenerator = new FunctionConfigGenerator();
        for (FunctionDefinition functionDefinition : this.siddhiApp.getFunctionDefinitionMap().values()) {
            this.siddhiAppConfig.add(functionConfigGenerator.generateFunctionConfig(functionDefinition));
        }
        this.siddhiAppConfig.addElementCodeSegments(functionConfigGenerator.getPreservedCodeSegments());
        return this;
    }

    public EventFlowBuilder loadExecutionElements() throws DesignGenerationException {
        Map partitionedInnerStreamDefinitions = this.siddhiAppRuntime.getPartitionedInnerStreamDefinitionMap();
        QueryConfigGenerator queryConfigGenerator = new QueryConfigGenerator(this.siddhiAppString, this.siddhiApp);
        PartitionConfigGenerator partitionConfigGenerator = new PartitionConfigGenerator(this.siddhiAppString, this.siddhiApp, partitionedInnerStreamDefinitions);
        int partitionCounter = 0;
        int queryCounter = 0;
        for (ExecutionElement executionElement : this.siddhiApp.getExecutionElementList()) {
            if (executionElement instanceof Query) {
                QueryConfig queryConfig = queryConfigGenerator.generateQueryConfig((Query)executionElement, ++queryCounter);
                this.siddhiAppConfig.addQuery(QueryConfigGenerator.getQueryListType(queryConfig), queryConfig);
                continue;
            }
            if (executionElement instanceof Partition) {
                String partitionId = (String)partitionedInnerStreamDefinitions.keySet().toArray()[partitionCounter];
                this.siddhiAppConfig.addPartition(partitionConfigGenerator.generatePartitionConfig((Partition)executionElement, partitionId));
                ++partitionCounter;
                continue;
            }
            throw new DesignGenerationException("Unable create config for execution element of type unknown");
        }
        this.siddhiAppConfig.addElementCodeSegments(queryConfigGenerator.getPreservedCodeSegments());
        this.siddhiAppConfig.addElementCodeSegments(partitionConfigGenerator.getPreservedCodeSegments());
        return this;
    }

    public EventFlowBuilder loadEdges() throws DesignGenerationException {
        EdgesGenerator edgesGenerator = new EdgesGenerator(this.siddhiAppConfig);
        this.edges = edgesGenerator.generateEdges();
        return this;
    }

    public EventFlowBuilder loadComments() throws DesignGenerationException {
        OuterScopeCommentsPreserver outerScopeCommentsPreserver = new OuterScopeCommentsPreserver(this.siddhiAppString, this.siddhiAppConfig.getElementCodeSegments());
        this.siddhiAppConfig.assignCommentCodeSegments(outerScopeCommentsPreserver.generateCommentCodeSegments());
        this.siddhiAppConfig = outerScopeCommentsPreserver.bindCommentsToElements(this.siddhiAppConfig.getCommentCodeSegments(), this.siddhiAppConfig);
        for (PartitionConfig partitionConfig : this.siddhiAppConfig.getPartitionList()) {
            PartitionScopeCommentsPreserver partitionScopeCommentsPreserver = new PartitionScopeCommentsPreserver(this.siddhiAppString, partitionConfig, this.siddhiAppConfig.getElementCodeSegments());
            this.siddhiAppConfig.clearCommentCodeSegments();
            this.siddhiAppConfig.assignCommentCodeSegments(partitionScopeCommentsPreserver.generateCommentCodeSegments());
            this.siddhiAppConfig = partitionScopeCommentsPreserver.bindCommentsToElements(this.siddhiAppConfig.getCommentCodeSegments(), this.siddhiAppConfig);
        }
        return this;
    }
}

