/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.StreamConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionWithElement;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryConfig;
import io.siddhi.distribution.editor.core.util.designview.constants.query.QueryListType;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.AnnotationConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.CodeSegmentsPreserver;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.StreamDefinitionConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.QueryConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.ConfigBuildingUtilities;
import io.siddhi.query.api.SiddhiApp;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.execution.partition.Partition;
import io.siddhi.query.api.execution.partition.PartitionType;
import io.siddhi.query.api.execution.partition.RangePartitionType;
import io.siddhi.query.api.execution.partition.ValuePartitionType;
import io.siddhi.query.api.execution.query.Query;
import io.siddhi.query.api.expression.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PartitionConfigGenerator
extends CodeSegmentsPreserver {
    private String siddhiAppString;
    private SiddhiApp siddhiApp;
    private Map<String, Map<String, AbstractDefinition>> partitionedInnerStreamDefinitions;
    private Map<String, String> connectorsAndStreams = new HashMap<String, String>();

    public PartitionConfigGenerator(String siddhiAppString, SiddhiApp siddhiApp, Map<String, Map<String, AbstractDefinition>> partitionedInnerStreamDefinitions) {
        this.siddhiAppString = siddhiAppString;
        this.siddhiApp = siddhiApp;
        this.partitionedInnerStreamDefinitions = partitionedInnerStreamDefinitions;
    }

    public PartitionConfig generatePartitionConfig(Partition partition, String partitionId) throws DesignGenerationException {
        PartitionConfig partitionConfig = new PartitionConfig();
        partitionConfig.setQueryLists(this.generateQueryList(partition.getQueryList()));
        partitionConfig.setStreamList(this.generateInnerStreams(this.partitionedInnerStreamDefinitions.get(partitionId).values()));
        partitionConfig.setPartitionWith(this.generatePartitionWith(partition.getPartitionTypeMap()));
        partitionConfig.setAnnotationList(this.generateAnnotations(partition.getAnnotations()));
        partitionConfig.setAnnotationListObjects(partition.getAnnotations());
        partitionConfig.setConnectorsAndStreams(this.connectorsAndStreams);
        this.preserveAndBindCodeSegment((SiddhiElement)partition, partitionConfig);
        return partitionConfig;
    }

    private Map<QueryListType, List<QueryConfig>> generateQueryList(List<Query> queryList) throws DesignGenerationException {
        Map<QueryListType, List<QueryConfig>> queryLists = this.populateEmptyQueryLists();
        QueryConfigGenerator queryConfigGenerator = new QueryConfigGenerator(this.siddhiAppString, this.siddhiApp);
        int queryCounter = 0;
        for (Query query : queryList) {
            QueryConfig queryConfig = queryConfigGenerator.generateQueryConfig(query, ++queryCounter);
            QueryListType queryListType = QueryConfigGenerator.getQueryListType(queryConfig);
            queryLists.get((Object)queryListType).add(queryConfig);
        }
        this.preserveCodeSegmentsOf(queryConfigGenerator);
        return queryLists;
    }

    private Map<QueryListType, List<QueryConfig>> populateEmptyQueryLists() {
        EnumMap<QueryListType, List<QueryConfig>> queryLists = new EnumMap<QueryListType, List<QueryConfig>>(QueryListType.class);
        queryLists.put(QueryListType.WINDOW_FILTER_PROJECTION, new ArrayList());
        queryLists.put(QueryListType.JOIN, new ArrayList());
        queryLists.put(QueryListType.PATTERN, new ArrayList());
        queryLists.put(QueryListType.SEQUENCE, new ArrayList());
        return queryLists;
    }

    private List<StreamConfig> generateInnerStreams(Collection<AbstractDefinition> innerStreamDefinitions) {
        StreamDefinitionConfigGenerator streamDefinitionConfigGenerator = new StreamDefinitionConfigGenerator();
        ArrayList<StreamConfig> innerStreams = new ArrayList<StreamConfig>();
        for (AbstractDefinition innerStreamDefinition : innerStreamDefinitions) {
            if (!(innerStreamDefinition instanceof StreamDefinition)) continue;
            innerStreams.add(streamDefinitionConfigGenerator.generateStreamConfig((StreamDefinition)innerStreamDefinition));
        }
        this.preserveCodeSegmentsOf(streamDefinitionConfigGenerator);
        return innerStreams;
    }

    private List<PartitionWithElement> generatePartitionWith(Map<String, PartitionType> partitionTypeMap) throws DesignGenerationException {
        ArrayList<PartitionWithElement> partitionWithElements = new ArrayList<PartitionWithElement>();
        int partitionConnectorIdCounter = 0;
        for (Map.Entry<String, PartitionType> partitionWithEntry : partitionTypeMap.entrySet()) {
            PartitionWithElement partitionWithElement = this.generatePartitionWithElement(partitionWithEntry);
            this.connectorsAndStreams.put(String.valueOf(++partitionConnectorIdCounter), partitionWithElement.getStreamName());
            partitionWithElements.add(partitionWithElement);
        }
        return partitionWithElements;
    }

    private PartitionWithElement generatePartitionWithElement(Map.Entry<String, PartitionType> partitionWithEntry) throws DesignGenerationException {
        PartitionWithElement partitionWithElement = new PartitionWithElement(this.generatePartitionElementExpression(partitionWithEntry.getValue()), partitionWithEntry.getKey());
        this.preserveAndBindCodeSegment((SiddhiElement)partitionWithEntry.getValue(), partitionWithElement);
        return partitionWithElement;
    }

    private String generatePartitionElementExpression(PartitionType partitionType) throws DesignGenerationException {
        if (partitionType instanceof RangePartitionType) {
            return this.generateRangePartitionExpression(((RangePartitionType)partitionType).getRangePartitionProperties());
        }
        if (partitionType instanceof ValuePartitionType) {
            return this.generateValuePartitionExpression(((ValuePartitionType)partitionType).getExpression());
        }
        throw new DesignGenerationException("Unable to generate expression for Partition element of type unknown");
    }

    private String generateRangePartitionExpression(RangePartitionType.RangePartitionProperty[] rangePartitionProperties) throws DesignGenerationException {
        ArrayList<String> expression = new ArrayList<String>();
        for (RangePartitionType.RangePartitionProperty rangePartitionProperty : rangePartitionProperties) {
            expression.add(ConfigBuildingUtilities.getDefinition((SiddhiElement)rangePartitionProperty, this.siddhiAppString));
        }
        return String.join((CharSequence)" or ", expression);
    }

    private String generateValuePartitionExpression(Expression valuePartitionExpression) throws DesignGenerationException {
        return ConfigBuildingUtilities.getDefinition((SiddhiElement)valuePartitionExpression, this.siddhiAppString);
    }

    private List<String> generateAnnotations(List<Annotation> annotations) {
        AnnotationConfigGenerator annotationConfigGenerator = new AnnotationConfigGenerator();
        List<String> annotationConfigs = annotationConfigGenerator.generateAnnotationConfigList(annotations);
        this.preserveCodeSegmentsOf(annotationConfigGenerator);
        return annotationConfigs;
    }
}

