/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.WindowConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.AnnotationConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.AttributeConfigListGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.CodeSegmentsPreserver;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.ConfigBuildingUtilities;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.definition.WindowDefinition;
import io.siddhi.query.api.expression.Expression;
import java.util.ArrayList;

public class WindowConfigGenerator
extends CodeSegmentsPreserver {
    private String siddhiAppString;

    public WindowConfigGenerator(String siddhiAppString) {
        this.siddhiAppString = siddhiAppString;
    }

    public WindowConfig generateWindowConfig(WindowDefinition windowDefinition) throws DesignGenerationException {
        ArrayList<String> parameters = new ArrayList<String>();
        for (Expression expression : windowDefinition.getWindow().getParameters()) {
            parameters.add(ConfigBuildingUtilities.getDefinition((SiddhiElement)expression, this.siddhiAppString));
        }
        ArrayList<String> annotationConfigs = new ArrayList<String>();
        ArrayList<Annotation> annotationListObjects = new ArrayList<Annotation>();
        AnnotationConfigGenerator annotationConfigGenerator = new AnnotationConfigGenerator();
        AttributeConfigListGenerator attributeConfigListGenerator = new AttributeConfigListGenerator();
        for (Annotation annotation : windowDefinition.getAnnotations()) {
            annotationListObjects.add(annotation);
            annotationConfigs.add(annotationConfigGenerator.generateAnnotationConfig(annotation));
        }
        WindowConfig windowConfig = new WindowConfig(windowDefinition.getId(), windowDefinition.getId(), attributeConfigListGenerator.generateAttributeConfigList(windowDefinition.getAttributeList()), windowDefinition.getWindow().getName(), parameters, windowDefinition.getOutputEventType().name(), annotationConfigs, annotationListObjects);
        this.preserveCodeSegmentsOf(annotationConfigGenerator, attributeConfigListGenerator);
        this.preserveAndBindCodeSegment((SiddhiElement)windowDefinition, windowConfig);
        return windowConfig;
    }
}

