/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.commentspreserver;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.CommentCodeSegment;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.ElementCodeSegment;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.SiddhiAppConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.FunctionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.StreamConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.TableConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.TriggerConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.WindowConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.AggregationConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.SourceSinkConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.commentspreserver.ScopedCommentsPreserver;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OuterScopeCommentsPreserver
extends ScopedCommentsPreserver {
    public OuterScopeCommentsPreserver(String siddhiAppString, Set<ElementCodeSegment> elementCodeSegments) {
        super(siddhiAppString, new ArrayList<ElementCodeSegment>(elementCodeSegments));
    }

    @Override
    public List<CommentCodeSegment> generateCommentCodeSegments() throws DesignGenerationException {
        Collections.sort(this.elementCodeSegments);
        this.elementCodeSegments = this.filterMajorElementCodeSegments(this.elementCodeSegments);
        this.commentCodeSegments = this.detectCommentCodeSegments(this.elementCodeSegments);
        return this.commentCodeSegments;
    }

    @Override
    public SiddhiAppConfig bindCommentsToElements(Collection<CommentCodeSegment> commentCodeSegments, SiddhiAppConfig siddhiAppConfigReference) {
        for (SourceSinkConfig sourceSinkConfig : siddhiAppConfigReference.getSourceList()) {
            this.assignPreviousCommentSegment(sourceSinkConfig, commentCodeSegments);
        }
        for (SourceSinkConfig sourceSinkConfig : siddhiAppConfigReference.getSinkList()) {
            this.assignPreviousCommentSegment(sourceSinkConfig, commentCodeSegments);
        }
        for (StreamConfig streamConfig : siddhiAppConfigReference.getStreamList()) {
            this.assignPreviousCommentSegment(streamConfig, commentCodeSegments);
        }
        for (TableConfig tableConfig : siddhiAppConfigReference.getTableList()) {
            this.assignPreviousCommentSegment(tableConfig, commentCodeSegments);
        }
        for (TriggerConfig triggerConfig : siddhiAppConfigReference.getTriggerList()) {
            this.assignPreviousCommentSegment(triggerConfig, commentCodeSegments);
        }
        for (WindowConfig windowConfig : siddhiAppConfigReference.getWindowList()) {
            this.assignPreviousCommentSegment(windowConfig, commentCodeSegments);
        }
        for (AggregationConfig aggregationConfig : siddhiAppConfigReference.getAggregationList()) {
            this.assignPreviousCommentSegment(aggregationConfig, commentCodeSegments);
        }
        for (FunctionConfig functionConfig : siddhiAppConfigReference.getFunctionList()) {
            this.assignPreviousCommentSegment(functionConfig, commentCodeSegments);
        }
        for (Map.Entry entry : siddhiAppConfigReference.getQueryLists().entrySet()) {
            for (QueryConfig queryConfig : (List)entry.getValue()) {
                this.assignPreviousCommentSegment(queryConfig, commentCodeSegments);
            }
        }
        for (PartitionConfig partitionConfig : siddhiAppConfigReference.getPartitionList()) {
            this.assignPreviousCommentSegment(partitionConfig, commentCodeSegments);
        }
        return siddhiAppConfigReference;
    }
}

