/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.commentspreserver;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.CommentCodeSegment;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.ElementCodeSegment;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.SiddhiAppConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.SiddhiElementConfig;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.ConfigBuildingUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class ScopedCommentsPreserver {
    protected String siddhiAppString;
    protected List<ElementCodeSegment> elementCodeSegments;
    protected List<CommentCodeSegment> commentCodeSegments = new ArrayList<CommentCodeSegment>();

    public ScopedCommentsPreserver(String siddhiAppString, List<ElementCodeSegment> elementCodeSegments) {
        this.siddhiAppString = siddhiAppString;
        this.elementCodeSegments = elementCodeSegments;
    }

    public abstract List<CommentCodeSegment> generateCommentCodeSegments() throws DesignGenerationException;

    public abstract SiddhiAppConfig bindCommentsToElements(Collection<CommentCodeSegment> var1, SiddhiAppConfig var2);

    protected List<CommentCodeSegment> detectCommentCodeSegments(List<ElementCodeSegment> elementCodeSegments) throws DesignGenerationException {
        ArrayList<CommentCodeSegment> detectedCommentCodeSegments = new ArrayList<CommentCodeSegment>();
        for (int i = 1; i < elementCodeSegments.size(); ++i) {
            CommentCodeSegment codeSegmentInBetween;
            if (!this.hasCodeSegmentInBetween(elementCodeSegments.get(i - 1), elementCodeSegments.get(i)) || !this.isCommentValid(codeSegmentInBetween = this.getCodeSegmentInBetween(elementCodeSegments.get(i - 1), elementCodeSegments.get(i)))) continue;
            detectedCommentCodeSegments.add(codeSegmentInBetween);
        }
        return detectedCommentCodeSegments;
    }

    protected void assignPreviousCommentSegment(SiddhiElementConfig siddhiElementConfigReference, Collection<CommentCodeSegment> commentCodeSegments) {
        siddhiElementConfigReference.setPreviousCommentSegment(this.findPreviousCommentCodeSegment(siddhiElementConfigReference, commentCodeSegments));
    }

    protected CommentCodeSegment findPreviousCommentCodeSegment(SiddhiElementConfig siddhiElementConfig, Collection<CommentCodeSegment> commentCodeSegments) {
        int[] previousCommentCodeSegmentEndIndex = this.getPreviousCommentCodeSegmentEndIndexes(siddhiElementConfig.getQueryContextStartIndex());
        if (previousCommentCodeSegmentEndIndex == null) {
            return null;
        }
        CommentCodeSegment commentCodeSegment = this.findCommentCodeSegmentEndingWith(previousCommentCodeSegmentEndIndex, commentCodeSegments);
        if (commentCodeSegment != null) {
            commentCodeSegments.remove(commentCodeSegment);
        }
        return commentCodeSegment;
    }

    protected boolean hasCodeSegmentInBetween(ElementCodeSegment previousSegment, ElementCodeSegment currentSegment) {
        return this.getCharCountFromLineAndColumn(currentSegment.getStartLine(), currentSegment.getStartColumn(), this.siddhiAppString) - this.getCharCountFromLineAndColumn(previousSegment.getEndLine(), previousSegment.getEndColumn(), this.siddhiAppString) > 1;
    }

    protected boolean isCommentValid(CommentCodeSegment commentCodeSegment) {
        if (commentCodeSegment == null) {
            return false;
        }
        if (commentCodeSegment.getEndLine() < commentCodeSegment.getStartLine()) {
            return false;
        }
        if (commentCodeSegment.getEndLine() == commentCodeSegment.getStartLine()) {
            return commentCodeSegment.getEndColumn() >= commentCodeSegment.getStartColumn() && commentCodeSegment.getEndColumn() != commentCodeSegment.getStartColumn();
        }
        return true;
    }

    protected CommentCodeSegment getCodeSegmentInBetween(ElementCodeSegment previous, ElementCodeSegment current) throws DesignGenerationException {
        int[][] inBetweenIndexes = this.getIndexesInBetween(previous.getQueryContextEndIndex(), current.getQueryContextStartIndex());
        if (inBetweenIndexes[0] == null || inBetweenIndexes[1] == null) {
            return null;
        }
        String comment = ConfigBuildingUtilities.getStringWithQueryContextIndexes(inBetweenIndexes[0], inBetweenIndexes[1], this.siddhiAppString);
        if (comment.charAt(0) == ';') {
            int[] nArray = inBetweenIndexes[0];
            nArray[1] = nArray[1] + 1;
        }
        return new CommentCodeSegment(inBetweenIndexes[0], inBetweenIndexes[1], ConfigBuildingUtilities.getStringWithQueryContextIndexes(inBetweenIndexes[0], inBetweenIndexes[1], this.siddhiAppString));
    }

    protected List<ElementCodeSegment> filterMajorElementCodeSegments(List<ElementCodeSegment> elementCodeSegments) {
        ArrayList<ElementCodeSegment> filteredElementCodeSegments = new ArrayList<ElementCodeSegment>();
        for (ElementCodeSegment currentSegment : elementCodeSegments) {
            if (this.isContainedInAnySegment(currentSegment, elementCodeSegments)) continue;
            filteredElementCodeSegments.add(currentSegment);
        }
        return filteredElementCodeSegments;
    }

    private boolean isContainedInAnySegment(ElementCodeSegment elementCodeSegment, List<ElementCodeSegment> elementCodeSegments) {
        boolean isContainedInAnySegment = false;
        for (ElementCodeSegment comparedSegment : elementCodeSegments) {
            if (elementCodeSegment.equals(comparedSegment) || !this.isSegmentContainedIn(elementCodeSegment, comparedSegment)) continue;
            isContainedInAnySegment = true;
            break;
        }
        return isContainedInAnySegment;
    }

    public CommentCodeSegment getCommentSegmentBeforeContent() throws DesignGenerationException {
        return this.getCommentSegmentBeforeContent(this.elementCodeSegments.get(0));
    }

    private CommentCodeSegment getCommentSegmentBeforeContent(ElementCodeSegment firstElementCodeSegment) throws DesignGenerationException {
        if (firstElementCodeSegment.getStartLine() != 1 || firstElementCodeSegment.getStartColumn() != 0) {
            int[] firstCommentEndingLineAndColumn = this.getPreviousQueryIndexes(firstElementCodeSegment.getQueryContextStartIndex(), this.siddhiAppString);
            if (firstCommentEndingLineAndColumn == null) {
                return null;
            }
            return new CommentCodeSegment(new int[]{1, 0}, firstCommentEndingLineAndColumn, ConfigBuildingUtilities.getStringWithQueryContextIndexes(new int[]{1, 0}, firstCommentEndingLineAndColumn, this.siddhiAppString));
        }
        return null;
    }

    protected boolean isSegmentContainedIn(ElementCodeSegment containedElement, ElementCodeSegment containerElement) {
        int containedStart = this.getCharCountFromLineAndColumn(containedElement.getStartLine(), containedElement.getStartColumn(), this.siddhiAppString);
        int containedEnd = this.getCharCountFromLineAndColumn(containedElement.getEndLine(), containedElement.getEndColumn(), this.siddhiAppString);
        int containerStart = this.getCharCountFromLineAndColumn(containerElement.getStartLine(), containerElement.getStartColumn(), this.siddhiAppString);
        int containerEnd = this.getCharCountFromLineAndColumn(containerElement.getEndLine(), containerElement.getEndColumn(), this.siddhiAppString);
        if (containedStart < containedEnd && containedStart != -1 && containedEnd != -1 && containerStart != -1 && containerEnd != -1) {
            return containerStart <= containedStart && containedEnd <= containerEnd;
        }
        return false;
    }

    protected int[][] getIndexesInBetween(int[] prevIndex, int[] current) {
        return new int[][]{this.getNextQueryIndexes(prevIndex, this.siddhiAppString), this.getPreviousQueryIndexes(current, this.siddhiAppString)};
    }

    protected int[] getPreviousQueryIndexes(int[] queryIndexes, String siddhiAppString) {
        if (queryIndexes[1] == 0) {
            String previousLineContent = this.getLineContent(queryIndexes[0] - 1, siddhiAppString);
            if (previousLineContent != null) {
                return new int[]{queryIndexes[0] - 1, previousLineContent.length()};
            }
        } else {
            return new int[]{queryIndexes[0], queryIndexes[1]};
        }
        return null;
    }

    protected int[] getNextQueryIndexes(int[] queryIndexes, String siddhiAppString) {
        String lineContent = this.getLineContent(queryIndexes[0], siddhiAppString);
        if (lineContent != null) {
            if (lineContent.length() == queryIndexes[1]) {
                return new int[]{queryIndexes[0] + 1, 0};
            }
            return new int[]{queryIndexes[0], queryIndexes[1]};
        }
        return null;
    }

    protected String getLineContent(int lineNo, String siddhiAppString) {
        int lineCounter = 1;
        int charCounter = 0;
        for (char character : siddhiAppString.toCharArray()) {
            if (lineNo == lineCounter) {
                String subString = siddhiAppString.substring(charCounter);
                return subString.split("\n")[0] + "\n";
            }
            if (character == '\n') {
                ++lineCounter;
            }
            ++charCounter;
        }
        return null;
    }

    protected int[] getPreviousCommentCodeSegmentEndIndexes(int[] currentStartIndexes) {
        if (currentStartIndexes[0] != 0 || currentStartIndexes[1] != 0) {
            return this.getPreviousQueryIndexes(currentStartIndexes, this.siddhiAppString);
        }
        return null;
    }

    protected CommentCodeSegment findCommentCodeSegmentEndingWith(int[] endIndexes, Collection<CommentCodeSegment> commentCodeSegments) {
        for (CommentCodeSegment commentCodeSegment : commentCodeSegments) {
            int[] commentSegmentEndIndex;
            if (commentCodeSegment == null || (commentSegmentEndIndex = commentCodeSegment.getQueryContextEndIndex()) == null || commentSegmentEndIndex[0] != endIndexes[0] || commentSegmentEndIndex[1] != endIndexes[1]) continue;
            return commentCodeSegment;
        }
        return null;
    }

    protected int getCharCountFromLineAndColumn(int line, int column, String siddhiAppString) {
        int characterCounter = 0;
        for (int l = 1; l < line; ++l) {
            String lineContent = this.getLineContent(l, siddhiAppString);
            if (lineContent == null) continue;
            characterCounter += lineContent.length() + 1;
        }
        String requiredLineContent = this.getLineContent(line, siddhiAppString);
        if (requiredLineContent != null) {
            for (int c = 0; c <= requiredLineContent.length(); ++c) {
                if (c == column) {
                    return characterCounter;
                }
                ++characterCounter;
            }
        }
        return -1;
    }
}

