/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.windowfilterprojection.WindowFilterProjectionConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.streamhandler.StreamHandlerConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.query.api.execution.query.input.handler.StreamFunction;
import io.siddhi.query.api.execution.query.input.handler.StreamHandler;
import io.siddhi.query.api.execution.query.input.handler.Window;
import io.siddhi.query.api.execution.query.input.stream.InputStream;
import io.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import java.util.List;

public class WindowFilterProjectionConfigGenerator {
    private String siddhiAppString;

    public WindowFilterProjectionConfigGenerator(String siddhiAppString) {
        this.siddhiAppString = siddhiAppString;
    }

    public WindowFilterProjectionConfig generateWindowFilterProjectionConfig(InputStream queryInputStream) throws DesignGenerationException {
        return new WindowFilterProjectionConfig(this.getType(queryInputStream).toString(), (String)queryInputStream.getUniqueStreamIds().get(0), new StreamHandlerConfigGenerator(this.siddhiAppString).generateStreamHandlerConfigList(((SingleInputStream)queryInputStream).getStreamHandlers()));
    }

    private WindowFilterProjectionQueryType getType(InputStream queryInputStream) {
        List streamHandlers = ((SingleInputStream)queryInputStream).getStreamHandlers();
        if (streamHandlers.isEmpty()) {
            return WindowFilterProjectionQueryType.PROJECTION;
        }
        for (StreamHandler streamHandler : streamHandlers) {
            if (!(streamHandler instanceof StreamFunction)) continue;
            return WindowFilterProjectionQueryType.FUNCTION;
        }
        for (StreamHandler streamHandler : streamHandlers) {
            if (!(streamHandler instanceof Window)) continue;
            return WindowFilterProjectionQueryType.WINDOW;
        }
        return WindowFilterProjectionQueryType.FILTER;
    }

    private static enum WindowFilterProjectionQueryType {
        PROJECTION,
        FILTER,
        FUNCTION,
        WINDOW;

    }
}

