/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.streamhandler;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.streamhandler.FilterConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.streamhandler.FunctionWindowConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.streamhandler.FunctionWindowValue;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.streamhandler.StreamHandlerConfig;
import io.siddhi.distribution.editor.core.util.designview.constants.query.StreamHandlerType;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.ConfigBuildingUtilities;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.execution.query.input.handler.Filter;
import io.siddhi.query.api.execution.query.input.handler.StreamFunction;
import io.siddhi.query.api.execution.query.input.handler.StreamHandler;
import io.siddhi.query.api.execution.query.input.handler.Window;
import io.siddhi.query.api.expression.Expression;
import java.util.ArrayList;
import java.util.List;

public class StreamHandlerConfigGenerator {
    private String siddhiAppString;

    public StreamHandlerConfigGenerator(String siddhiAppString) {
        this.siddhiAppString = siddhiAppString;
    }

    public List<StreamHandlerConfig> generateStreamHandlerConfigList(List<StreamHandler> streamHandlers) throws DesignGenerationException {
        ArrayList<StreamHandlerConfig> streamHandlerConfigList = new ArrayList<StreamHandlerConfig>();
        for (StreamHandler streamHandler : streamHandlers) {
            streamHandlerConfigList.add(this.generateStreamHandlerConfig(streamHandler));
        }
        return streamHandlerConfigList;
    }

    private StreamHandlerConfig generateStreamHandlerConfig(StreamHandler streamHandler) throws DesignGenerationException {
        if (streamHandler instanceof Filter) {
            return this.generateFilterConfig((Filter)streamHandler);
        }
        if (streamHandler instanceof StreamFunction) {
            return this.generateFunction((StreamFunction)streamHandler);
        }
        if (streamHandler instanceof Window) {
            return this.generateWindow((Window)streamHandler);
        }
        throw new DesignGenerationException("Unknown type of StreamHandler for generating config");
    }

    private FilterConfig generateFilterConfig(Filter filter) throws DesignGenerationException {
        String filterDefinition = ConfigBuildingUtilities.getDefinition((SiddhiElement)filter, this.siddhiAppString);
        return new FilterConfig(filterDefinition.substring(1, filterDefinition.length() - 1).trim());
    }

    private FunctionWindowConfig generateFunction(StreamFunction streamFunction) throws DesignGenerationException {
        StringBuilder function = new StringBuilder();
        if (streamFunction.getNamespace() != null && !streamFunction.getNamespace().isEmpty()) {
            function.append(streamFunction.getNamespace());
            function.append(":");
        }
        function.append(streamFunction.getName());
        return new FunctionWindowConfig(StreamHandlerType.FUNCTION.toString(), new FunctionWindowValue(function.toString(), this.generateParameters(streamFunction.getParameters())));
    }

    private FunctionWindowConfig generateWindow(Window window) throws DesignGenerationException {
        StringBuilder function = new StringBuilder();
        if (window.getNamespace() != null && !window.getNamespace().isEmpty()) {
            function.append(window.getNamespace());
            function.append(":");
        }
        function.append(window.getName());
        return new FunctionWindowConfig(StreamHandlerType.WINDOW.toString(), new FunctionWindowValue(function.toString(), this.generateParameters(window.getParameters())));
    }

    private List<String> generateParameters(Expression[] parameters) throws DesignGenerationException {
        ArrayList<String> parameterStrings = new ArrayList<String>();
        if (parameters == null) {
            return null;
        }
        for (Expression parameter : parameters) {
            parameterStrings.add(ConfigBuildingUtilities.getDefinition((SiddhiElement)parameter, this.siddhiAppString));
        }
        return parameterStrings;
    }
}

