/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.org.apache.http.client.protocol;

import com.spotify.docker.client.shaded.org.apache.http.HttpEntity;
import com.spotify.docker.client.shaded.org.apache.http.HttpEntityEnclosingRequest;
import com.spotify.docker.client.shaded.org.apache.http.HttpException;
import com.spotify.docker.client.shaded.org.apache.http.HttpRequest;
import com.spotify.docker.client.shaded.org.apache.http.HttpRequestInterceptor;
import com.spotify.docker.client.shaded.org.apache.http.HttpVersion;
import com.spotify.docker.client.shaded.org.apache.http.ProtocolVersion;
import com.spotify.docker.client.shaded.org.apache.http.annotation.Immutable;
import com.spotify.docker.client.shaded.org.apache.http.client.config.RequestConfig;
import com.spotify.docker.client.shaded.org.apache.http.client.protocol.HttpClientContext;
import com.spotify.docker.client.shaded.org.apache.http.protocol.HttpContext;
import com.spotify.docker.client.shaded.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

