/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.internal;

import io.siddhi.distribution.editor.core.exception.NoSuchSiddhiAppException;
import io.siddhi.distribution.editor.core.internal.DebugRuntime;
import io.siddhi.distribution.editor.core.internal.EditorDataHolder;

public class DebugProcessorService {
    public DebugRuntime getSiddhiAppRuntimeHolder(String siddhiAppName) {
        return EditorDataHolder.getSiddhiAppMap().get(siddhiAppName);
    }

    public synchronized void start(String siddhiAppName) {
        DebugRuntime runtimeHolder;
        if (EditorDataHolder.getSiddhiAppMap().containsKey(siddhiAppName)) {
            runtimeHolder = EditorDataHolder.getSiddhiAppMap().get(siddhiAppName);
            if (runtimeHolder.getMode() == DebugRuntime.Mode.FAULTY) {
                DebugRuntime recreatedRuntimeHolder;
                runtimeHolder = recreatedRuntimeHolder = new DebugRuntime(siddhiAppName, runtimeHolder.getSiddhiApp());
                EditorDataHolder.getSiddhiAppMap().put(siddhiAppName, recreatedRuntimeHolder);
            }
        } else {
            throw new NoSuchSiddhiAppException(String.format("Siddhi App %s does not exists", siddhiAppName));
        }
        runtimeHolder.start();
    }

    public synchronized void debug(String siddhiAppName) {
        if (!EditorDataHolder.getSiddhiAppMap().containsKey(siddhiAppName)) {
            throw new NoSuchSiddhiAppException(String.format("Siddhi App %s does not exists", siddhiAppName));
        }
        DebugRuntime runtimeHolder = EditorDataHolder.getSiddhiAppMap().get(siddhiAppName);
        runtimeHolder.debug();
    }

    public synchronized void stop(String siddhiAppName) {
        if (!EditorDataHolder.getSiddhiAppMap().containsKey(siddhiAppName)) {
            throw new NoSuchSiddhiAppException(String.format("Siddhi App %s does not exists", siddhiAppName));
        }
        DebugRuntime runtimeHolder = EditorDataHolder.getSiddhiAppMap().get(siddhiAppName);
        runtimeHolder.stop();
    }

    public synchronized void deploy(String siddhiAppName, String siddhiApp) {
        if (!EditorDataHolder.getSiddhiAppMap().containsKey(siddhiAppName)) {
            DebugRuntime runtimeHolder = new DebugRuntime(siddhiAppName, siddhiApp);
            EditorDataHolder.getSiddhiAppMap().put(siddhiAppName, runtimeHolder);
        } else {
            EditorDataHolder.getSiddhiAppMap().get(siddhiAppName).reload(siddhiApp);
        }
    }

    public synchronized void undeploy(String siddhiAppName) {
        if (!EditorDataHolder.getSiddhiAppMap().containsKey(siddhiAppName)) {
            throw new NoSuchSiddhiAppException(String.format("Siddhi App %s does not exists", siddhiAppName));
        }
        DebugRuntime runtimeHolder = EditorDataHolder.getSiddhiAppMap().get(siddhiAppName);
        runtimeHolder.stop();
        EditorDataHolder.getSiddhiAppMap().remove(siddhiAppName);
    }
}

