/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.siddhi.distribution.editor.log.appender.appender.DataHolder;
import io.siddhi.distribution.editor.log.appender.appender.internal.CircularBuffer;
import io.siddhi.distribution.editor.log.appender.appender.internal.ConsoleLogEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.server.ServerEndpoint;
import org.apache.log4j.helpers.LogLog;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.websocket.WebSocketEndpoint;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;

@ServerEndpoint(value="/console")
@Component(name="editor-console-service", service={WebSocketEndpoint.class}, immediate=true)
public class EditorConsoleService
implements WebSocketEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorConsoleService.class);
    private static final int SCHEDULER_INITIAL_DELAY = 1000;
    private static final int SCHEDULER_TERMINATION_DELAY = 50;
    private SimpleDateFormat timeFormatter = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS");
    private WebSocketConnection webSocketConnection;
    private ScheduledExecutorService scheduler;
    private CircularBuffer<ConsoleLogEvent> circularBuffer = DataHolder.getBuffer();

    @OnOpen
    public void onOpen(WebSocketConnection webSocketConnection) {
        if (this.webSocketConnection != null) {
            this.onClose(this.webSocketConnection);
        }
        this.webSocketConnection = webSocketConnection;
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleWithFixedDelay(new LogPublisherTask(), 1000L, 50L, TimeUnit.MILLISECONDS);
        LOGGER.info("Connected with user : " + webSocketConnection.getChannelId());
    }

    @OnMessage
    public void onMessage(String text, WebSocketConnection webSocketConnection) {
        if (webSocketConnection.isOpen()) {
            webSocketConnection.pushText("Welcome to Siddhi Editor");
            LOGGER.info("Received message : " + text);
        }
    }

    @OnClose
    public void onClose(WebSocketConnection webSocketConnection) {
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown();
                this.scheduler.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
                LOGGER.error("Interrupted while awaiting for Schedule Executor termination" + e.getMessage(), (Throwable)e);
            }
        }
        if (webSocketConnection.isOpen()) {
            try {
                ConsoleLogEvent clientCloseEvent = new ConsoleLogEvent();
                clientCloseEvent.setMessage("Connection closed (Possibly due to opening the editor in a new Tab/Window)! Refresh to reconnect the console.");
                clientCloseEvent.setLevel("ERROR");
                clientCloseEvent.setFqcn(EditorConsoleService.class.getCanonicalName());
                String timeString = this.timeFormatter.format(System.currentTimeMillis());
                clientCloseEvent.setTimeStamp(timeString);
                String jsonString = this.getJsonString(clientCloseEvent);
                webSocketConnection.pushText(jsonString);
                webSocketConnection.terminateConnection();
            }
            catch (IOException e) {
                LOGGER.error("Inturrupted while awaiting for Session termination" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void broadcastConsoleOutput(List<ConsoleLogEvent> event) {
        for (ConsoleLogEvent logEvent : event) {
            if (!this.webSocketConnection.isOpen()) continue;
            try {
                String jsonString = this.getJsonString(logEvent);
                this.webSocketConnection.pushText(jsonString);
            }
            catch (IOException e) {
                LogLog.error((String)("Editor Console Appender cannot publish log event, " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private String getJsonString(ConsoleLogEvent logEvent) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)logEvent);
    }

    private final class LogPublisherTask
    implements Runnable {
        private LogPublisherTask() {
        }

        @Override
        public void run() {
            try {
                List logEvents = EditorConsoleService.this.circularBuffer.get(EditorConsoleService.this.circularBuffer.getAmount());
                if (!logEvents.isEmpty()) {
                    EditorConsoleService.this.broadcastConsoleOutput(logEvents);
                    EditorConsoleService.this.circularBuffer.clear();
                }
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
                LogLog.error((String)("LogEventAppender cannot publish log events, " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

