/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.internal;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import feign.Response;
import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.SiddhiManager;
import io.siddhi.core.debugger.SiddhiDebugger;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.util.SiddhiComponentActivator;
import io.siddhi.core.util.config.ConfigManager;
import io.siddhi.distribution.common.common.EventStreamService;
import io.siddhi.distribution.common.common.SiddhiAppRuntimeService;
import io.siddhi.distribution.common.common.utils.config.FileConfigManager;
import io.siddhi.distribution.editor.core.EditorSiddhiAppRuntimeService;
import io.siddhi.distribution.editor.core.Workspace;
import io.siddhi.distribution.editor.core.commons.configs.DockerBuildConfig;
import io.siddhi.distribution.editor.core.commons.metadata.MetaData;
import io.siddhi.distribution.editor.core.commons.request.AppStartRequest;
import io.siddhi.distribution.editor.core.commons.request.ExportAppsRequest;
import io.siddhi.distribution.editor.core.commons.request.ValidationRequest;
import io.siddhi.distribution.editor.core.commons.response.DebugRuntimeResponse;
import io.siddhi.distribution.editor.core.commons.response.GeneralResponse;
import io.siddhi.distribution.editor.core.commons.response.MetaDataResponse;
import io.siddhi.distribution.editor.core.commons.response.Status;
import io.siddhi.distribution.editor.core.commons.response.ValidationSuccessResponse;
import io.siddhi.distribution.editor.core.exception.DockerGenerationException;
import io.siddhi.distribution.editor.core.exception.InvalidExecutionStateException;
import io.siddhi.distribution.editor.core.exception.KubernetesGenerationException;
import io.siddhi.distribution.editor.core.exception.SiddhiAppDeployerServiceStubException;
import io.siddhi.distribution.editor.core.exception.SiddhiStoreQueryHelperException;
import io.siddhi.distribution.editor.core.internal.DebugProcessorService;
import io.siddhi.distribution.editor.core.internal.DebugRuntime;
import io.siddhi.distribution.editor.core.internal.DebuggerEventStreamService;
import io.siddhi.distribution.editor.core.internal.DockerBuilder;
import io.siddhi.distribution.editor.core.internal.DockerBuilderStatus;
import io.siddhi.distribution.editor.core.internal.EditorDataHolder;
import io.siddhi.distribution.editor.core.internal.ExportUtils;
import io.siddhi.distribution.editor.core.internal.local.LocalFSWorkspace;
import io.siddhi.distribution.editor.core.util.Constants;
import io.siddhi.distribution.editor.core.util.DebugCallbackEvent;
import io.siddhi.distribution.editor.core.util.DebugStateHolder;
import io.siddhi.distribution.editor.core.util.FileJsonObjectReaderUtil;
import io.siddhi.distribution.editor.core.util.LogEncoder;
import io.siddhi.distribution.editor.core.util.MimeMapper;
import io.siddhi.distribution.editor.core.util.SampleEventGenerator;
import io.siddhi.distribution.editor.core.util.SecurityUtil;
import io.siddhi.distribution.editor.core.util.SourceEditorUtils;
import io.siddhi.distribution.editor.core.util.designview.beans.EventFlow;
import io.siddhi.distribution.editor.core.util.designview.beans.ToolTip;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.SiddhiAppConfig;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.CodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.deserializers.DeserializersRegisterer;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.DesignGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.distribution.editor.core.util.restclients.storequery.StoreQueryAPIHelper;
import io.siddhi.distribution.editor.core.util.siddhiappdeployer.SiddhiAppDeployerApiHelper;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.exception.SiddhiAppContextException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.api.AnalyticsHttpClientBuilderService;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.Request;

@javax.ws.rs.Path(value="/editor")
@Component(service={Microservice.class}, immediate=true)
public class EditorMicroservice
implements Microservice {
    private static final Logger log = LoggerFactory.getLogger(EditorMicroservice.class);
    private static final String FILE_SEPARATOR = "file.separator";
    private static final String STATUS = "status";
    private static final String SUCCESS = "success";
    private static final String EXPORT_TYPE_KUBERNETES = "kubernetes";
    private static final String EXPORT_REQUEST_TYPE_DOWNLOAD_ONLY = "downloadOnly";
    private static final String EXPORT_REQUEST_TYPE_BUILD_ONLY = "buildOnly";
    private static final String EXPORT_REQUEST_GET_STATUS_HEADER = "Siddhi-Docker-Key";
    private ServiceRegistration serviceRegistration;
    private Workspace workspace;
    private ExecutorService executorService = Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setNameFormat("Debugger-scheduler-thread-%d").build());
    private ConfigProvider configProvider;
    private ServiceRegistration siddhiAppRuntimeServiceRegistration;
    private StoreQueryAPIHelper storeQueryAPIHelper;
    private Map<String, DockerBuilderStatus> dockerBuilderStatusMap = new HashMap<String, DockerBuilderStatus>();

    public EditorMicroservice() {
        this.workspace = new LocalFSWorkspace();
    }

    private File getResourceAsFile(String resourcePath) {
        try {
            InputStream in = this.getClass().getResource(resourcePath).openStream();
            if (in == null) {
                return null;
            }
            File tempFile = File.createTempFile(String.valueOf(in.hashCode()), ".tmp");
            tempFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(tempFile);
            IOUtils.copy(in, (OutputStream)out);
            return tempFile;
        }
        catch (Throwable e) {
            log.warn("Couldn't load requested resource: " + resourcePath);
            return null;
        }
    }

    @GET
    public javax.ws.rs.core.Response handleRoot(@Context Request request) throws FileNotFoundException {
        return this.handleGet(request);
    }

    @GET
    @javax.ws.rs.Path(value="/**")
    public javax.ws.rs.core.Response handleGet(@Context Request request) throws FileNotFoundException {
        String mimeType;
        int uriPathEndIndex;
        String rawUri = request.getUri().replaceFirst("^/editor", "");
        String rawUriPath = rawUri == null || rawUri.trim().length() == 0 || "/".equals(rawUri) ? "/index.html" : ((uriPathEndIndex = rawUri.indexOf(63)) != -1 ? rawUri.substring(0, uriPathEndIndex) : rawUri);
        try {
            mimeType = MimeMapper.getMimeType(FilenameUtils.getExtension(rawUriPath));
        }
        catch (Throwable ignored) {
            mimeType = "text/plain";
        }
        File file = this.getResourceAsFile("/web" + rawUriPath);
        if (file != null) {
            return javax.ws.rs.core.Response.ok((Object)new FileInputStream(file)).type(mimeType).build();
        }
        log.error(" File not found [" + rawUriPath + "], Requesting path [" + rawUriPath + "] ");
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    @javax.ws.rs.Path(value="/validator")
    public javax.ws.rs.core.Response validateSiddhiApp(String validationRequestString) {
        ValidationRequest validationRequest = (ValidationRequest)new Gson().fromJson(validationRequestString, ValidationRequest.class);
        String jsonString = "";
        try {
            String siddhiApp = validationRequest.getSiddhiApp();
            if (validationRequest.getVariables().size() != 0) {
                siddhiApp = SourceEditorUtils.populateSiddhiAppWithVars(validationRequest.getVariables(), siddhiApp);
            }
            if (EditorDataHolder.getSiddhiManager() != null) {
                SiddhiAppRuntime siddhiAppRuntime = EditorDataHolder.getSiddhiManager().createSiddhiAppRuntime(siddhiApp);
                String siddhiAppName = siddhiAppRuntime.getName();
                DebugRuntime debugRuntime = EditorDataHolder.getSiddhiAppMap().get(siddhiAppName);
                if (debugRuntime != null) {
                    debugRuntime.setSiddhiAppRuntime(siddhiAppRuntime);
                    debugRuntime.setMode(DebugRuntime.Mode.STOP);
                    EditorDataHolder.getSiddhiAppMap().put(siddhiAppName, debugRuntime);
                }
                ValidationSuccessResponse response = new ValidationSuccessResponse(Status.SUCCESS);
                if (validationRequest.getMissingStreams() != null) {
                    response.setStreams(SourceEditorUtils.getStreamDefinitions(siddhiAppRuntime, validationRequest.getMissingStreams()));
                }
                if (validationRequest.getMissingAggregationDefinitions() != null) {
                    response.setAggregationDefinitions(SourceEditorUtils.getAggregationDefinitions(siddhiAppRuntime, validationRequest.getMissingAggregationDefinitions()));
                }
                jsonString = new Gson().toJson((Object)response);
            }
        }
        catch (Throwable t) {
            if (t instanceof SiddhiAppContextException && ((SiddhiAppContextException)t).getMessageWithOutContext() == null) {
                SiddhiAppContextException e = (SiddhiAppContextException)t;
                SiddhiAppCreationException appCreationException = new SiddhiAppCreationException(ExceptionUtils.getStackTrace(t), t, e.getQueryContextStartIndex(), e.getQueryContextEndIndex());
                jsonString = new Gson().toJson((Object)appCreationException);
            }
            jsonString = new Gson().toJson((Object)t);
        }
        return javax.ws.rs.core.Response.ok((Object)jsonString, (String)"application/json").build();
    }

    @GET
    @javax.ws.rs.Path(value="/workspace/root")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response root() {
        try {
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)this.workspace.listRoots()).type("application/json").build();
        }
        catch (IOException e) {
            return javax.ws.rs.core.Response.serverError().entity((Object)("failed." + e.getMessage())).build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @POST
    @javax.ws.rs.Path(value="/query")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response executeStoreQuery(JsonElement element, @Context Request request) {
        if (this.storeQueryAPIHelper == null) {
            this.storeQueryAPIHelper = new StoreQueryAPIHelper(this.configProvider);
        }
        try {
            Response response = this.storeQueryAPIHelper.executeStoreQuery(element.toString());
            String payload = response.body().toString();
            if (response.status() == 200) {
                return javax.ws.rs.core.Response.ok().entity((Object)payload).build();
            }
            JsonObject errorObj = new JsonParser().parse(payload).getAsJsonObject();
            if (errorObj.get("message") != null) {
                return javax.ws.rs.core.Response.serverError().entity((Object)errorObj.get("message")).build();
            }
            return javax.ws.rs.core.Response.serverError().entity((Object)payload).build();
        }
        catch (SiddhiStoreQueryHelperException e) {
            log.error("Cannot execute the store query.", (Throwable)e);
            return javax.ws.rs.core.Response.serverError().entity((Object)"Failed executing the Siddhi query.").build();
        }
    }

    @GET
    @javax.ws.rs.Path(value="/listDirectoriesInPath")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response filterDirectories(@QueryParam(value="path") String path, @QueryParam(value="directoryList") String directoryList) {
        try {
            List<String> directories = Arrays.stream(new String(Base64.getDecoder().decode(directoryList), Charset.defaultCharset()).split(",")).filter(directory -> directory != null && !directory.trim().isEmpty()).map(directory -> "\"" + directory + "\"").collect(Collectors.toList());
            String baseLocation = Paths.get(Constants.CARBON_HOME, new String[0]).toString();
            Path pathLocation = SecurityUtil.resolvePath(Paths.get(baseLocation, new String[0]).toAbsolutePath(), Paths.get(new String(Base64.getDecoder().decode(path), Charset.defaultCharset()), new String[0]));
            JsonArray filteredDirectoryFiles = FileJsonObjectReaderUtil.listDirectoryInPath(pathLocation.toString(), directories);
            JsonObject rootElement = FileJsonObjectReaderUtil.getJsonRootObject(filteredDirectoryFiles);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)rootElement).type("application/json").build();
        }
        catch (IOException e) {
            return javax.ws.rs.core.Response.serverError().entity((Object)("failed." + e.getMessage())).build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @GET
    @javax.ws.rs.Path(value="/listFilesInPath")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response listFilesInRootPath(@QueryParam(value="path") String path) {
        try {
            String location = Paths.get(Constants.CARBON_HOME, new String[0]).toString();
            Path pathLocation = SecurityUtil.resolvePath(Paths.get(location, new String[0]).toAbsolutePath(), Paths.get(new String(Base64.getDecoder().decode(path), Charset.defaultCharset()), new String[0]));
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)FileJsonObjectReaderUtil.listFilesInPath(pathLocation, "jar")).type("application/json").build();
        }
        catch (IOException e) {
            return javax.ws.rs.core.Response.serverError().entity((Object)("failed." + e.getMessage())).build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @GET
    @javax.ws.rs.Path(value="/workspace/listFilesInPath")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response listFilesInPath(@QueryParam(value="path") String path) {
        try {
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)this.workspace.listDirectoryFiles(new String(Base64.getDecoder().decode(path), Charset.defaultCharset()))).type("application/json").build();
        }
        catch (IOException e) {
            return javax.ws.rs.core.Response.serverError().entity((Object)("failed." + e.getMessage())).build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @GET
    @javax.ws.rs.Path(value="/workspace/exists")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response fileExists(@QueryParam(value="path") String path) {
        try {
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)this.workspace.exists(Paths.get("workspace" + System.getProperty(FILE_SEPARATOR) + new String(Base64.getDecoder().decode(path), Charset.defaultCharset()), new String[0]))).type("application/json").build();
        }
        catch (IOException e) {
            return javax.ws.rs.core.Response.serverError().entity((Object)("failed." + e.getMessage())).build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @POST
    @javax.ws.rs.Path(value="/workspace/exists/workspace")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response fileExistsAtWorkspace(String payload) {
        try {
            String configName = "";
            String[] splitConfigContent = payload.split("configName=");
            if (splitConfigContent.length > 1) {
                configName = splitConfigContent[1];
            }
            byte[] base64ConfigName = Base64.getDecoder().decode(configName);
            String location = Paths.get(Constants.RUNTIME_PATH, "deployment").toString();
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)this.workspace.exists(SecurityUtil.resolvePath(Paths.get(location, new String[0]).toAbsolutePath(), Paths.get("workspace" + System.getProperty(FILE_SEPARATOR) + new String(base64ConfigName, Charset.defaultCharset()), new String[0])))).type("application/json").build();
        }
        catch (IOException e) {
            return javax.ws.rs.core.Response.serverError().entity((Object)("failed." + e.getMessage())).build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @POST
    @javax.ws.rs.Path(value="/workspace/deploy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JsonObject deploy(JsonElement element) {
        JsonArray success = new JsonArray();
        JsonArray failure = new JsonArray();
        JsonObject deploymentStatus = new JsonObject();
        String sidhiFile = null;
        Integer siddhiFilesCount = element.getAsJsonObject().getAsJsonArray("siddhiFileList").size();
        Integer serverListCount = element.getAsJsonObject().getAsJsonArray("serverList").size();
        String location = Paths.get(Constants.RUNTIME_PATH, "deployment", "workspace").toString();
        SiddhiAppDeployerApiHelper siddhiAppDeployerApiHelper = new SiddhiAppDeployerApiHelper();
        for (int i = 0; i < siddhiFilesCount; ++i) {
            String fileName = element.getAsJsonObject().getAsJsonArray("siddhiFileList").get(i).getAsJsonObject().get("fileName").toString().replaceAll("\"", "");
            try {
                sidhiFile = new String(Files.readAllBytes(Paths.get(location + "/" + fileName, new String[0])), "UTF-8");
            }
            catch (IOException e) {
                JsonPrimitive status = new JsonPrimitive(String.valueOf(e));
                failure.add((JsonElement)status);
            }
            for (int x = 0; x < serverListCount; ++x) {
                JsonPrimitive status;
                String host = element.getAsJsonObject().getAsJsonArray("serverList").get(x).getAsJsonObject().get("host").toString().replaceAll("\"", "");
                String port = element.getAsJsonObject().getAsJsonArray("serverList").get(x).getAsJsonObject().get("port").toString().replaceAll("\"", "");
                String hostAndPort = host + ":" + port;
                String username = element.getAsJsonObject().getAsJsonArray("serverList").get(x).getAsJsonObject().get("username").toString().replaceAll("\"", "");
                String password = element.getAsJsonObject().getAsJsonArray("serverList").get(x).getAsJsonObject().get("password").toString().replaceAll("\"", "");
                try {
                    boolean response = siddhiAppDeployerApiHelper.deploySiddhiApp(hostAndPort, username, password, sidhiFile, fileName);
                    if (!response) continue;
                    status = new JsonPrimitive(fileName + " was successfully deployed to " + hostAndPort);
                    success.add((JsonElement)status);
                    continue;
                }
                catch (SiddhiAppDeployerServiceStubException e) {
                    status = new JsonPrimitive(String.valueOf(e.getMessage()));
                    failure.add((JsonElement)status);
                }
            }
        }
        deploymentStatus.add(SUCCESS, (JsonElement)success);
        deploymentStatus.add("failure", (JsonElement)failure);
        return deploymentStatus;
    }

    @GET
    @javax.ws.rs.Path(value="/workspace/listFiles/workspace")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response filesInWorkspacePath(@QueryParam(value="path") String relativePath) {
        try {
            String location = Paths.get(Constants.RUNTIME_PATH, "deployment").toString();
            Path pathLocation = SecurityUtil.resolvePath(Paths.get(location, new String[0]).toAbsolutePath(), Paths.get(new String(Base64.getDecoder().decode(relativePath), Charset.defaultCharset()), new String[0]));
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)this.workspace.listFilesInPath(pathLocation)).type("application/json").build();
        }
        catch (IOException e) {
            return javax.ws.rs.core.Response.serverError().entity((Object)("failed." + e.getMessage())).build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @GET
    @javax.ws.rs.Path(value="/workspace/listFiles/samples")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response filesInSamplePath(@QueryParam(value="path") String relativePath) {
        try {
            String location = Paths.get(Constants.CARBON_HOME, "samples", "artifacts").toString();
            Path pathLocation = SecurityUtil.resolvePath(Paths.get(location, new String[0]).toAbsolutePath(), Paths.get(new String(Base64.getDecoder().decode(relativePath), Charset.defaultCharset()), new String[0]));
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)this.workspace.listFilesInPath(pathLocation)).type("application/json").build();
        }
        catch (IOException e) {
            return javax.ws.rs.core.Response.serverError().entity((Object)("failed." + e.getMessage())).build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @GET
    @javax.ws.rs.Path(value="/workspace/listFiles/samples/descriptions")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response filesInSamplePathWithDescription() {
        try {
            Map<String, String> siddhiSampleMap = EditorDataHolder.getSiddhiSampleMap();
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)this.workspace.listSamplesInPath(siddhiSampleMap)).type("application/json").build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @GET
    @javax.ws.rs.Path(value="/workspace/config")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response getConfigs() {
        JsonObject config = new JsonObject();
        config.addProperty("fileSeparator", System.getProperty(FILE_SEPARATOR));
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)config).type("application/json").build();
    }

    @GET
    @javax.ws.rs.Path(value="/workspace/listFiles")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response filesInPath(@QueryParam(value="path") String path) {
        try {
            String location = Paths.get(Constants.CARBON_HOME, new String[0]).toString();
            Path pathLocation = SecurityUtil.resolvePath(Paths.get(location, new String[0]).toAbsolutePath(), Paths.get(new String(Base64.getDecoder().decode(path), Charset.defaultCharset()), new String[0]));
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)this.workspace.listFilesInPath(pathLocation)).type("application/json").build();
        }
        catch (IOException e) {
            return javax.ws.rs.core.Response.serverError().entity((Object)("failed." + e.getMessage())).build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @POST
    @javax.ws.rs.Path(value="/workspace/write")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response write(String payload) {
        try {
            String location = Paths.get(Constants.RUNTIME_PATH, "deployment").toString();
            String configName = "";
            String config = "";
            Matcher configNameMatcher = Pattern.compile("configName=(.*?)&").matcher(payload);
            while (configNameMatcher.find()) {
                configName = configNameMatcher.group(1);
            }
            String[] splitConfigContent = payload.split("config=");
            if (splitConfigContent.length > 1) {
                config = splitConfigContent[1];
            }
            byte[] base64Config = Base64.getDecoder().decode(config);
            byte[] base64ConfigName = Base64.getDecoder().decode(configName);
            Path filePath = SecurityUtil.resolvePath(Paths.get(location, new String[0]).toAbsolutePath(), Paths.get("workspace" + System.getProperty(FILE_SEPARATOR) + new String(base64ConfigName, Charset.defaultCharset()), new String[0]));
            Files.write(filePath, base64Config, new OpenOption[0]);
            Path fileNamePath = filePath.getFileName();
            if (null != fileNamePath) {
                String siddhiAppName = fileNamePath.toString().replace(".siddhi", "");
                if (null != EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName)) {
                    EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).setMode(DebugRuntime.Mode.FAULTY);
                }
            }
            JsonObject entity = new JsonObject();
            entity.addProperty(STATUS, SUCCESS);
            entity.addProperty("path", "workspace");
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)entity).type("application/json").build();
        }
        catch (IOException e) {
            return javax.ws.rs.core.Response.serverError().entity((Object)("failed." + e.getMessage())).build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @POST
    @javax.ws.rs.Path(value="/workspace/read")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response read(String relativePath) {
        try {
            String location = Paths.get(Constants.RUNTIME_PATH, "deployment").toString();
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)this.workspace.read(SecurityUtil.resolvePath(Paths.get(location, new String[0]).toAbsolutePath(), Paths.get(relativePath, new String[0])))).type("application/json").build();
        }
        catch (IOException e) {
            return javax.ws.rs.core.Response.serverError().entity((Object)("failed." + e.getMessage())).build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @POST
    @javax.ws.rs.Path(value="/workspace/read/sample")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response readSample(String relativePath) {
        try {
            String location = Paths.get(Constants.CARBON_HOME, "samples").toString();
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)this.workspace.read(SecurityUtil.resolvePath(Paths.get(location, new String[0]).toAbsolutePath(), Paths.get(relativePath, new String[0])))).type("application/json").build();
        }
        catch (IOException e) {
            return javax.ws.rs.core.Response.serverError().entity((Object)("failed." + e.getMessage())).build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @DELETE
    @javax.ws.rs.Path(value="/workspace/delete")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response deleteFile(@QueryParam(value="siddhiAppName") String siddhiAppName) {
        try {
            Path location = SecurityUtil.resolvePath(Paths.get(Constants.RUNTIME_PATH, "deployment").toAbsolutePath(), Paths.get("workspace" + System.getProperty(FILE_SEPARATOR) + siddhiAppName, new String[0]));
            File file = new File(location.toString());
            if (file.delete()) {
                log.info("Siddi App: " + LogEncoder.removeCRLFCharacters(siddhiAppName) + " is deleted");
                JsonObject entity = new JsonObject();
                entity.addProperty(STATUS, SUCCESS);
                entity.addProperty("path", "workspace");
                entity.addProperty("message", "Siddi App: " + siddhiAppName + " is deleted");
                return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)entity).type("application/json").build();
            }
            log.error("Siddi App: " + LogEncoder.removeCRLFCharacters(siddhiAppName) + " could not deleted");
            return javax.ws.rs.core.Response.serverError().entity((Object)("Siddi App: " + siddhiAppName + " could not deleted")).build();
        }
        catch (Throwable ignored) {
            return javax.ws.rs.core.Response.serverError().entity((Object)"failed").build();
        }
    }

    @GET
    @javax.ws.rs.Path(value="/metadata")
    public javax.ws.rs.core.Response getMetaData() {
        MetaDataResponse response = new MetaDataResponse(Status.SUCCESS);
        Map<String, MetaData> extensions = SourceEditorUtils.getExtensionProcessorMetaData();
        response.setInBuilt(extensions.remove(""));
        response.setExtensions(extensions);
        String jsonString = new Gson().toJson((Object)response);
        return javax.ws.rs.core.Response.ok((Object)jsonString, (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{siddhiAppName}/start")
    public javax.ws.rs.core.Response start(@PathParam(value="siddhiAppName") String siddhiAppName) {
        ArrayList<String> streams = new ArrayList();
        ArrayList<String> queries = new ArrayList();
        try {
            streams = EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getStreams();
            queries = EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getQueries();
        }
        catch (InvalidExecutionStateException invalidExecutionStateException) {
            // empty catch block
        }
        EditorDataHolder.getDebugProcessorService().start(siddhiAppName);
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).header("Access-Control-Allow-Origin", (Object)"*").entity((Object)new DebugRuntimeResponse(Status.SUCCESS, null, siddhiAppName, streams, queries)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/start")
    public javax.ws.rs.core.Response startWithVariables(String appStartRequestString) {
        AppStartRequest appStartRequest = (AppStartRequest)new Gson().fromJson(appStartRequestString, AppStartRequest.class);
        String siddhiAppName = appStartRequest.getSiddhiAppName();
        if (appStartRequest.getVariables().size() > 0) {
            DebugRuntime existingRuntime = EditorDataHolder.getSiddhiAppMap().get(siddhiAppName);
            String siddhiApp = existingRuntime.getSiddhiApp();
            DebugRuntime runtimeHolder = new DebugRuntime(siddhiAppName, siddhiApp, appStartRequest.getVariables());
            EditorDataHolder.getSiddhiAppMap().put(siddhiAppName, runtimeHolder);
        }
        return this.start(siddhiAppName);
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{siddhiAppName}/debug")
    public javax.ws.rs.core.Response debug(@PathParam(value="siddhiAppName") String siddhiAppName) {
        List<String> streams = EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getStreams();
        List<String> queries = EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getQueries();
        EditorDataHolder.getDebugProcessorService().debug(siddhiAppName);
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).header("Access-Control-Allow-Origin", (Object)"*").entity((Object)new DebugRuntimeResponse(Status.SUCCESS, null, siddhiAppName, streams, queries)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{siddhiAppName}/stop")
    public javax.ws.rs.core.Response stopDebug(@PathParam(value="siddhiAppName") String siddhiAppName) {
        EditorDataHolder.getDebugProcessorService().stop(siddhiAppName);
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).header("Access-Control-Allow-Origin", (Object)"*").entity((Object)new GeneralResponse(Status.SUCCESS, "Siddhi App " + siddhiAppName + " stopped successfully.")).build();
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{siddhiAppName}/acquire")
    public javax.ws.rs.core.Response acquireBreakPoint(@PathParam(value="siddhiAppName") String siddhiAppName, @QueryParam(value="queryIndex") Integer queryIndex, @QueryParam(value="queryTerminal") String queryTerminal) {
        if (queryIndex != null && queryTerminal != null && !queryTerminal.isEmpty()) {
            SiddhiDebugger.QueryTerminal terminal = "in".equalsIgnoreCase(queryTerminal) ? SiddhiDebugger.QueryTerminal.IN : SiddhiDebugger.QueryTerminal.OUT;
            String queryName = (String)EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getQueries().toArray()[queryIndex];
            EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getDebugger().acquireBreakPoint(queryName, terminal);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)new GeneralResponse(Status.SUCCESS, "Terminal " + queryTerminal + " breakpoint acquired for query " + siddhiAppName + ":" + queryName)).build();
        }
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new GeneralResponse(Status.ERROR, "Missing Parameters")).build();
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{siddhiAppName}/release")
    public javax.ws.rs.core.Response releaseBreakPoint(@PathParam(value="siddhiAppName") String siddhiAppName, @QueryParam(value="queryIndex") Integer queryIndex, @QueryParam(value="queryTerminal") String queryTerminal) {
        if (queryIndex == null || queryTerminal == null || queryTerminal.isEmpty()) {
            EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getDebugger().releaseAllBreakPoints();
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)new GeneralResponse(Status.SUCCESS, "All breakpoints released for siddhiAppName " + siddhiAppName)).build();
        }
        SiddhiDebugger.QueryTerminal terminal = "in".equalsIgnoreCase(queryTerminal) ? SiddhiDebugger.QueryTerminal.IN : SiddhiDebugger.QueryTerminal.OUT;
        String queryName = (String)EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getQueries().toArray()[queryIndex];
        EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getDebugger().releaseBreakPoint(queryName, terminal);
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)new GeneralResponse(Status.SUCCESS, "Terminal " + queryTerminal + " breakpoint released for query " + siddhiAppName + ":" + queryIndex)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{siddhiAppName}/next")
    public javax.ws.rs.core.Response next(@PathParam(value="siddhiAppName") String siddhiAppName) {
        EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getDebugger().next();
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)new GeneralResponse(Status.SUCCESS, "Debug action :next executed on " + siddhiAppName)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{siddhiAppName}/play")
    public javax.ws.rs.core.Response play(@PathParam(value="siddhiAppName") String siddhiAppName) {
        EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getDebugger().play();
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)new GeneralResponse(Status.SUCCESS, "Debug action :play executed on " + siddhiAppName)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{siddhiAppName}/state")
    public javax.ws.rs.core.Response getQueryState(@PathParam(value="siddhiAppName") String siddhiAppName) throws InterruptedException {
        DebugCallbackEvent event = EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getCallbackEventsQueue().poll(5L, TimeUnit.SECONDS);
        HashMap<String, Map<String, Object>> queryState = new HashMap<String, Map<String, Object>>();
        List<String> queries = EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getQueries();
        for (String query : queries) {
            queryState.put(query, EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getDebugger().getQueryState(query));
        }
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)new DebugStateHolder(event, queryState)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{siddhiAppName}/{queryName}/state")
    public javax.ws.rs.core.Response getQueryState(@PathParam(value="siddhiAppName") String siddhiAppName, @PathParam(value="queryName") String queryName) {
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getDebugger().getQueryState(queryName)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{siddhiAppName}/{streamId}/send")
    public javax.ws.rs.core.Response mock(String data, @PathParam(value="siddhiAppName") String siddhiAppName, @PathParam(value="streamId") String streamId) {
        Gson gson = new Gson();
        Object[] event = (Object[])gson.fromJson(data, Object[].class);
        this.executorService.execute(() -> {
            try {
                EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getInputHandler(streamId).send(event);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        });
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)new GeneralResponse(Status.SUCCESS, "Event " + Arrays.deepToString(event) + " sent to stream " + streamId + " of runtime " + siddhiAppName)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/artifact/listSiddhiApps")
    public javax.ws.rs.core.Response getSiddhiApps() {
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).header("Access-Control-Allow-Origin", (Object)"*").entity(new ArrayList<DebugRuntime>(EditorDataHolder.getSiddhiAppMap().values())).build();
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/artifact/listStreams/{siddhiAppName}")
    public javax.ws.rs.core.Response getStreams(@PathParam(value="siddhiAppName") String siddhiAppName) {
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).header("Access-Control-Allow-Origin", (Object)"*").entity(EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getStreams()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/artifact/listAttributes/{siddhiAppName}/{streamName}")
    public javax.ws.rs.core.Response getAttributes(@PathParam(value="siddhiAppName") String siddhiAppName, @PathParam(value="streamName") String streamName) {
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).header("Access-Control-Allow-Origin", (Object)"*").entity(EditorDataHolder.getDebugProcessorService().getSiddhiAppRuntimeHolder(siddhiAppName).getStreamAttributes(streamName)).build();
    }

    @POST
    @javax.ws.rs.Path(value="/design-view")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/x-www-form-urlencoded"})
    public javax.ws.rs.core.Response getDesignView(String siddhiAppBase64) {
        try {
            FileConfigManager fileConfigManager = new FileConfigManager(this.configProvider);
            SiddhiManager siddhiManager = EditorDataHolder.getSiddhiManager();
            siddhiManager.setConfigManager((ConfigManager)fileConfigManager);
            DesignGenerator designGenerator = new DesignGenerator();
            designGenerator.setSiddhiManager(siddhiManager);
            String siddhiAppString = new String(Base64.getDecoder().decode(siddhiAppBase64), StandardCharsets.UTF_8);
            EventFlow eventFlow = designGenerator.getEventFlow(siddhiAppString);
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            String eventFlowJson = gson.toJson((Object)eventFlow);
            String encodedEventFlowJson = new String(Base64.getEncoder().encode(eventFlowJson.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).header("Access-Control-Allow-Origin", (Object)"*").entity((Object)encodedEventFlowJson).build();
        }
        catch (SiddhiAppCreationException e) {
            log.error("Unable to generate design view", (Throwable)e);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Access-Control-Allow-Origin", (Object)"*").entity((Object)e.getMessage()).build();
        }
        catch (DesignGenerationException e) {
            log.error("Failed to convert Siddhi app code to design view", (Throwable)e);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("Access-Control-Allow-Origin", (Object)"*").entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @javax.ws.rs.Path(value="/code-view")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/x-www-form-urlencoded"})
    public javax.ws.rs.core.Response getCodeView(String encodedEventFlowJson) {
        try {
            String eventFlowJson = new String(Base64.getDecoder().decode(encodedEventFlowJson), StandardCharsets.UTF_8);
            Gson gson = DeserializersRegisterer.getGsonBuilder().disableHtmlEscaping().create();
            EventFlow eventFlow = (EventFlow)gson.fromJson(eventFlowJson, EventFlow.class);
            CodeGenerator codeGenerator = new CodeGenerator();
            String siddhiAppCode = codeGenerator.generateSiddhiAppCode(eventFlow);
            String encodedSiddhiAppString = new String(Base64.getEncoder().encode(siddhiAppCode.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).header("Access-Control-Allow-Origin", (Object)"*").entity((Object)encodedSiddhiAppString).build();
        }
        catch (CodeGenerationException e) {
            log.error("Unable to generate code view", (Throwable)e);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Access-Control-Allow-Origin", (Object)"*").entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @javax.ws.rs.Path(value="/tooltips")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response getToolTips(String encodedSiddhiAppConfigJson) {
        try {
            String siddhiAppConfigJson = new String(Base64.getDecoder().decode(encodedSiddhiAppConfigJson), StandardCharsets.UTF_8);
            Gson gson = DeserializersRegisterer.getGsonBuilder().disableHtmlEscaping().create();
            SiddhiAppConfig siddhiAppConfig = (SiddhiAppConfig)gson.fromJson(siddhiAppConfigJson, SiddhiAppConfig.class);
            CodeGenerator codeGenerator = new CodeGenerator();
            List<ToolTip> toolTipList = codeGenerator.generateSiddhiAppToolTips(siddhiAppConfig);
            String jsonString = new Gson().toJson(toolTipList);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)jsonString).build();
        }
        catch (CodeGenerationException e) {
            log.error("Unable to generate tooltips", (Throwable)e);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Access-Control-Allow-Origin", (Object)"*").entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @javax.ws.rs.Path(value="/export")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public javax.ws.rs.core.Response exportApps(@QueryParam(value="exportType") String exportType, @QueryParam(value="requestType") String requestType, @FormParam(value="payload") String payload) {
        String dockerBuilderStatusKey = "";
        String errorMessage = "";
        try {
            if (payload == null) {
                errorMessage = "Form parameter payload cannot be null while exporting docker/k8. Expected payload format: {'templatedSiddhiApps': ['<SIDDHI-APPS>'], 'configuration': '<SIDDHI-CONFIG-OF-DEPLOYMENT.YAML>', 'templatedVariables': ['<TEMPLATED-VERIABLES>'], 'kubernetesConfiguration': '<K8S-CONFIG>', 'dockerConfiguration': '<DOCKER-CONFIG>'}";
                log.error(errorMessage);
                return javax.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            ExportAppsRequest exportAppsRequest = (ExportAppsRequest)new Gson().fromJson(payload, ExportAppsRequest.class);
            ExportUtils exportUtils = new ExportUtils(this.configProvider, exportAppsRequest, exportType);
            File zipFile = exportUtils.createZipFile();
            String fileName = "siddhi-docker.zip";
            boolean kubernetesEnabled = false;
            if (exportType != null && exportType.equals(EXPORT_TYPE_KUBERNETES)) {
                fileName = "siddhi-kubernetes.zip";
                kubernetesEnabled = true;
            }
            if (requestType != null && requestType.equals(EXPORT_REQUEST_TYPE_DOWNLOAD_ONLY)) {
                return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)zipFile).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).build();
            }
            DockerBuilderStatus dockerBuilderStatus = new DockerBuilderStatus("", "");
            if (exportAppsRequest != null && exportAppsRequest.getDockerConfiguration() != null) {
                DockerBuildConfig dockerBuildConfig = exportAppsRequest.getDockerConfiguration();
                if (StringUtils.isEmpty(dockerBuildConfig.getImageName()) || StringUtils.isEmpty(dockerBuildConfig.getUserName()) || StringUtils.isEmpty(dockerBuildConfig.getEmail()) || StringUtils.isEmpty(dockerBuildConfig.getPassword())) {
                    errorMessage = "Missing required Docker build configuration of (DockerImageName|UserName|Email|Password)";
                    log.error(errorMessage);
                    return javax.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
                }
                if (!dockerBuildConfig.getImageName().equals(dockerBuildConfig.getImageName().toLowerCase())) {
                    errorMessage = "Invalid docker image name " + dockerBuildConfig.getImageName() + ". Docker image name must be in lowercase.";
                    log.error(errorMessage);
                    return javax.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
                }
                DockerBuilder dockerBuilder = new DockerBuilder(dockerBuildConfig.getImageName(), dockerBuildConfig.getUserName(), dockerBuildConfig.getEmail(), dockerBuildConfig.getPassword(), exportUtils.getTempDockerPath(), dockerBuilderStatus);
                dockerBuilder.start();
                UUID uuid = UUID.randomUUID();
                dockerBuilderStatusKey = uuid.toString();
                this.dockerBuilderStatusMap.clear();
                this.dockerBuilderStatusMap.put(dockerBuilderStatusKey, dockerBuilderStatus);
            }
            if (requestType != null && requestType.equals(EXPORT_REQUEST_TYPE_BUILD_ONLY) && !kubernetesEnabled) {
                return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).header(EXPORT_REQUEST_GET_STATUS_HEADER, (Object)dockerBuilderStatusKey).build();
            }
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)zipFile).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).header(EXPORT_REQUEST_GET_STATUS_HEADER, (Object)dockerBuilderStatusKey).build();
        }
        catch (JsonSyntaxException e) {
            log.error("Incorrect JSON configuration format found while exporting Docker/K8s", (Throwable)e);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Incorrect JSON configuration format. " + e.getMessage())).build();
        }
        catch (DockerGenerationException e) {
            log.error("Exception caught while generating Docker export artifacts. ", (Throwable)e);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Exception caught while generating Docker export artifacts. " + e.getMessage())).build();
        }
        catch (KubernetesGenerationException e) {
            log.error("Exception caught while generating Kubernetes export artifacts. ", (Throwable)e);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Exception caught while generating Kubernetes export artifacts. " + e.getMessage())).build();
        }
        catch (Exception e) {
            log.error("Cannot generate export-artifacts archive.", (Throwable)e);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Cannot generate export-artifacts archive." + e.getMessage())).build();
        }
    }

    @GET
    @javax.ws.rs.Path(value="/dockerBuildStatus")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response get(@Context Request request) {
        JsonObject dockerBuilderStatus = new JsonObject();
        if (request.getHeader(EXPORT_REQUEST_GET_STATUS_HEADER) != null) {
            if (this.dockerBuilderStatusMap.get(request.getHeader(EXPORT_REQUEST_GET_STATUS_HEADER)) != null) {
                DockerBuilderStatus currentStatus = this.dockerBuilderStatusMap.get(request.getHeader(EXPORT_REQUEST_GET_STATUS_HEADER));
                dockerBuilderStatus.addProperty("Step", currentStatus.getStep());
                dockerBuilderStatus.addProperty("Status", currentStatus.getStatus());
            } else {
                dockerBuilderStatus.addProperty("Step", "");
                dockerBuilderStatus.addProperty("Status", "");
            }
        }
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)dockerBuilderStatus).type("application/json").build();
    }

    @GET
    @javax.ws.rs.Path(value="/deploymentConfigs")
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response getDeploymentConfigs() {
        ExportUtils exportUtils = new ExportUtils(this.configProvider);
        try {
            JsonObject deploymentHolder = new JsonObject();
            deploymentHolder.addProperty("deploymentYaml", exportUtils.exportConfigs());
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.OK).entity((Object)deploymentHolder).type("application/json").build();
        }
        catch (IOException e) {
            log.error("Cannot read deployment.yaml file. ", (Throwable)e);
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Cannot read deployment.yaml file in TOOLING|RUNNER configuration. " + e.getMessage())).build();
        }
    }

    @GET
    @javax.ws.rs.Path(value="/siddhi-apps/{appName}/streams/{streamName}/event/{type}")
    @Produces(value={"text/plain"})
    public javax.ws.rs.core.Response getDefaultSampleStreamEvent(@PathParam(value="appName") String appName, @PathParam(value="streamName") String streamName, @PathParam(value="type") String eventType) throws NotFoundException {
        SiddhiAppRuntime siddhiAppRuntime = EditorDataHolder.getSiddhiManager().getSiddhiAppRuntime(appName);
        JSONObject errorResponse = new JSONObject();
        if (siddhiAppRuntime == null) {
            errorResponse.put("error", (Object)("There is no Siddhi App exist with provided name : " + appName));
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errorResponse.toString()).build();
        }
        StreamDefinition streamDefinition = (StreamDefinition)siddhiAppRuntime.getStreamDefinitionMap().get(streamName);
        if (streamDefinition == null) {
            errorResponse.put("error", (Object)("There is no Stream called " + streamName + " in " + appName + " Siddhi App."));
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errorResponse.toString()).build();
        }
        if (eventType.equals("xml")) {
            return javax.ws.rs.core.Response.ok().entity((Object)SampleEventGenerator.generateXMLEvent(streamDefinition)).build();
        }
        if (eventType.equals("json")) {
            return javax.ws.rs.core.Response.ok().entity((Object)SampleEventGenerator.generateJSONEvent(streamDefinition)).build();
        }
        if (eventType.equals("text")) {
            return javax.ws.rs.core.Response.ok().entity((Object)SampleEventGenerator.generateTextEvent(streamDefinition)).build();
        }
        errorResponse.put("error", (Object)("Invalid type: " + eventType + " given to retrieve the sample event."));
        return javax.ws.rs.core.Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errorResponse.toString()).build();
    }

    @Activate
    protected void start(BundleContext bundleContext) throws Exception {
        EditorDataHolder.setDebugProcessorService(new DebugProcessorService());
        SiddhiManager siddhiManager = EditorDataHolder.getSiddhiManager();
        FileConfigManager fileConfigManager = new FileConfigManager(this.configProvider);
        siddhiManager.setConfigManager((ConfigManager)fileConfigManager);
        EditorDataHolder.setSiddhiManager(siddhiManager);
        EditorDataHolder.setBundleContext(bundleContext);
        this.siddhiAppRuntimeServiceRegistration = bundleContext.registerService(SiddhiAppRuntimeService.class.getName(), (Object)new EditorSiddhiAppRuntimeService(), null);
        this.serviceRegistration = bundleContext.registerService(EventStreamService.class.getName(), (Object)new DebuggerEventStreamService(), null);
        this.loadSampleFiles();
    }

    @Deactivate
    protected void stop() throws Exception {
        log.info("Service Component is deactivated");
        EditorDataHolder.getSiddhiAppMap().values().forEach(DebugRuntime::stop);
        EditorDataHolder.setBundleContext(null);
        this.serviceRegistration.unregister();
    }

    @Reference(name="siddhi.component.activator.service", service=SiddhiComponentActivator.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSiddhiComponentActivator")
    protected void setSiddhiComponentActivator(SiddhiComponentActivator siddhiComponentActivator) {
    }

    protected void unsetSiddhiComponentActivator(SiddhiComponentActivator siddhiComponentActivator) {
    }

    @Reference(name="carbon.config.provider", service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterConfigProvider")
    protected void registerConfigProvider(ConfigProvider configProvider) {
        this.configProvider = configProvider;
    }

    protected void unregisterConfigProvider(ConfigProvider configProvider) {
        this.configProvider = null;
    }

    protected void loadSampleFiles() {
        String location = Paths.get(Constants.CARBON_HOME, "samples", "artifacts").toString();
        String relativePath = "";
        Path pathLocation = SecurityUtil.resolvePath(Paths.get(location, new String[0]).toAbsolutePath(), Paths.get(new String(Base64.getDecoder().decode(relativePath), Charset.defaultCharset()), new String[0]));
        String regex = "@[Aa][Pp][Pp]:[Dd][Ee][Ss][Cc][Rr][Ii][Pp][Tt][Ii][Oo][Nn]\\(['|\"](.*?)['|\"]\\)";
        Pattern pattern = Pattern.compile(regex);
        try {
            HashMap<String, String> sampleMap = new HashMap<String, String>();
            List collect = Files.walk(pathLocation, new FileVisitOption[0]).filter(s -> s.toString().endsWith(".siddhi")).sorted().collect(Collectors.toList());
            for (Path path : collect) {
                String fileContent = new String(Files.readAllBytes(path), Charset.defaultCharset());
                Matcher matcher = pattern.matcher(fileContent);
                String descriptionText = "";
                if (matcher.find()) {
                    String description = matcher.group();
                    descriptionText = description.substring(description.indexOf("(") + 1, description.lastIndexOf(")"));
                }
                Path relativeSamplePath = pathLocation.relativize(path);
                sampleMap.put(relativeSamplePath.toString(), descriptionText);
            }
            EditorDataHolder.setSiddhiSampleMap(sampleMap);
        }
        catch (IOException e) {
            log.error("Error while reading the sample descriptions.", (Throwable)e);
        }
    }

    @Reference(name="carbon.anaytics.common.clientservice", service=AnalyticsHttpClientBuilderService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterAnalyticsHttpClient")
    protected void registerAnalyticsHttpClient(AnalyticsHttpClientBuilderService service) {
        EditorDataHolder.getInstance().setClientBuilderService(service);
    }

    protected void unregisterAnalyticsHttpClient(AnalyticsHttpClientBuilderService service) {
        EditorDataHolder.getInstance().setClientBuilderService(null);
    }

    @Reference(name="siddhi-manager-service", service=SiddhiManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSiddhiManager")
    protected void setSiddhiManager(SiddhiManager siddhiManager) {
        EditorDataHolder.setSiddhiManager(siddhiManager);
    }

    protected void unsetSiddhiManager(SiddhiManager siddhiManager) {
        EditorDataHolder.setSiddhiManager(null);
    }
}

