/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.internal.local;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.siddhi.distribution.editor.core.Workspace;
import io.siddhi.distribution.editor.core.util.Constants;
import io.siddhi.distribution.editor.core.util.FileJsonObjectReaderUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFSWorkspace
implements Workspace {
    private static final Logger logger = LoggerFactory.getLogger(LocalFSWorkspace.class);
    private static final String SIDDHI_FILE_EXTENSION = ".siddhi";
    private static final String FOLDER_TYPE = "folder";
    private static final String CONTENT = "content";

    @Override
    public JsonArray listRoots() throws IOException {
        Iterable<Path> rootDirs = FileSystems.getDefault().getRootDirectories();
        JsonArray rootArray = new JsonArray();
        for (Path root : rootDirs) {
            JsonObject rootObj = FileJsonObjectReaderUtil.getJsonObjForFile(root, false);
            try {
                if (Files.isDirectory(root, new LinkOption[0]) && Files.list(root).count() > 0L) {
                    JsonArray children = new JsonArray();
                    Iterator rootItr = Files.list(root).iterator();
                    while (rootItr.hasNext()) {
                        Path next = (Path)rootItr.next();
                        if (!Files.isDirectory(next, new LinkOption[0]) || Files.isHidden(next)) continue;
                        JsonObject childObj = FileJsonObjectReaderUtil.getJsonObjForFile(next, true);
                        children.add((JsonElement)childObj);
                    }
                    rootObj.add("children", (JsonElement)children);
                }
            }
            catch (IOException e) {
                logger.debug("Error while traversing children of " + e.toString(), (Throwable)e);
                rootObj.addProperty("error", e.toString());
            }
            if (!Files.isDirectory(root, new LinkOption[0])) continue;
            rootArray.add((JsonElement)rootObj);
        }
        return rootArray;
    }

    @Override
    public JsonArray listDirectoryFiles(String path) throws IOException {
        String location = "";
        if (path.equals("")) {
            location = Paths.get(Constants.RUNTIME_PATH, "deployment").toString();
        }
        ArrayList<String> directories = new ArrayList<String>();
        directories.add("\"workspace\"");
        return FileJsonObjectReaderUtil.listDirectoryInPath(location, directories);
    }

    @Override
    public JsonArray listDirectoriesInPath(String path) throws IOException {
        Path ioPath = Paths.get(path, new String[0]);
        JsonArray dirs = new JsonArray();
        Iterator iterator = Files.list(ioPath).iterator();
        while (iterator.hasNext()) {
            Path next = (Path)iterator.next();
            if (!Files.isDirectory(next, new LinkOption[0]) || Files.isHidden(next)) continue;
            JsonObject jsnObj = FileJsonObjectReaderUtil.getJsonObjForFile(next, true);
            dirs.add((JsonElement)jsnObj);
        }
        return dirs;
    }

    @Override
    public JsonObject read(Path path) throws IOException {
        byte[] fileContent = Files.readAllBytes(path);
        JsonObject content = new JsonObject();
        content.addProperty(CONTENT, new String(fileContent, Charset.defaultCharset()));
        return content;
    }

    @Override
    public void delete(String path, String type) throws IOException {
        Path ioPath = Paths.get(path, new String[0]);
        if (FOLDER_TYPE.equals(type)) {
            Files.walk(ioPath, FileVisitOption.FOLLOW_LINKS).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        } else {
            Files.delete(ioPath);
        }
    }

    @Override
    public void create(String path, String type) throws IOException {
        Path ioPath = Paths.get(path, new String[0]);
        if (FOLDER_TYPE.equals(type)) {
            Files.createDirectories(ioPath, new FileAttribute[0]);
        } else {
            Files.createFile(ioPath, new FileAttribute[0]);
        }
    }

    @Override
    public void log(String loggerID, String timestamp, String level, String url, String message, String layout) throws IOException {
        Logger frontEndLog = LoggerFactory.getLogger((String)loggerID);
        String logMessage = "client-timestamp: " + timestamp + ", page: " + url + ", message: " + message;
        switch (level) {
            case "TRACE": {
                frontEndLog.trace(logMessage);
                break;
            }
            case "DEBUG": {
                frontEndLog.debug(logMessage);
                break;
            }
            case "INFO": {
                frontEndLog.info(logMessage);
                break;
            }
            case "WARN": {
                frontEndLog.warn(logMessage);
                break;
            }
            case "ERROR": {
                frontEndLog.error(logMessage);
                break;
            }
            case "FATAL": {
                frontEndLog.error(logMessage);
                break;
            }
            default: {
                frontEndLog.debug(logMessage);
            }
        }
    }

    @Override
    public JsonArray listFilesInPath(Path path) throws IOException {
        return FileJsonObjectReaderUtil.listFilesInPath(path, SIDDHI_FILE_EXTENSION);
    }

    @Override
    public JsonObject exists(Path path) throws IOException {
        JsonObject result = new JsonObject();
        boolean exists = Files.exists(path, new LinkOption[0]);
        result.addProperty("file", path.toString());
        result.addProperty("exists", Boolean.valueOf(exists));
        return result;
    }

    @Override
    public JsonArray listSamplesInPath(Map<String, String> sampleMap) {
        JsonArray samples = new JsonArray();
        sampleMap.entrySet().stream().forEach(entry -> {
            JsonObject sampleObject = new JsonObject();
            sampleObject.addProperty("path", (String)entry.getKey());
            sampleObject.addProperty("description", (String)entry.getValue());
            samples.add((JsonElement)sampleObject);
        });
        return samples;
    }
}

