/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util;

import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.distribution.editor.core.commons.metadata.AttributeMetaData;
import io.siddhi.distribution.editor.core.commons.metadata.MetaData;
import io.siddhi.distribution.editor.core.commons.metadata.ParameterMetaData;
import io.siddhi.distribution.editor.core.commons.metadata.ProcessorMetaData;
import io.siddhi.distribution.editor.core.internal.EditorDataHolder;
import io.siddhi.distribution.editor.core.util.Constants;
import io.siddhi.query.api.definition.AbstractDefinition;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class SourceEditorUtils {
    static final Logger LOGGER = Logger.getLogger(SourceEditorUtils.class);

    private SourceEditorUtils() {
    }

    public static SiddhiAppRuntime validateSiddhiApp(String siddhiApp) {
        SiddhiAppRuntime siddhiAppRuntime = null;
        try {
            siddhiAppRuntime = EditorDataHolder.getSiddhiManager().createSiddhiAppRuntime(siddhiApp);
            siddhiAppRuntime.start();
        }
        finally {
            if (siddhiAppRuntime != null) {
                siddhiAppRuntime.shutdown();
            }
        }
        return siddhiAppRuntime;
    }

    public static List<List<AbstractDefinition>> getInnerStreamDefinitions(SiddhiAppRuntime siddhiAppRuntime, List<List<String>> partitionsWithMissingInnerStreams) {
        ArrayList<List<AbstractDefinition>> innerStreamDefinitions = new ArrayList<List<AbstractDefinition>>();
        ConcurrentHashMap innerStreamsMap = new ConcurrentHashMap();
        siddhiAppRuntime.getPartitionedInnerStreamDefinitionMap().entrySet().parallelStream().forEach(entry -> {
            Map cfr_ignored_0 = (Map)innerStreamsMap.put(Integer.valueOf(((String)entry.getKey()).split("-")[1]), entry.getValue());
        });
        ArrayList rankedPartitionsWithInnerStreams = new ArrayList();
        ArrayList rankedPartitionElementIds = new ArrayList();
        for (Map.Entry entry2 : innerStreamsMap.entrySet()) {
            int i;
            for (i = 0; i < rankedPartitionsWithInnerStreams.size() && (Integer)entry2.getKey() >= (Integer)rankedPartitionElementIds.get(i); ++i) {
            }
            rankedPartitionsWithInnerStreams.add(i, entry2.getValue());
            rankedPartitionElementIds.add(i, entry2.getKey());
        }
        for (int i = 0; i < partitionsWithMissingInnerStreams.size(); ++i) {
            List<String> partitionWithMissingInnerStreams = partitionsWithMissingInnerStreams.get(i);
            Map partitionWithInnerStreams = (Map)rankedPartitionsWithInnerStreams.get(i);
            ArrayList<AbstractDefinition> innerStreamDefinition = new ArrayList<AbstractDefinition>();
            for (String missingInnerStream : partitionWithMissingInnerStreams) {
                AbstractDefinition streamDefinition = (AbstractDefinition)partitionWithInnerStreams.get(missingInnerStream);
                if (streamDefinition == null) continue;
                innerStreamDefinition.add(streamDefinition);
            }
            innerStreamDefinitions.add(innerStreamDefinition);
        }
        return innerStreamDefinitions;
    }

    public static List<AbstractDefinition> getStreamDefinitions(SiddhiAppRuntime siddhiAppRuntime, List<String> missingStreams) {
        ArrayList<AbstractDefinition> streamDefinitions = new ArrayList<AbstractDefinition>();
        Map streamDefinitionMap = siddhiAppRuntime.getStreamDefinitionMap();
        for (String stream : missingStreams) {
            AbstractDefinition streamDefinition = (AbstractDefinition)streamDefinitionMap.get(stream);
            if (streamDefinition == null) continue;
            streamDefinitions.add(streamDefinition);
        }
        return streamDefinitions;
    }

    public static List<AbstractDefinition> getAggregationDefinitions(SiddhiAppRuntime siddhiAppRuntime, List<String> missingAggregationDefinitions) {
        ArrayList<AbstractDefinition> aggregationDefinitions = new ArrayList<AbstractDefinition>();
        Map aggregationDefinitionMap = siddhiAppRuntime.getAggregationDefinitionMap();
        for (String aggregation : missingAggregationDefinitions) {
            AbstractDefinition aggregationDefinition = (AbstractDefinition)aggregationDefinitionMap.get(aggregation);
            if (aggregationDefinition == null) continue;
            aggregationDefinitions.add(aggregationDefinition);
        }
        return aggregationDefinitions;
    }

    public static MetaData getInBuiltProcessorMetaData() {
        Map<String, Set<Class<?>>> processorClassMap = SourceEditorUtils.getClassesInClassPathFromPackages();
        return SourceEditorUtils.generateInBuiltMetaData(processorClassMap);
    }

    public static Map<String, MetaData> getExtensionProcessorMetaData() {
        Map extensionsMap = EditorDataHolder.getSiddhiManager().getExtensions();
        return SourceEditorUtils.generateExtensionsMetaData(extensionsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Set<Class<?>>> getClassesInClassPathFromPackages() {
        String[] classPathNames = System.getProperty("java.class.path").split(File.pathSeparator);
        HashMap classSetMap = new HashMap();
        for (String classPathName : classPathNames) {
            if (!classPathName.endsWith(".jar")) continue;
            ZipInputStream stream = null;
            try {
                stream = new JarInputStream(new FileInputStream(classPathName));
                JarEntry jarEntry = ((JarInputStream)stream).getNextJarEntry();
                while (jarEntry != null) {
                    String jarEntryName = jarEntry.getName().replace("/", ".");
                    jarEntryName = jarEntryName.replace("\\", ".");
                    try {
                        for (Map.Entry<String, String> entry : Constants.PACKAGE_NAME_MAP.entrySet()) {
                            if (!jarEntryName.endsWith(".class") || !jarEntryName.startsWith(entry.getValue())) continue;
                            HashSet classSet = (HashSet)classSetMap.get(entry.getKey());
                            if (classSet == null) {
                                classSet = new HashSet();
                                classSetMap.put(entry.getKey(), classSet);
                            }
                            classSet.add(Class.forName(jarEntryName.substring(0, jarEntryName.length() - 6)));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.debug((Object)("Failed to load class " + jarEntryName.substring(0, jarEntryName.length() - 6)), (Throwable)e);
                    }
                    jarEntry = ((JarInputStream)stream).getNextJarEntry();
                }
            }
            catch (IOException e) {
                LOGGER.debug((Object)("Failed to open the jar input stream for " + classPathName), (Throwable)e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        LOGGER.debug((Object)("Failed to close the jar input stream for " + classPathName), (Throwable)e);
                    }
                }
            }
        }
        return classSetMap;
    }

    private static MetaData generateInBuiltMetaData(Map<String, Set<Class<?>>> classMap) {
        MetaData metaData = new MetaData();
        ArrayList<ProcessorMetaData> functionMetaData = new ArrayList<ProcessorMetaData>();
        SourceEditorUtils.populateInBuiltProcessorMetaDataList(functionMetaData, classMap, "FunctionExecutor");
        SourceEditorUtils.populateInBuiltProcessorMetaDataList(functionMetaData, classMap, "AttributeAggregatorExecutor");
        metaData.setFunctions(functionMetaData);
        ArrayList<ProcessorMetaData> streamProcessorMetaData = new ArrayList<ProcessorMetaData>();
        SourceEditorUtils.populateInBuiltProcessorMetaDataList(streamProcessorMetaData, classMap, "StreamFunctionProcessor");
        SourceEditorUtils.populateInBuiltProcessorMetaDataList(streamProcessorMetaData, classMap, "StreamProcessor");
        metaData.setStreamProcessors(streamProcessorMetaData);
        ArrayList<ProcessorMetaData> windowProcessorMetaData = new ArrayList<ProcessorMetaData>();
        SourceEditorUtils.populateInBuiltProcessorMetaDataList(windowProcessorMetaData, classMap, "WindowProcessor");
        metaData.setWindowProcessors(windowProcessorMetaData);
        return metaData;
    }

    private static void populateInBuiltProcessorMetaDataList(List<ProcessorMetaData> targetProcessorMetaDataList, Map<String, Set<Class<?>>> classMap, String processorType) {
        Set<Class<?>> classSet = classMap.get(processorType);
        if (classSet != null) {
            for (Class<?> processorClass : classSet) {
                ProcessorMetaData processorMetaData = SourceEditorUtils.generateProcessorMetaData(processorClass, processorType);
                if (processorMetaData == null) continue;
                targetProcessorMetaDataList.add(processorMetaData);
            }
        }
    }

    private static Map<String, MetaData> generateExtensionsMetaData(Map<String, Class> extensionsMap) {
        HashMap<String, MetaData> metaDataMap = new HashMap<String, MetaData>();
        for (Map.Entry<String, Class> entry : extensionsMap.entrySet()) {
            ProcessorMetaData processorMetaData;
            String processorName;
            String namespace = "";
            if (entry.getKey().contains(":")) {
                namespace = entry.getKey().split(":")[0];
                processorName = entry.getKey().split(":")[1];
            } else {
                processorName = entry.getKey();
            }
            MetaData metaData = metaDataMap.computeIfAbsent(namespace, k -> new MetaData());
            Class extensionClass = entry.getValue();
            String processorType = null;
            List<ProcessorMetaData> processorMetaDataList = null;
            if (Constants.SUPER_CLASS_MAP.get("FunctionExecutor").isAssignableFrom(extensionClass)) {
                processorType = "FunctionExecutor";
                processorMetaDataList = metaData.getFunctions();
            } else if (Constants.SUPER_CLASS_MAP.get("AttributeAggregatorExecutor").isAssignableFrom(extensionClass)) {
                processorType = "AttributeAggregatorExecutor";
                processorMetaDataList = metaData.getFunctions();
            } else if (Constants.SUPER_CLASS_MAP.get("IncrementalAggregator").isAssignableFrom(extensionClass)) {
                processorType = "IncrementalAggregator";
                processorMetaDataList = metaData.getFunctions();
            } else if (Constants.SUPER_CLASS_MAP.get("StreamFunctionProcessor").isAssignableFrom(extensionClass)) {
                processorType = "StreamFunctionProcessor";
                processorMetaDataList = metaData.getStreamProcessors();
            } else if (Constants.SUPER_CLASS_MAP.get("StreamProcessor").isAssignableFrom(extensionClass)) {
                processorType = "StreamProcessor";
                processorMetaDataList = metaData.getStreamProcessors();
            } else if (Constants.SUPER_CLASS_MAP.get("WindowProcessor").isAssignableFrom(extensionClass)) {
                processorType = "WindowProcessor";
                processorMetaDataList = metaData.getWindowProcessors();
            } else if (Constants.SUPER_CLASS_MAP.get("Source").isAssignableFrom(extensionClass)) {
                processorType = "Source";
                processorMetaDataList = metaData.getSources();
            } else if (Constants.SUPER_CLASS_MAP.get("Sink").isAssignableFrom(extensionClass)) {
                processorType = "Sink";
                processorMetaDataList = metaData.getSinks();
            } else if (Constants.SUPER_CLASS_MAP.get("SourceMap").isAssignableFrom(extensionClass)) {
                processorType = "SourceMap";
                processorMetaDataList = metaData.getSourceMaps();
            } else if (Constants.SUPER_CLASS_MAP.get("SinkMap").isAssignableFrom(extensionClass)) {
                processorType = "SinkMap";
                processorMetaDataList = metaData.getSinkMaps();
            } else if (Constants.SUPER_CLASS_MAP.get("Store").isAssignableFrom(extensionClass)) {
                processorType = "Store";
                processorMetaDataList = metaData.getStores();
            }
            if (processorMetaDataList == null || (processorMetaData = SourceEditorUtils.generateProcessorMetaData(extensionClass, processorType, processorName)) == null) continue;
            processorMetaDataList.add(processorMetaData);
        }
        return metaDataMap;
    }

    private static ProcessorMetaData generateProcessorMetaData(Class<?> processorClass, String processorType) {
        String processorName = processorClass.getName();
        processorName = processorName.substring(processorName.lastIndexOf(46) + 1);
        processorName = processorName.replace(processorType, "");
        if (!Constants.SUPER_CLASS_MAP.get(processorType).equals(processorClass)) {
            processorName = processorName.substring(0, 1).toLowerCase(Locale.getDefault()) + processorName.substring(1);
            return SourceEditorUtils.generateProcessorMetaData(processorClass, processorType, processorName);
        }
        return null;
    }

    private static ProcessorMetaData generateProcessorMetaData(Class<?> processorClass, String processorType, String processorName) {
        ProcessorMetaData processorMetaData = null;
        Extension extensionAnnotation = processorClass.getAnnotation(Extension.class);
        if (extensionAnnotation != null) {
            processorMetaData = new ProcessorMetaData();
            processorMetaData.setName(processorName);
            processorMetaData.setDescription(extensionAnnotation.description());
            processorMetaData.setNamespace(extensionAnnotation.namespace());
            if (extensionAnnotation.parameters().length > 0) {
                ArrayList<ParameterMetaData> parameterMetaDataList = new ArrayList<ParameterMetaData>();
                for (Parameter parameter : extensionAnnotation.parameters()) {
                    ParameterMetaData parameterMetaData = new ParameterMetaData();
                    parameterMetaData.setName(parameter.name());
                    parameterMetaData.setType(Arrays.asList(parameter.type()));
                    parameterMetaData.setOptional(parameter.optional());
                    parameterMetaData.setDescription(parameter.description());
                    parameterMetaData.setDefaultValue(parameter.defaultValue());
                    parameterMetaDataList.add(parameterMetaData);
                }
                processorMetaData.setParameters(parameterMetaDataList);
            }
            if ("WindowProcessor".equals(processorType) || "StreamProcessor".equals(processorType) || "StreamFunctionProcessor".equals(processorType) || "FunctionExecutor".equals(processorType)) {
                ArrayList<AttributeMetaData> attributeMetaDataList = new ArrayList<AttributeMetaData>();
                if (extensionAnnotation.returnAttributes().length > 0) {
                    for (Parameter parameter : extensionAnnotation.returnAttributes()) {
                        AttributeMetaData attributeMetaData = new AttributeMetaData();
                        attributeMetaData.setName(parameter.name());
                        attributeMetaData.setType(Arrays.asList(parameter.type()));
                        attributeMetaData.setDescription(parameter.description());
                        attributeMetaDataList.add(attributeMetaData);
                    }
                }
                processorMetaData.setReturnAttributes(attributeMetaDataList);
            }
            if (extensionAnnotation.examples().length > 0) {
                String[] examples = new String[extensionAnnotation.examples().length];
                for (int i = 0; i < extensionAnnotation.examples().length; ++i) {
                    examples[i] = "syntax: " + extensionAnnotation.examples()[i].syntax() + "\ndescription: " + extensionAnnotation.examples()[i].description();
                }
                processorMetaData.setExamples(examples);
            }
            if (extensionAnnotation.parameterOverloads().length > 0) {
                ArrayList<String[]> parameterOverloads = new ArrayList<String[]>();
                for (ParameterOverload parameterOverload : extensionAnnotation.parameterOverloads()) {
                    parameterOverloads.add(parameterOverload.parameterNames());
                }
                processorMetaData.setParameterOverloads(parameterOverloads);
            }
        }
        return processorMetaData;
    }

    public static String populateSiddhiAppWithVars(Map<String, String> envMap, String siddhiApp) {
        if (siddhiApp.contains("$")) {
            String envPattern = "\\$\\{(\\w+)\\}";
            Pattern expr = Pattern.compile(envPattern);
            Matcher matcher = expr.matcher(siddhiApp);
            while (matcher.find()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String envValue = envMap.get(matcher.group(i));
                    if (envValue == null) continue;
                    envValue = envValue.replace("\\", "\\\\");
                    Pattern subexpr = Pattern.compile("\\$\\{" + matcher.group(i) + "\\}");
                    siddhiApp = subexpr.matcher(siddhiApp).replaceAll(envValue);
                }
            }
        }
        return siddhiApp;
    }
}

