/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.beans.configs;

import java.util.Arrays;

public class ElementCodeSegment
implements Comparable<ElementCodeSegment> {
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;

    public ElementCodeSegment(int[] queryContextStartIndex, int[] queryContextEndIndex) {
        this.queryContextStartIndex = new int[]{queryContextStartIndex[0], queryContextStartIndex[1]};
        this.queryContextEndIndex = new int[]{queryContextEndIndex[0], queryContextEndIndex[1]};
    }

    public int[] getQueryContextStartIndex() {
        return new int[]{this.queryContextStartIndex[0], this.queryContextStartIndex[1]};
    }

    public void setQueryContextStartIndex(int[] queryContextStartIndex) {
        this.queryContextStartIndex = new int[]{queryContextStartIndex[0], queryContextStartIndex[1]};
    }

    public int[] getQueryContextEndIndex() {
        return new int[]{this.queryContextEndIndex[0], this.queryContextEndIndex[1]};
    }

    public void setQueryContextEndIndex(int[] queryContextEndIndex) {
        this.queryContextEndIndex = new int[]{queryContextEndIndex[0], queryContextEndIndex[1]};
    }

    public int getStartLine() {
        return this.queryContextStartIndex[0];
    }

    public int getStartColumn() {
        return this.queryContextStartIndex[1];
    }

    public int getEndLine() {
        return this.queryContextEndIndex[0];
    }

    public int getEndColumn() {
        return this.queryContextEndIndex[1];
    }

    public boolean isValid() {
        if (this.getStartLine() == this.getEndLine()) {
            return this.getEndColumn() - this.getStartColumn() > 0;
        }
        return this.getEndLine() - this.getStartLine() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementCodeSegment that = (ElementCodeSegment)o;
        return Arrays.equals(this.getQueryContextStartIndex(), that.getQueryContextStartIndex()) && Arrays.equals(this.getQueryContextEndIndex(), that.getQueryContextEndIndex());
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.getQueryContextStartIndex());
        result = 31 * result + Arrays.hashCode(this.getQueryContextEndIndex());
        return result;
    }

    @Override
    public int compareTo(ElementCodeSegment elementCodeSegment) {
        if (this.getStartLine() > elementCodeSegment.getStartLine()) {
            return 1;
        }
        if (this.getStartLine() == elementCodeSegment.getStartLine()) {
            if (this.getEndLine() == elementCodeSegment.getEndLine()) {
                if (this.getStartColumn() == elementCodeSegment.getStartColumn()) {
                    return Integer.compare(this.getEndColumn(), elementCodeSegment.getEndColumn());
                }
                return Integer.compare(this.getStartColumn(), elementCodeSegment.getStartColumn());
            }
            return Integer.compare(this.getEndLine(), elementCodeSegment.getEndLine());
        }
        return -1;
    }
}

