/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.codegenerator;

import io.siddhi.distribution.editor.core.util.designview.beans.EventFlow;
import io.siddhi.distribution.editor.core.util.designview.beans.ToolTip;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.SiddhiAppConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.FunctionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.StreamConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.TableConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.TriggerConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.WindowConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.AggregationConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.SourceSinkConfig;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.elements.ExecutionElementConfig;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.AggregationCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.FunctionCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.PartitionCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.SourceSinkCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.StreamCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.SubElementCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.TableCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.TriggerCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.WindowCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.query.QueryCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.constants.query.QueryListType;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.CodeGeneratorUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CodeGenerator {
    public String generateSiddhiAppCode(EventFlow eventFlow) throws CodeGenerationException {
        SiddhiAppConfig siddhiApp = eventFlow.getSiddhiAppConfig();
        ArrayList<QueryConfig> queries = new ArrayList<QueryConfig>();
        for (List<QueryConfig> queryList : siddhiApp.getQueryLists().values()) {
            queries.addAll(queryList);
        }
        for (PartitionConfig partition : siddhiApp.getPartitionList()) {
            for (List<QueryConfig> queryList : partition.getQueryLists().values()) {
                queries.addAll(queryList);
            }
        }
        List<StreamConfig> streamsToBeGenerated = CodeGeneratorUtils.getStreamsToBeGenerated(siddhiApp.getStreamList(), siddhiApp.getSourceList(), siddhiApp.getSinkList(), queries);
        List<String> definitionsToBeGenerated = CodeGeneratorUtils.getDefinitionNames(streamsToBeGenerated, siddhiApp.getTableList(), siddhiApp.getWindowList(), siddhiApp.getTriggerList(), siddhiApp.getAggregationList(), siddhiApp.getPartitionList());
        List<String> allDefinitions = CodeGeneratorUtils.getDefinitionNames(siddhiApp.getStreamList(), siddhiApp.getTableList(), siddhiApp.getWindowList(), siddhiApp.getTriggerList(), siddhiApp.getAggregationList(), siddhiApp.getPartitionList());
        return this.generateAppName(siddhiApp.getSiddhiAppName()) + this.generateAppDescription(siddhiApp.getSiddhiAppDescription()) + SubElementCodeGenerator.generateAnnotations(siddhiApp.getAppAnnotationList()) + this.generateStreams(streamsToBeGenerated, siddhiApp.getSourceList(), siddhiApp.getSinkList()) + this.generateTables(siddhiApp.getTableList()) + this.generateWindows(siddhiApp.getWindowList()) + this.generateTriggers(siddhiApp.getTriggerList()) + this.generateAggregations(siddhiApp.getAggregationList()) + this.generateFunctions(siddhiApp.getFunctionList()) + this.generateExecutionElements(siddhiApp.getQueryLists(), siddhiApp.getPartitionList(), definitionsToBeGenerated, allDefinitions);
    }

    public List<ToolTip> generateSiddhiAppToolTips(SiddhiAppConfig siddhiAppConfig) throws CodeGenerationException {
        SiddhiAppConfig siddhiApp = siddhiAppConfig;
        ArrayList<ToolTip> toolTipList = new ArrayList<ToolTip>();
        toolTipList.addAll(this.generateStreamSinkSourceToolTips(siddhiApp.getStreamList(), siddhiApp.getSourceList(), siddhiApp.getSinkList()));
        toolTipList.addAll(this.generateTableToolTips(siddhiApp.getTableList()));
        toolTipList.addAll(this.generateWindowToolTips(siddhiApp.getWindowList()));
        toolTipList.addAll(this.generateTriggerToolTips(siddhiApp.getTriggerList()));
        toolTipList.addAll(this.generateAggregationToolTips(siddhiApp.getAggregationList()));
        toolTipList.addAll(this.generateFunctionToolTips(siddhiApp.getFunctionList()));
        toolTipList.addAll(this.generateExcecutionElementToolTips(siddhiApp.getQueryLists(), siddhiApp.getPartitionList()));
        return toolTipList;
    }

    private String generateAppName(String appName) {
        StringBuilder appNameStringBuilder = new StringBuilder();
        if (appName != null && !appName.isEmpty()) {
            appNameStringBuilder.append("@App:name('").append(appName).append('\'').append(')');
        } else {
            appNameStringBuilder.append("@App:name('SiddhiApp')");
        }
        return appNameStringBuilder.toString();
    }

    private String generateAppDescription(String appDescription) {
        StringBuilder appDescriptionStringBuilder = new StringBuilder();
        if (appDescription != null && !appDescription.isEmpty()) {
            appDescriptionStringBuilder.append("@App:description('").append(appDescription).append('\'').append(')');
        } else {
            appDescriptionStringBuilder.append("@App:description('Description of the plan')");
        }
        return appDescriptionStringBuilder.toString();
    }

    private String generateStreams(List<StreamConfig> streamList, List<SourceSinkConfig> sourceList, List<SourceSinkConfig> sinkList) throws CodeGenerationException {
        if (streamList == null || streamList.isEmpty()) {
            return "";
        }
        LinkedList<SourceSinkConfig> sourcesAndSinks = new LinkedList<SourceSinkConfig>();
        sourcesAndSinks.addAll(sourceList);
        sourcesAndSinks.addAll(sinkList);
        StringBuilder streamListStringBuilder = new StringBuilder();
        streamListStringBuilder.append('\n');
        SourceSinkCodeGenerator sourceSinkCodeGenerator = new SourceSinkCodeGenerator();
        StreamCodeGenerator streamCodeGenerator = new StreamCodeGenerator();
        for (StreamConfig stream : streamList) {
            if (stream.isFaultStream()) continue;
            CodeGeneratorUtils.NullValidator.validateConfigObject(stream);
            if (stream.getPartitionId() != null && !stream.getPartitionId().isEmpty()) continue;
            for (SourceSinkConfig sourceSink : sourcesAndSinks) {
                if (!stream.getName().equals(sourceSink.getConnectedElementName())) continue;
                streamListStringBuilder.append(sourceSinkCodeGenerator.generateSourceSink(sourceSink, false));
            }
            streamListStringBuilder.append(streamCodeGenerator.generateStream(stream, false));
        }
        streamListStringBuilder.append('\n');
        return streamListStringBuilder.toString();
    }

    private List<ToolTip> generateStreamSinkSourceToolTips(List<StreamConfig> streamList, List<SourceSinkConfig> sourceList, List<SourceSinkConfig> sinkList) throws CodeGenerationException {
        ArrayList<ToolTip> streamSourceSinkToolTipList = new ArrayList<ToolTip>();
        ArrayList<SourceSinkConfig> sourcesAndSinks = new ArrayList<SourceSinkConfig>();
        sourcesAndSinks.addAll(sourceList);
        sourcesAndSinks.addAll(sinkList);
        StreamCodeGenerator streamCodeGenerator = new StreamCodeGenerator();
        SourceSinkCodeGenerator sourceSinkCodeGenerator = new SourceSinkCodeGenerator();
        for (StreamConfig stream : streamList) {
            CodeGeneratorUtils.NullValidator.validateConfigObject(stream);
            streamSourceSinkToolTipList.add(new ToolTip(stream.getId(), streamCodeGenerator.generateStream(stream, true)));
        }
        for (SourceSinkConfig sourceSink : sourcesAndSinks) {
            streamSourceSinkToolTipList.add(new ToolTip(sourceSink.getId(), sourceSinkCodeGenerator.generateSourceSink(sourceSink, true)));
        }
        return streamSourceSinkToolTipList;
    }

    private String generateTables(List<TableConfig> tableList) throws CodeGenerationException {
        if (tableList == null || tableList.isEmpty()) {
            return "";
        }
        StringBuilder tableListStringBuilder = new StringBuilder();
        tableListStringBuilder.append('\n');
        TableCodeGenerator tableCodeGenerator = new TableCodeGenerator();
        for (TableConfig table : tableList) {
            tableListStringBuilder.append(tableCodeGenerator.generateTable(table, false));
        }
        tableListStringBuilder.append('\n');
        return tableListStringBuilder.toString();
    }

    private List<ToolTip> generateTableToolTips(List<TableConfig> tableList) throws CodeGenerationException {
        ArrayList<ToolTip> tableTooltipList = new ArrayList<ToolTip>();
        if (tableList == null || tableList.isEmpty()) {
            return tableTooltipList;
        }
        TableCodeGenerator tableCodeGenerator = new TableCodeGenerator();
        for (TableConfig table : tableList) {
            tableTooltipList.add(new ToolTip(table.getId(), tableCodeGenerator.generateTable(table, true)));
        }
        return tableTooltipList;
    }

    private String generateWindows(List<WindowConfig> windowList) throws CodeGenerationException {
        if (windowList == null || windowList.isEmpty()) {
            return "";
        }
        StringBuilder windowListStringBuilder = new StringBuilder();
        windowListStringBuilder.append('\n');
        WindowCodeGenerator windowCodeGenerator = new WindowCodeGenerator();
        for (WindowConfig window : windowList) {
            windowListStringBuilder.append(windowCodeGenerator.generateWindow(window, false));
        }
        windowListStringBuilder.append('\n');
        return windowListStringBuilder.toString();
    }

    private List<ToolTip> generateWindowToolTips(List<WindowConfig> windowList) throws CodeGenerationException {
        ArrayList<ToolTip> windowToolTipList = new ArrayList<ToolTip>();
        if (windowList == null || windowList.isEmpty()) {
            return windowToolTipList;
        }
        WindowCodeGenerator windowCodeGenerator = new WindowCodeGenerator();
        for (WindowConfig window : windowList) {
            windowToolTipList.add(new ToolTip(window.getId(), windowCodeGenerator.generateWindow(window, true)));
        }
        return windowToolTipList;
    }

    private String generateTriggers(List<TriggerConfig> triggerList) throws CodeGenerationException {
        if (triggerList == null || triggerList.isEmpty()) {
            return "";
        }
        StringBuilder triggerListStringBuilder = new StringBuilder();
        triggerListStringBuilder.append('\n');
        TriggerCodeGenerator triggerCodeGenerator = new TriggerCodeGenerator();
        for (TriggerConfig trigger : triggerList) {
            triggerListStringBuilder.append(triggerCodeGenerator.generateTrigger(trigger, false));
        }
        triggerListStringBuilder.append('\n');
        return triggerListStringBuilder.toString();
    }

    private List<ToolTip> generateTriggerToolTips(List<TriggerConfig> triggerList) throws CodeGenerationException {
        ArrayList<ToolTip> triggerToolTipList = new ArrayList<ToolTip>();
        if (triggerList == null || triggerList.isEmpty()) {
            return triggerToolTipList;
        }
        TriggerCodeGenerator triggerToolTipGenerator = new TriggerCodeGenerator();
        for (TriggerConfig trigger : triggerList) {
            triggerToolTipList.add(new ToolTip(trigger.getId(), triggerToolTipGenerator.generateTrigger(trigger, true)));
        }
        return triggerToolTipList;
    }

    private String generateAggregations(List<AggregationConfig> aggregationList) throws CodeGenerationException {
        if (aggregationList == null || aggregationList.isEmpty()) {
            return "";
        }
        StringBuilder aggregationListStringBuilder = new StringBuilder();
        aggregationListStringBuilder.append('\n');
        AggregationCodeGenerator aggregationCodeGenerator = new AggregationCodeGenerator();
        for (AggregationConfig aggregation : aggregationList) {
            aggregationListStringBuilder.append(aggregationCodeGenerator.generateAggregation(aggregation, false));
        }
        aggregationListStringBuilder.append('\n');
        return aggregationListStringBuilder.toString();
    }

    private List<ToolTip> generateAggregationToolTips(List<AggregationConfig> aggregationList) throws CodeGenerationException {
        ArrayList<ToolTip> aggregationToolTipList = new ArrayList<ToolTip>();
        if (aggregationList == null || aggregationList.isEmpty()) {
            return aggregationToolTipList;
        }
        AggregationCodeGenerator aggregationCodeGenerator = new AggregationCodeGenerator();
        for (AggregationConfig aggregation : aggregationList) {
            aggregationToolTipList.add(new ToolTip(aggregation.getId(), aggregationCodeGenerator.generateAggregation(aggregation, true)));
        }
        return aggregationToolTipList;
    }

    private String generateFunctions(List<FunctionConfig> functionList) throws CodeGenerationException {
        if (functionList == null || functionList.isEmpty()) {
            return "";
        }
        StringBuilder functionListStringBuilder = new StringBuilder();
        functionListStringBuilder.append('\n');
        FunctionCodeGenerator functionCodeGenerator = new FunctionCodeGenerator();
        for (FunctionConfig function : functionList) {
            functionListStringBuilder.append(functionCodeGenerator.generateFunction(function, false));
        }
        functionListStringBuilder.append('\n');
        return functionListStringBuilder.toString();
    }

    private List<ToolTip> generateFunctionToolTips(List<FunctionConfig> functionList) throws CodeGenerationException {
        ArrayList<ToolTip> functionTooltipList = new ArrayList<ToolTip>();
        if (functionList == null || functionList.isEmpty()) {
            return functionTooltipList;
        }
        FunctionCodeGenerator functionCodeGenerator = new FunctionCodeGenerator();
        for (FunctionConfig function : functionList) {
            functionTooltipList.add(new ToolTip(function.getId(), functionCodeGenerator.generateFunction(function, true)));
        }
        return functionTooltipList;
    }

    private String generateExecutionElements(Map<QueryListType, List<QueryConfig>> queryLists, List<PartitionConfig> partitions, List<String> definitionsToBeGenerated, List<String> allDefinitions) throws CodeGenerationException {
        StringBuilder executionElementStringBuilder = new StringBuilder();
        executionElementStringBuilder.append('\n');
        LinkedList<QueryConfig> queries = new LinkedList<QueryConfig>();
        for (List<QueryConfig> queryList : queryLists.values()) {
            queries.addAll(queryList);
        }
        List<ExecutionElementConfig> executionElements = CodeGeneratorUtils.convertToExecutionElements(queries, partitions);
        QueryCodeGenerator queryCodeGenerator = new QueryCodeGenerator();
        PartitionCodeGenerator partitionCodeGenerator = new PartitionCodeGenerator();
        for (ExecutionElementConfig executionElement : CodeGeneratorUtils.reorderExecutionElements(executionElements, definitionsToBeGenerated)) {
            if (executionElement.getType().equalsIgnoreCase("QUERY")) {
                QueryConfig query = (QueryConfig)executionElement.getValue();
                executionElementStringBuilder.append(queryCodeGenerator.generateQuery(query, false));
            } else if (executionElement.getType().equalsIgnoreCase("PARTITION")) {
                PartitionConfig partition = (PartitionConfig)executionElement.getValue();
                executionElementStringBuilder.append(partitionCodeGenerator.generatePartition(partition, allDefinitions, false));
            } else {
                throw new CodeGenerationException("Unidentified ExecutionElement type: " + executionElement.getType());
            }
            executionElementStringBuilder.append('\n');
        }
        return executionElementStringBuilder.toString();
    }

    private List<ToolTip> generateExcecutionElementToolTips(Map<QueryListType, List<QueryConfig>> queryLists, List<PartitionConfig> partitions) throws CodeGenerationException {
        ArrayList<ToolTip> excecutionElementTooltipList = new ArrayList<ToolTip>();
        LinkedList<QueryConfig> queries = new LinkedList<QueryConfig>();
        for (List<QueryConfig> queryList : queryLists.values()) {
            queries.addAll(queryList);
        }
        List<ExecutionElementConfig> executionElements = CodeGeneratorUtils.convertToExecutionElements(queries, partitions);
        QueryCodeGenerator queryCodeGenerator = new QueryCodeGenerator();
        PartitionCodeGenerator partitionCodeGenerator = new PartitionCodeGenerator();
        for (ExecutionElementConfig executionElement : executionElements) {
            if (executionElement.getType().equalsIgnoreCase("QUERY")) {
                QueryConfig query = (QueryConfig)executionElement.getValue();
                excecutionElementTooltipList.add(new ToolTip(query.getId(), queryCodeGenerator.generateQuery(query, true)));
                continue;
            }
            if (executionElement.getType().equalsIgnoreCase("PARTITION")) {
                PartitionConfig partition = (PartitionConfig)executionElement.getValue();
                ArrayList<String> alldefinitions = new ArrayList<String>();
                for (List<QueryConfig> queryList : partition.getQueryLists().values()) {
                    for (QueryConfig query : queryList) {
                        alldefinitions.addAll(CodeGeneratorUtils.getInputStreams(query));
                        alldefinitions.add(query.getQueryOutput().getTarget());
                    }
                }
                excecutionElementTooltipList.add(new ToolTip(partition.getId(), partitionCodeGenerator.generatePartition(partition, alldefinitions, true)));
                continue;
            }
            throw new CodeGenerationException("Unidentified ExecutionElement type: " + executionElement.getType());
        }
        return excecutionElementTooltipList;
    }
}

