/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.codegenerator.generators;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.SourceSinkConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.mapper.MapperConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.mapper.attribute.MapperListPayloadOrAttribute;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.mapper.attribute.MapperMapPayloadOrAttribute;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.mapper.attribute.MapperPayloadOrAttribute;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.SubElementCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.CodeGeneratorUtils;
import java.util.Map;

public class SourceSinkCodeGenerator {
    public String generateSourceSink(SourceSinkConfig sourceSink, boolean isGeneratingToolTip) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(sourceSink);
        StringBuilder sourceSinkStringBuilder = new StringBuilder();
        if (!isGeneratingToolTip) {
            sourceSinkStringBuilder.append(SubElementCodeGenerator.generateComment(sourceSink.getPreviousCommentSegment()));
        }
        if (sourceSink.getAnnotationType().equalsIgnoreCase("SOURCE")) {
            sourceSinkStringBuilder.append("@source(type='");
        } else if (sourceSink.getAnnotationType().equalsIgnoreCase("SINK")) {
            sourceSinkStringBuilder.append("@sink(type='");
        } else {
            throw new CodeGenerationException("Unidentified source/sink type: " + sourceSink.getType());
        }
        sourceSinkStringBuilder.append(sourceSink.getType()).append('\'');
        if (sourceSink.getOptions() != null && !sourceSink.getOptions().isEmpty()) {
            sourceSinkStringBuilder.append(',').append(SubElementCodeGenerator.generateParameterList(sourceSink.getOptions()));
        }
        if (sourceSink.getMap() != null) {
            sourceSinkStringBuilder.append(',').append(this.generateMapper(sourceSink.getMap()));
        }
        sourceSinkStringBuilder.append(')');
        return sourceSinkStringBuilder.toString();
    }

    private String generateMapper(MapperConfig mapper) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(mapper);
        StringBuilder mapperStringBuilder = new StringBuilder();
        mapperStringBuilder.append('\n').append("@map(type='").append(mapper.getType()).append('\'');
        if (mapper.getOptions() != null && !mapper.getOptions().isEmpty()) {
            mapperStringBuilder.append(',').append(SubElementCodeGenerator.generateParameterList(mapper.getOptions()));
        }
        if (mapper.getPayloadOrAttribute() != null) {
            mapperStringBuilder.append(',');
            if (mapper.getPayloadOrAttribute().getAnnotationType().equalsIgnoreCase("ATTRIBUTES")) {
                mapperStringBuilder.append("@attributes(");
            } else if (mapper.getPayloadOrAttribute().getAnnotationType().equalsIgnoreCase("PAYLOAD")) {
                mapperStringBuilder.append("@payload(");
            }
            mapperStringBuilder.append(this.generateMapperPayloadOrAttribute(mapper.getPayloadOrAttribute())).append(')');
        }
        mapperStringBuilder.append(')');
        return mapperStringBuilder.toString();
    }

    private String generateMapperPayloadOrAttribute(MapperPayloadOrAttribute payloadOrAttribute) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(payloadOrAttribute);
        StringBuilder mapperAttributeStringBuilder = new StringBuilder();
        switch (payloadOrAttribute.getType().toUpperCase()) {
            case "MAP": {
                mapperAttributeStringBuilder.append(this.generateMapPayloadOrAttribute((MapperMapPayloadOrAttribute)payloadOrAttribute));
                break;
            }
            case "LIST": {
                mapperAttributeStringBuilder.append(this.generateListPayloadOrAttribute((MapperListPayloadOrAttribute)payloadOrAttribute));
                break;
            }
            default: {
                throw new CodeGenerationException("Unidentified mapper attribute type: " + payloadOrAttribute.getType());
            }
        }
        return mapperAttributeStringBuilder.toString();
    }

    private String generateListPayloadOrAttribute(MapperListPayloadOrAttribute mapperListAttribute) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(mapperListAttribute);
        StringBuilder mapperListAttributeStringBuilder = new StringBuilder();
        int valuesLeft = mapperListAttribute.getValue().size();
        for (String value : mapperListAttribute.getValue()) {
            if (value.contains("\"") || value.contains("\n")) {
                mapperListAttributeStringBuilder.append("\"\"\"").append(value).append("\"\"\"");
            } else {
                mapperListAttributeStringBuilder.append('\"').append(value).append('\"');
            }
            if (valuesLeft != 1) {
                mapperListAttributeStringBuilder.append(',');
            }
            --valuesLeft;
        }
        return mapperListAttributeStringBuilder.toString();
    }

    private String generateMapPayloadOrAttribute(MapperMapPayloadOrAttribute mapperMapAttribute) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(mapperMapAttribute);
        StringBuilder mapperMapAttributeStringBuilder = new StringBuilder();
        int mapEntriesLeft = mapperMapAttribute.getValue().size();
        for (Map.Entry<String, String> entry : mapperMapAttribute.getValue().entrySet()) {
            mapperMapAttributeStringBuilder.append(entry.getKey()).append('=');
            String value = entry.getValue();
            if (value.contains("\"") || value.contains("\n")) {
                mapperMapAttributeStringBuilder.append("\"\"\"").append(value).append("\"\"\"");
            } else {
                mapperMapAttributeStringBuilder.append('\"').append(value).append('\"');
            }
            if (mapEntriesLeft != 1) {
                mapperMapAttributeStringBuilder.append(',');
            }
            --mapEntriesLeft;
        }
        return mapperMapAttributeStringBuilder.toString();
    }
}

