/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.query;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryConfig;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.SubElementCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.query.subelements.QueryInputCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.query.subelements.QueryOutputCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.query.subelements.QuerySelectCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.query.subelements.QuerySubElementCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.CodeGeneratorUtils;

public class QueryCodeGenerator {
    public String generateQuery(QueryConfig query, boolean isGeneratingToolTip) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(query);
        StringBuilder queryStringBuilder = new StringBuilder();
        if (!isGeneratingToolTip) {
            queryStringBuilder.append(SubElementCodeGenerator.generateComment(query.getPreviousCommentSegment()));
        }
        queryStringBuilder.append(SubElementCodeGenerator.generateAnnotations(query.getAnnotationList())).append(SubElementCodeGenerator.generateQueryName(query.getQueryName())).append(QueryInputCodeGenerator.generateQueryInput(query.getQueryInput())).append(' ').append(QuerySelectCodeGenerator.generateQuerySelect(query.getSelect()));
        if (query.getGroupBy() != null && !query.getGroupBy().isEmpty()) {
            queryStringBuilder.append(' ').append(QuerySubElementCodeGenerator.generateQueryGroupBy(query.getGroupBy()));
        }
        if (query.getHaving() != null && !query.getHaving().isEmpty()) {
            queryStringBuilder.append(' ').append(QuerySubElementCodeGenerator.generateQueryHaving(query.getHaving()));
        }
        if (query.getOrderBy() != null && !query.getOrderBy().isEmpty()) {
            queryStringBuilder.append(' ').append(QuerySubElementCodeGenerator.generateQueryOrderBy(query.getOrderBy()));
        }
        if (query.getLimit() != 0L) {
            queryStringBuilder.append(' ').append(QuerySubElementCodeGenerator.generateQueryLimit(query.getLimit()));
        }
        if (query.getOffset() != 0L) {
            queryStringBuilder.append(' ').append(QuerySubElementCodeGenerator.generateQueryOffset(query.getOffset()));
        }
        if (query.getOutputRateLimit() != null && !query.getOutputRateLimit().isEmpty()) {
            queryStringBuilder.append(' ').append(QuerySubElementCodeGenerator.generateQueryOutputRateLimit(query.getOutputRateLimit()));
        }
        queryStringBuilder.append(' ').append(QueryOutputCodeGenerator.generateQueryOutput(query.getQueryOutput()));
        return queryStringBuilder.toString();
    }
}

