/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.query.subelements;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.QueryOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.DeleteOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.InsertOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.UpdateInsertIntoOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.setattribute.SetAttributeConfig;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.SubElementCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.CodeGeneratorUtils;

public class QueryOutputCodeGenerator {
    private QueryOutputCodeGenerator() {
    }

    public static String generateQueryOutput(QueryOutputConfig queryOutput) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(queryOutput);
        StringBuilder queryOutputStringBuilder = new StringBuilder();
        switch (queryOutput.getType().toUpperCase()) {
            case "INSERT": {
                InsertOutputConfig insertOutputConfig = (InsertOutputConfig)queryOutput.getOutput();
                queryOutputStringBuilder.append(QueryOutputCodeGenerator.generateInsertOutput(insertOutputConfig, queryOutput.getTarget()));
                break;
            }
            case "DELETE": {
                DeleteOutputConfig deleteOutputConfig = (DeleteOutputConfig)queryOutput.getOutput();
                queryOutputStringBuilder.append(QueryOutputCodeGenerator.generateDeleteOutput(deleteOutputConfig, queryOutput.getTarget()));
                break;
            }
            case "UPDATE": 
            case "UPDATE_OR_INSERT_INTO": {
                UpdateInsertIntoOutputConfig updateInsertIntoOutput = (UpdateInsertIntoOutputConfig)queryOutput.getOutput();
                queryOutputStringBuilder.append(QueryOutputCodeGenerator.generateUpdateOutput(queryOutput.getType(), updateInsertIntoOutput, queryOutput.getTarget()));
                break;
            }
            default: {
                throw new CodeGenerationException("Unidentified query output type: " + queryOutput.getType());
            }
        }
        return queryOutputStringBuilder.toString();
    }

    private static String generateInsertOutput(InsertOutputConfig insertOutput, String target) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(insertOutput);
        if (target == null || target.isEmpty()) {
            throw new CodeGenerationException("The 'target' value of a given query output element is empty");
        }
        StringBuilder insertOutputStringBuilder = new StringBuilder();
        insertOutputStringBuilder.append('\n').append("insert").append(' ');
        if (insertOutput.getEventType() != null && !insertOutput.getEventType().isEmpty()) {
            switch (insertOutput.getEventType().toUpperCase()) {
                case "CURRENT_EVENTS": {
                    insertOutputStringBuilder.append(' ');
                    break;
                }
                case "EXPIRED_EVENTS": {
                    insertOutputStringBuilder.append("expired events").append(' ');
                    break;
                }
                case "ALL_EVENTS": {
                    insertOutputStringBuilder.append("all events").append(' ');
                    break;
                }
                default: {
                    throw new CodeGenerationException("Unidentified insert query output event type: " + insertOutput.getEventType());
                }
            }
        }
        insertOutputStringBuilder.append("into").append(' ').append(target).append(';');
        return insertOutputStringBuilder.toString();
    }

    private static String generateDeleteOutput(DeleteOutputConfig deleteOutput, String target) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(deleteOutput);
        if (target == null || target.isEmpty()) {
            throw new CodeGenerationException("The 'target' value of a given delete query output is empty");
        }
        return "delete " + target + SubElementCodeGenerator.generateForEventType(deleteOutput.getEventType()) + ' ' + "on" + ' ' + deleteOutput.getOn() + ';';
    }

    private static String generateUpdateOutput(String type, UpdateInsertIntoOutputConfig updateInsertIntoOutput, String target) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(updateInsertIntoOutput);
        if (target == null || target.isEmpty()) {
            throw new CodeGenerationException("The 'target' value of a given update/insert query output element is empty");
        }
        StringBuilder updateInsertIntoOutputStringBuilder = new StringBuilder();
        if (type.equalsIgnoreCase("UPDATE")) {
            updateInsertIntoOutputStringBuilder.append("update");
        } else if (type.equalsIgnoreCase("UPDATE_OR_INSERT_INTO")) {
            updateInsertIntoOutputStringBuilder.append("update or insert into");
        }
        updateInsertIntoOutputStringBuilder.append(' ').append(target).append(SubElementCodeGenerator.generateForEventType(updateInsertIntoOutput.getEventType())).append(' ');
        if (updateInsertIntoOutput.getSet() != null && !updateInsertIntoOutput.getSet().isEmpty()) {
            updateInsertIntoOutputStringBuilder.append("set").append(' ');
            int setAttributesLeft = updateInsertIntoOutput.getSet().size();
            for (SetAttributeConfig setAttribute : updateInsertIntoOutput.getSet()) {
                updateInsertIntoOutputStringBuilder.append(QueryOutputCodeGenerator.generateSetAttribute(setAttribute));
                if (setAttributesLeft != 1) {
                    updateInsertIntoOutputStringBuilder.append(',');
                }
                --setAttributesLeft;
            }
            updateInsertIntoOutputStringBuilder.append(' ');
        }
        updateInsertIntoOutputStringBuilder.append("on").append(' ').append(updateInsertIntoOutput.getOn()).append(';');
        return updateInsertIntoOutputStringBuilder.toString();
    }

    private static String generateSetAttribute(SetAttributeConfig setAttribute) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(setAttribute);
        return setAttribute.getAttribute() + ' ' + '=' + ' ' + setAttribute.getValue();
    }
}

