/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.query.subelements;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.attributesselection.AttributesSelectionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.attributesselection.SelectedAttribute;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.attributesselection.UserDefinedSelectionConfig;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.CodeGeneratorUtils;

public class QuerySelectCodeGenerator {
    private QuerySelectCodeGenerator() {
    }

    public static String generateQuerySelect(AttributesSelectionConfig attributesSelection) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(attributesSelection);
        StringBuilder attributesSelectionStringBuilder = new StringBuilder();
        attributesSelectionStringBuilder.append('\n').append("select").append(' ');
        switch (attributesSelection.getType().toUpperCase()) {
            case "USER_DEFINED": {
                UserDefinedSelectionConfig userDefinedSelection = (UserDefinedSelectionConfig)attributesSelection;
                attributesSelectionStringBuilder.append(QuerySelectCodeGenerator.generateUserDefinedSelection(userDefinedSelection));
                break;
            }
            case "ALL": {
                attributesSelectionStringBuilder.append('*');
                break;
            }
            default: {
                throw new CodeGenerationException("Undefined attribute selection type:" + attributesSelection.getType());
            }
        }
        return attributesSelectionStringBuilder.toString();
    }

    private static String generateUserDefinedSelection(UserDefinedSelectionConfig userDefinedSelection) throws CodeGenerationException {
        if (userDefinedSelection == null || userDefinedSelection.getValue() == null || userDefinedSelection.getValue().isEmpty()) {
            throw new CodeGenerationException("A given user defined selection value is empty");
        }
        StringBuilder userDefinedSelectionStringBuilder = new StringBuilder();
        int attributesLeft = userDefinedSelection.getValue().size();
        for (SelectedAttribute attribute : userDefinedSelection.getValue()) {
            CodeGeneratorUtils.NullValidator.validateConfigObject(attribute);
            userDefinedSelectionStringBuilder.append(attribute.getExpression());
            if (attribute.getAs() != null && !attribute.getAs().isEmpty() && !attribute.getAs().equals(attribute.getExpression())) {
                userDefinedSelectionStringBuilder.append(' ').append("as").append(' ').append(attribute.getAs());
            }
            if (attributesLeft != 1) {
                userDefinedSelectionStringBuilder.append(',');
            }
            --attributesLeft;
        }
        return userDefinedSelectionStringBuilder.toString();
    }
}

