/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.StoreConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.AggregationConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.aggregationbytimeperiod.AggregateByTimePeriod;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.aggregationbytimeperiod.aggregationbytimerange.AggregateByTimeInterval;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.aggregationbytimeperiod.aggregationbytimerange.AggregateByTimeRange;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.aggregationbytimeperiod.aggregationbytimerange.AggregationByTimeRangeValue;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.AnnotationConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.AttributesSelectionConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.CodeSegmentsPreserver;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.StoreConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.ConfigBuildingUtilities;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.aggregation.TimePeriod;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.definition.AggregationDefinition;
import io.siddhi.query.api.execution.query.selection.BasicSelector;
import io.siddhi.query.api.execution.query.selection.Selector;
import io.siddhi.query.api.expression.Variable;
import java.util.ArrayList;
import java.util.List;

public class AggregationConfigGenerator
extends CodeSegmentsPreserver {
    private String siddhiAppString;

    public AggregationConfigGenerator(String siddhiAppString) {
        this.siddhiAppString = siddhiAppString;
    }

    public AggregationConfig generateAggregationConfig(AggregationDefinition aggregationDefinition) throws DesignGenerationException {
        AggregationConfig aggregationConfig = new AggregationConfig();
        aggregationConfig.setName(aggregationDefinition.getId());
        aggregationConfig.setFrom(aggregationDefinition.getBasicSingleInputStream().getStreamId());
        AttributesSelectionConfigGenerator attributesSelectionConfigGenerator = new AttributesSelectionConfigGenerator(this.siddhiAppString);
        if (!(aggregationDefinition.getSelector() instanceof BasicSelector)) {
            throw new DesignGenerationException("Selector of AggregationDefinition is not of class BasicSelector");
        }
        this.preserveCodeSegment((SiddhiElement)aggregationDefinition.getSelector());
        BasicSelector selector = (BasicSelector)aggregationDefinition.getSelector();
        aggregationConfig.setSelect(attributesSelectionConfigGenerator.generateAttributesSelectionConfig((Selector)selector));
        aggregationConfig.setGroupBy(this.generateGroupBy(selector.getGroupByList()));
        aggregationConfig.setAggregateByAttribute(this.generateAggregateByAttribute(aggregationDefinition.getAggregateAttribute()));
        aggregationConfig.setAggregateByTime(this.generateAggregateByTime(aggregationDefinition.getTimePeriod()));
        StoreConfigGenerator storeConfigGenerator = new StoreConfigGenerator();
        AnnotationConfigGenerator annotationConfigGenerator = new AnnotationConfigGenerator();
        StoreConfig storeConfig = null;
        ArrayList<String> annotationList = new ArrayList<String>();
        ArrayList<Annotation> annotationListObjects = new ArrayList<Annotation>();
        for (Annotation annotation : aggregationDefinition.getAnnotations()) {
            if (annotation.getName().equalsIgnoreCase("STORE")) {
                storeConfig = storeConfigGenerator.generateStoreConfig(annotation);
                continue;
            }
            annotationListObjects.add(annotation);
            annotationList.add(annotationConfigGenerator.generateAnnotationConfig(annotation));
        }
        aggregationConfig.setStore(storeConfig);
        aggregationConfig.setAnnotationList(annotationList);
        aggregationConfig.setAnnotationListObjects(annotationListObjects);
        this.preserveCodeSegmentsOf(annotationConfigGenerator, storeConfigGenerator, attributesSelectionConfigGenerator);
        this.preserveAndBindCodeSegment((SiddhiElement)aggregationDefinition, aggregationConfig);
        return aggregationConfig;
    }

    private List<String> generateGroupBy(List<Variable> groupByVariables) throws DesignGenerationException {
        ArrayList<String> groupByList = new ArrayList<String>();
        for (Variable variable : groupByVariables) {
            this.preserveCodeSegment((SiddhiElement)variable);
            groupByList.add(ConfigBuildingUtilities.getDefinition((SiddhiElement)variable, this.siddhiAppString));
        }
        return groupByList;
    }

    private AggregateByTimePeriod generateAggregateByTime(TimePeriod timePeriod) throws DesignGenerationException {
        this.preserveCodeSegment((SiddhiElement)timePeriod);
        if ("INTERVAL".equalsIgnoreCase(timePeriod.getOperator().toString())) {
            return this.generateAggregateByTimeInterval(timePeriod.getDurations());
        }
        if ("RANGE".equalsIgnoreCase(timePeriod.getOperator().toString())) {
            return this.generateAggregateByTimeRange(timePeriod.getDurations());
        }
        throw new DesignGenerationException("Unable to generate AggregateByTime for TimePeriod of type unknown");
    }

    private AggregateByTimeInterval generateAggregateByTimeInterval(List<TimePeriod.Duration> durations) {
        ArrayList<String> intervals = new ArrayList<String>();
        for (TimePeriod.Duration duration : durations) {
            intervals.add(duration.name());
        }
        return new AggregateByTimeInterval(intervals);
    }

    private AggregateByTimeRange generateAggregateByTimeRange(List<TimePeriod.Duration> durations) {
        return new AggregateByTimeRange(new AggregationByTimeRangeValue(durations.get(0).name(), durations.get(durations.size() - 1).name()));
    }

    private String generateAggregateByAttribute(Variable aggregateAttribute) {
        if (aggregateAttribute != null) {
            this.preserveCodeSegment((SiddhiElement)aggregateAttribute);
            return aggregateAttribute.getAttributeName();
        }
        return "";
    }
}

