/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.TriggerConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.AnnotationConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.CodeSegmentsPreserver;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.ConfigBuildingUtilities;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.definition.TriggerDefinition;
import java.util.Map;

public class TriggerConfigGenerator
extends CodeSegmentsPreserver {
    private static final String EVERY_SPLIT_KEYWORD = " every ";
    private String siddhiAppString;
    private Map<String, StreamDefinition> streamDefinitions;

    public TriggerConfigGenerator(String siddhiAppString, Map<String, StreamDefinition> streamDefinitions) {
        this.siddhiAppString = siddhiAppString;
        this.streamDefinitions = streamDefinitions;
    }

    public TriggerConfig generateTriggerConfig(TriggerDefinition triggerDefinition) throws DesignGenerationException {
        String criteria = "";
        String criteriaType = "";
        if (triggerDefinition.getAtEvery() != null) {
            criteria = "every " + ConfigBuildingUtilities.getDefinition((SiddhiElement)triggerDefinition, this.siddhiAppString).split(EVERY_SPLIT_KEYWORD)[1];
            criteriaType = "every";
        } else if (triggerDefinition.getAt() != null) {
            criteria = triggerDefinition.getAt();
            criteriaType = "at";
        }
        AnnotationConfigGenerator annotationConfigGenerator = new AnnotationConfigGenerator();
        TriggerConfig triggerConfig = new TriggerConfig(triggerDefinition.getId(), triggerDefinition.getId(), criteria, criteriaType, annotationConfigGenerator.generateAnnotationConfigList(this.getTriggerStream(triggerDefinition.getId()).getAnnotations()));
        this.preserveCodeSegmentsOf(annotationConfigGenerator);
        this.preserveAndBindCodeSegment((SiddhiElement)triggerDefinition, triggerConfig);
        return triggerConfig;
    }

    private StreamDefinition getTriggerStream(String triggerName) throws DesignGenerationException {
        for (Map.Entry<String, StreamDefinition> streamDefinitionEntry : this.streamDefinitions.entrySet()) {
            if (!streamDefinitionEntry.getKey().equals(triggerName)) continue;
            return streamDefinitionEntry.getValue();
        }
        throw new DesignGenerationException("Unable to find stream for trigger '" + triggerName + "'");
    }
}

