/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.commentspreserver;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.CommentCodeSegment;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.ElementCodeSegment;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.SiddhiAppConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.StreamConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionWithElement;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.commentspreserver.ScopedCommentsPreserver;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PartitionScopeCommentsPreserver
extends ScopedCommentsPreserver {
    private PartitionConfig partitionConfig;
    private ElementCodeSegment partitionCodeSegment;

    public PartitionScopeCommentsPreserver(String siddhiAppString, PartitionConfig partitionConfig, Set<ElementCodeSegment> elementCodeSegments) {
        super(siddhiAppString, new ArrayList<ElementCodeSegment>(elementCodeSegments));
        this.partitionConfig = partitionConfig;
        this.partitionCodeSegment = new ElementCodeSegment(partitionConfig.getQueryContextStartIndex(), partitionConfig.getQueryContextEndIndex());
    }

    @Override
    public List<CommentCodeSegment> generateCommentCodeSegments() throws DesignGenerationException {
        Collections.sort(this.elementCodeSegments);
        this.elementCodeSegments = this.filterCurrentPartitionContainedCodeSegments(this.elementCodeSegments);
        this.elementCodeSegments = this.filterMajorElementCodeSegments(this.elementCodeSegments);
        this.commentCodeSegments = this.detectCommentCodeSegments(this.elementCodeSegments);
        this.commentCodeSegments = this.filterCommentsAfterPartitionWithKeyword(this.commentCodeSegments);
        return this.commentCodeSegments;
    }

    private List<ElementCodeSegment> filterCurrentPartitionContainedCodeSegments(List<ElementCodeSegment> elementCodeSegments) {
        ArrayList<ElementCodeSegment> filteredElementCodeSegments = new ArrayList<ElementCodeSegment>();
        ElementCodeSegment partitionElementCodeSegment = new ElementCodeSegment(this.partitionConfig.getQueryContextStartIndex(), this.partitionConfig.getQueryContextEndIndex());
        for (ElementCodeSegment elementCodeSegment : elementCodeSegments) {
            if (elementCodeSegment.equals(partitionElementCodeSegment) || !this.doesSegmentBelongToCurrentPartition(elementCodeSegment)) continue;
            filteredElementCodeSegments.add(elementCodeSegment);
        }
        return filteredElementCodeSegments;
    }

    private List<CommentCodeSegment> filterCommentsAfterPartitionWithKeyword(List<CommentCodeSegment> commentCodeSegments) {
        ArrayList<CommentCodeSegment> filteredCommentCodeSegments = new ArrayList<CommentCodeSegment>();
        int[] partitionWithLastIndex = this.getLastPartitionWithElementEndIndex(this.partitionConfig.getPartitionWith());
        for (CommentCodeSegment commentCodeSegment : commentCodeSegments) {
            if (commentCodeSegment.getStartLine() <= partitionWithLastIndex[0] && (commentCodeSegment.getStartLine() != partitionWithLastIndex[0] || commentCodeSegment.getStartColumn() < partitionWithLastIndex[1])) continue;
            filteredCommentCodeSegments.add(commentCodeSegment);
        }
        filteredCommentCodeSegments.set(0, this.getTrimmedFirstInnerPartitionCommentSegment((CommentCodeSegment)filteredCommentCodeSegments.get(0)));
        return filteredCommentCodeSegments;
    }

    @Override
    public SiddhiAppConfig bindCommentsToElements(Collection<CommentCodeSegment> commentCodeSegments, SiddhiAppConfig siddhiAppConfigReference) {
        PartitionConfig currentPartitionConfigReference = this.getCurrentPartitionConfigReference(siddhiAppConfigReference);
        if (currentPartitionConfigReference != null) {
            for (StreamConfig streamConfig : currentPartitionConfigReference.getStreamList()) {
                this.assignPreviousCommentSegment(streamConfig, commentCodeSegments);
            }
            for (Map.Entry entry : currentPartitionConfigReference.getQueryLists().entrySet()) {
                for (QueryConfig queryConfig : (List)entry.getValue()) {
                    this.assignPreviousCommentSegment(queryConfig, commentCodeSegments);
                }
            }
        }
        return siddhiAppConfigReference;
    }

    private int[] getLastPartitionWithElementEndIndex(List<PartitionWithElement> partitionWithElements) {
        ArrayList<ElementCodeSegment> partitionWithCodeSegments = new ArrayList<ElementCodeSegment>();
        for (PartitionWithElement partitionWithElement : partitionWithElements) {
            partitionWithCodeSegments.add(new ElementCodeSegment(partitionWithElement.getQueryContextStartIndex(), partitionWithElement.getQueryContextEndIndex()));
        }
        Collections.sort(partitionWithCodeSegments);
        return ((ElementCodeSegment)partitionWithCodeSegments.get(partitionWithCodeSegments.size() - 1)).getQueryContextEndIndex();
    }

    private CommentCodeSegment getTrimmedFirstInnerPartitionCommentSegment(CommentCodeSegment firstCommentCodeSegment) {
        String begin = "begin";
        String[] splitArray = firstCommentCodeSegment.getContent().split("begin");
        String newContent = String.join((CharSequence)"begin", Arrays.copyOfRange(splitArray, 1, splitArray.length));
        int line = firstCommentCodeSegment.getStartLine();
        int column = firstCommentCodeSegment.getStartColumn();
        for (char character : splitArray[0].toCharArray()) {
            if (character == '\n') {
                ++line;
                column = 0;
                continue;
            }
            ++column;
        }
        return new CommentCodeSegment(new int[]{line, column += "begin".length()}, firstCommentCodeSegment.getQueryContextEndIndex(), newContent);
    }

    private PartitionConfig getCurrentPartitionConfigReference(SiddhiAppConfig siddhiAppConfigReference) {
        for (PartitionConfig partitionConfigReference : siddhiAppConfigReference.getPartitionList()) {
            ElementCodeSegment codeSegment = new ElementCodeSegment(partitionConfigReference.getQueryContextStartIndex(), partitionConfigReference.getQueryContextEndIndex());
            if (!codeSegment.equals(this.partitionCodeSegment)) continue;
            return partitionConfigReference;
        }
        return null;
    }

    private boolean doesSegmentBelongToCurrentPartition(ElementCodeSegment elementCodeSegment) {
        ElementCodeSegment partitionElementCodeSegment = new ElementCodeSegment(this.partitionConfig.getQueryContextStartIndex(), this.partitionConfig.getQueryContextEndIndex());
        return this.isSegmentContainedIn(elementCodeSegment, partitionElementCodeSegment);
    }
}

