/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.attributesselection.AttributesSelectionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryOrderByConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.QueryInputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.join.JoinConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.patternsequence.PatternSequenceConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.windowfilterprojection.WindowFilterProjectionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.QueryOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.constants.query.QueryListType;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.AnnotationConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.AttributesSelectionConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.CodeSegmentsPreserver;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.QueryInputConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.output.QueryOutputConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.ConfigBuildingUtilities;
import io.siddhi.query.api.SiddhiApp;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.execution.query.Query;
import io.siddhi.query.api.execution.query.input.stream.InputStream;
import io.siddhi.query.api.execution.query.output.ratelimit.OutputRate;
import io.siddhi.query.api.execution.query.output.stream.OutputStream;
import io.siddhi.query.api.execution.query.selection.OrderByAttribute;
import io.siddhi.query.api.execution.query.selection.Selector;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.api.expression.constant.Constant;
import java.util.ArrayList;
import java.util.List;

public class QueryConfigGenerator
extends CodeSegmentsPreserver {
    private static final String DEFAULT_QUERY_NAME = "query";
    private String siddhiAppString;
    private SiddhiApp siddhiApp;

    public QueryConfigGenerator(String siddhiAppString, SiddhiApp siddhiApp) {
        this.siddhiAppString = siddhiAppString;
        this.siddhiApp = siddhiApp;
    }

    public static QueryListType getQueryListType(QueryConfig queryConfig) {
        QueryInputConfig queryInputConfig = queryConfig.getQueryInput();
        if (queryInputConfig instanceof WindowFilterProjectionConfig) {
            return QueryListType.WINDOW_FILTER_PROJECTION;
        }
        if (queryInputConfig instanceof JoinConfig) {
            return QueryListType.JOIN;
        }
        if (queryInputConfig instanceof PatternSequenceConfig) {
            return QueryListType.valueOf(queryInputConfig.getType());
        }
        throw new IllegalArgumentException("Type of Query Input is unknown, for adding the Query");
    }

    public QueryConfig generateQueryConfig(Query query, int queryCounter) throws DesignGenerationException {
        QueryConfig queryConfig = new QueryConfig();
        queryConfig.setQueryInput(this.generateInput(query.getInputStream()));
        Selector selector = query.getSelector();
        queryConfig.setSelect(this.generateSelect(selector));
        queryConfig.setGroupBy(this.generateGroupBy(selector.getGroupByList()));
        queryConfig.setOrderBy(this.generateOrderBy(selector.getOrderByList()));
        queryConfig.setHaving(this.generateHaving(selector.getHavingExpression()));
        queryConfig.setLimit(this.generateLimit(selector.getLimit()));
        queryConfig.setOffset(this.generateOffset(selector.getOffset()));
        queryConfig.setQueryOutput(this.generateOutput(query.getOutputStream()));
        queryConfig.setOutputRateLimit(this.generateOutputRateLimit(query.getOutputRate()));
        queryConfig.setAnnotationListObjects(this.removeInfoAnnotation(query.getAnnotations()));
        queryConfig.setAnnotationList(this.generateAnnotationList(query.getAnnotations()));
        queryConfig.setQueryName(this.generateQueryName(query.getAnnotations(), queryCounter));
        this.preserveAndBindCodeSegment((SiddhiElement)query, queryConfig);
        return queryConfig;
    }

    private QueryInputConfig generateInput(InputStream inputStream) throws DesignGenerationException {
        return new QueryInputConfigGenerator(this.siddhiAppString, this.siddhiApp).generateQueryInputConfig(inputStream);
    }

    private AttributesSelectionConfig generateSelect(Selector selector) {
        AttributesSelectionConfigGenerator attributesSelectionConfigGenerator = new AttributesSelectionConfigGenerator(this.siddhiAppString);
        this.preserveCodeSegmentsOf(attributesSelectionConfigGenerator);
        return attributesSelectionConfigGenerator.generateAttributesSelectionConfig(selector);
    }

    private QueryOutputConfig generateOutput(OutputStream outputStream) throws DesignGenerationException {
        return new QueryOutputConfigGenerator(this.siddhiAppString).generateQueryOutputConfig(outputStream);
    }

    private List<String> generateGroupBy(List<Variable> groupByList) throws DesignGenerationException {
        ArrayList<String> groupBy = new ArrayList<String>();
        for (Variable variable : groupByList) {
            groupBy.add(ConfigBuildingUtilities.getDefinition((SiddhiElement)variable, this.siddhiAppString));
        }
        return groupBy;
    }

    private List<QueryOrderByConfig> generateOrderBy(List<OrderByAttribute> orderByAttributeList) {
        ArrayList<QueryOrderByConfig> orderBy = new ArrayList<QueryOrderByConfig>();
        for (OrderByAttribute orderByAttribute : orderByAttributeList) {
            String value = "";
            if (orderByAttribute.getVariable().getStreamId() != null) {
                value = orderByAttribute.getVariable().getStreamId() + ".";
            }
            value = value + orderByAttribute.getVariable().getAttributeName();
            orderBy.add(new QueryOrderByConfig(value, orderByAttribute.getOrder().name()));
        }
        return orderBy;
    }

    private String generateHaving(Expression havingExpression) throws DesignGenerationException {
        if (havingExpression != null) {
            return ConfigBuildingUtilities.getDefinition((SiddhiElement)havingExpression, this.siddhiAppString);
        }
        return "";
    }

    private String generateOutputRateLimit(OutputRate outputRate) throws DesignGenerationException {
        String output = "output";
        if (outputRate != null) {
            return ConfigBuildingUtilities.getDefinition((SiddhiElement)outputRate, this.siddhiAppString).split("output")[1].trim();
        }
        return "";
    }

    private long generateLimit(Constant limit) throws DesignGenerationException {
        if (limit != null) {
            return Long.parseLong(ConfigBuildingUtilities.getDefinition((SiddhiElement)limit, this.siddhiAppString));
        }
        return 0L;
    }

    private long generateOffset(Constant offset) throws DesignGenerationException {
        if (offset != null) {
            return Long.parseLong(ConfigBuildingUtilities.getDefinition((SiddhiElement)offset, this.siddhiAppString));
        }
        return 0L;
    }

    private List<String> generateAnnotationList(List<Annotation> queryAnnotations) {
        ArrayList<String> annotationList = new ArrayList<String>();
        AnnotationConfigGenerator annotationConfigGenerator = new AnnotationConfigGenerator();
        for (Annotation queryAnnotation : queryAnnotations) {
            if (queryAnnotation.getName().equalsIgnoreCase("info")) continue;
            annotationList.add(annotationConfigGenerator.generateAnnotationConfig(queryAnnotation));
        }
        this.preserveCodeSegmentsOf(annotationConfigGenerator);
        return annotationList;
    }

    private List<Annotation> removeInfoAnnotation(List<Annotation> queryAnnotations) {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        for (Annotation queryAnnotation : queryAnnotations) {
            if (queryAnnotation.getName().equalsIgnoreCase("info")) continue;
            annotationList.add(queryAnnotation);
        }
        return annotationList;
    }

    private String generateQueryName(List<Annotation> annotations, int queryNumber) {
        String queryName = "";
        boolean isQueryName = false;
        for (Annotation annotation : annotations) {
            if (!annotation.getName().equalsIgnoreCase("info")) continue;
            this.preserveCodeSegment((SiddhiElement)annotation);
            queryName = annotation.getElement("name");
            isQueryName = true;
        }
        if (!isQueryName) {
            queryName = DEFAULT_QUERY_NAME + queryNumber;
        }
        return queryName;
    }
}

