/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.join.JoinConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.join.JoinElementConfig;
import io.siddhi.distribution.editor.core.util.designview.constants.query.input.JoinWithType;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.streamhandler.StreamHandlerConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.ConfigBuildingUtilities;
import io.siddhi.query.api.SiddhiApp;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.execution.query.input.stream.InputStream;
import io.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import io.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import java.util.ArrayList;
import java.util.List;

public class JoinConfigGenerator {
    private List<String> streamIDs = new ArrayList<String>();
    private List<String> tableIDs = new ArrayList<String>();
    private List<String> aggregationIDs = new ArrayList<String>();
    private List<String> windowIDs = new ArrayList<String>();

    public JoinConfig getJoinQueryConfig(InputStream queryInputStream, SiddhiApp siddhiApp, String siddhiAppString) throws DesignGenerationException {
        this.distinguishElements(queryInputStream.getUniqueStreamIds(), siddhiApp);
        return this.generateJoinConfig(queryInputStream, siddhiAppString);
    }

    private JoinWithType getJoinWithType() throws DesignGenerationException {
        if (this.tableIDs.size() == 1) {
            return JoinWithType.TABLE;
        }
        if (this.aggregationIDs.size() == 1) {
            return JoinWithType.AGGREGATION;
        }
        if (this.windowIDs.size() == 1) {
            return JoinWithType.WINDOW;
        }
        if (!this.streamIDs.isEmpty()) {
            return JoinWithType.STREAM;
        }
        throw new DesignGenerationException("Unknown element present in Join Query");
    }

    private JoinElementType getJoinElementType(String streamId) {
        if (this.tableIDs.contains(streamId)) {
            return JoinElementType.TABLE;
        }
        if (this.aggregationIDs.contains(streamId)) {
            return JoinElementType.AGGREGATION;
        }
        if (this.windowIDs.contains(streamId)) {
            return JoinElementType.WINDOW;
        }
        return JoinElementType.STREAM;
    }

    private void distinguishElements(List<String> streamIds, SiddhiApp siddhiApp) {
        for (String streamId : streamIds) {
            if (siddhiApp.getTableDefinitionMap().containsKey(streamId)) {
                this.tableIDs.add(streamId);
                continue;
            }
            if (siddhiApp.getAggregationDefinitionMap().containsKey(streamId)) {
                this.aggregationIDs.add(streamId);
                continue;
            }
            if (siddhiApp.getWindowDefinitionMap().containsKey(streamId)) {
                this.windowIDs.add(streamId);
                continue;
            }
            this.streamIDs.add(streamId);
        }
        if (this.streamIDs.isEmpty()) {
            throw new IllegalArgumentException("Unable to convert a Join Query Input with no streams");
        }
    }

    private JoinElementConfig generateJoinElementConfig(SingleInputStream singleInputStream, String siddhiAppString) throws DesignGenerationException {
        JoinElementType joinElementType = this.getJoinElementType(singleInputStream.getStreamId());
        return new JoinElementConfig(joinElementType.toString(), singleInputStream.getStreamId(), new StreamHandlerConfigGenerator(siddhiAppString).generateStreamHandlerConfigList(singleInputStream.getStreamHandlers()), singleInputStream.getStreamReferenceId(), false);
    }

    private JoinConfig generateJoinConfig(InputStream queryInputStream, String siddhiAppString) throws DesignGenerationException {
        JoinInputStream joinInputStream = (JoinInputStream)queryInputStream;
        JoinElementConfig leftElement = this.generateJoinElementConfig((SingleInputStream)joinInputStream.getLeftInputStream(), siddhiAppString);
        JoinElementConfig rightElement = this.generateJoinElementConfig((SingleInputStream)joinInputStream.getRightInputStream(), siddhiAppString);
        if (joinInputStream.getTrigger().name().equalsIgnoreCase(JoinDirection.LEFT.toString())) {
            leftElement.setUnidirectional(true);
        } else if (joinInputStream.getTrigger().name().equalsIgnoreCase(JoinDirection.RIGHT.toString())) {
            rightElement.setUnidirectional(true);
        }
        JoinConfig joinConfig = new JoinConfig(this.getJoinWithType().toString(), leftElement, joinInputStream.getType().name(), rightElement, null, null, null);
        if (joinInputStream.getOnCompare() != null) {
            joinConfig.setOn(ConfigBuildingUtilities.getDefinition((SiddhiElement)joinInputStream.getOnCompare(), siddhiAppString));
        }
        if (joinInputStream.getWithin() != null) {
            joinConfig.setWithin(ConfigBuildingUtilities.getDefinition((SiddhiElement)joinInputStream.getWithin(), siddhiAppString).split("within ")[1]);
        }
        if (joinInputStream.getPer() != null) {
            joinConfig.setPer(ConfigBuildingUtilities.getDefinition((SiddhiElement)joinInputStream.getPer(), siddhiAppString));
        }
        return joinConfig;
    }

    private static enum JoinDirection {
        LEFT,
        RIGHT;

    }

    private static enum JoinElementType {
        STREAM,
        TABLE,
        AGGREGATION,
        WINDOW;

    }
}

