/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.output;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.QueryOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.DeleteOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.InsertOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.UpdateInsertIntoOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.setattribute.SetAttributeConfig;
import io.siddhi.distribution.editor.core.util.designview.constants.query.QueryOutputType;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.ConfigBuildingUtilities;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.execution.query.output.stream.DeleteStream;
import io.siddhi.query.api.execution.query.output.stream.InsertIntoStream;
import io.siddhi.query.api.execution.query.output.stream.OutputStream;
import io.siddhi.query.api.execution.query.output.stream.UpdateOrInsertStream;
import io.siddhi.query.api.execution.query.output.stream.UpdateSet;
import io.siddhi.query.api.execution.query.output.stream.UpdateStream;
import java.util.ArrayList;
import java.util.List;

public class QueryOutputConfigGenerator {
    private String siddhiAppString;

    public QueryOutputConfigGenerator(String siddhiAppString) {
        this.siddhiAppString = siddhiAppString;
    }

    public QueryOutputConfig generateQueryOutputConfig(OutputStream queryOutputStream) throws DesignGenerationException {
        if (queryOutputStream instanceof InsertIntoStream) {
            return this.generateInsertOutputConfig((InsertIntoStream)queryOutputStream);
        }
        if (queryOutputStream instanceof DeleteStream) {
            return this.generateDeleteOutputConfig((DeleteStream)queryOutputStream);
        }
        if (queryOutputStream instanceof UpdateStream) {
            return this.generateUpdateOutputConfig((UpdateStream)queryOutputStream);
        }
        if (queryOutputStream instanceof UpdateOrInsertStream) {
            return this.generateUpdateOrInsertIntoOutputConfig((UpdateOrInsertStream)queryOutputStream);
        }
        throw new DesignGenerationException("Unknown type of Query Output Stream for generating Query Output Config");
    }

    private QueryOutputConfig generateInsertOutputConfig(InsertIntoStream insertIntoStream) {
        return new QueryOutputConfig(QueryOutputType.INSERT.toString(), new InsertOutputConfig(insertIntoStream.getOutputEventType().name()), insertIntoStream.getId());
    }

    private QueryOutputConfig generateDeleteOutputConfig(DeleteStream deleteStream) throws DesignGenerationException {
        return new QueryOutputConfig(QueryOutputType.DELETE.toString(), new DeleteOutputConfig(deleteStream.getOutputEventType().name(), ConfigBuildingUtilities.getDefinition((SiddhiElement)deleteStream.getOnDeleteExpression(), this.siddhiAppString)), deleteStream.getId());
    }

    private QueryOutputConfig generateUpdateOutputConfig(UpdateStream updateStream) throws DesignGenerationException {
        List<SetAttributeConfig> setAttributeConfigList = null;
        if (updateStream.getUpdateSet() != null) {
            setAttributeConfigList = this.generateSetAttributeConfigsList(updateStream.getUpdateSet().getSetAttributeList());
        }
        return new QueryOutputConfig(QueryOutputType.UPDATE.toString(), new UpdateInsertIntoOutputConfig(updateStream.getOutputEventType().name(), setAttributeConfigList, ConfigBuildingUtilities.getDefinition((SiddhiElement)updateStream.getOnUpdateExpression(), this.siddhiAppString)), updateStream.getId());
    }

    private QueryOutputConfig generateUpdateOrInsertIntoOutputConfig(UpdateOrInsertStream updateOrInsertStream) throws DesignGenerationException {
        List<SetAttributeConfig> setAttributeConfigList = null;
        if (updateOrInsertStream.getUpdateSet() != null) {
            setAttributeConfigList = this.generateSetAttributeConfigsList(updateOrInsertStream.getUpdateSet().getSetAttributeList());
        }
        return new QueryOutputConfig(QueryOutputType.UPDATE_OR_INSERT_INTO.toString(), new UpdateInsertIntoOutputConfig(updateOrInsertStream.getOutputEventType().name(), setAttributeConfigList, ConfigBuildingUtilities.getDefinition((SiddhiElement)updateOrInsertStream.getOnUpdateExpression(), this.siddhiAppString)), updateOrInsertStream.getId());
    }

    private List<SetAttributeConfig> generateSetAttributeConfigsList(List<UpdateSet.SetAttribute> setAttributes) throws DesignGenerationException {
        ArrayList<SetAttributeConfig> setAttributeConfigs = new ArrayList<SetAttributeConfig>();
        for (UpdateSet.SetAttribute setAttribute : setAttributes) {
            String attributeName = setAttribute.getTableVariable().getAttributeName();
            if (setAttribute.getTableVariable().getStreamId() != null) {
                attributeName = setAttribute.getTableVariable().getStreamId() + "." + attributeName;
            }
            String attributeValue = ConfigBuildingUtilities.getDefinition((SiddhiElement)setAttribute.getAssignmentExpression(), this.siddhiAppString);
            setAttributeConfigs.add(new SetAttributeConfig(attributeName, attributeValue));
        }
        return setAttributeConfigs;
    }
}

