/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.restclients.storequery;

import feign.Response;
import io.siddhi.distribution.editor.core.exception.SiddhiStoreQueryHelperException;
import io.siddhi.distribution.editor.core.util.restclients.storequery.StoreQueryHTTPClient;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.transport.http.netty.contract.config.ListenerConfiguration;
import org.wso2.transport.http.netty.contract.config.TransportsConfiguration;

public class StoreQueryAPIHelper {
    private static final Logger logger = Logger.getLogger(StoreQueryAPIHelper.class);
    private static final String STORE_API_CONFIG = "storeRESTAPI";
    private ConfigProvider configProvider;

    public StoreQueryAPIHelper(ConfigProvider configProvider) {
        this.configProvider = configProvider;
    }

    public Response executeStoreQuery(String query) throws SiddhiStoreQueryHelperException {
        try {
            String url;
            HashMap storeAPIConfig = (HashMap)this.configProvider.getConfigurationObject(STORE_API_CONFIG);
            if (storeAPIConfig != null) {
                String host = storeAPIConfig.get("host") != null ? (String)storeAPIConfig.get("host") : "0.0.0.0";
                String port = storeAPIConfig.get("port") != null ? (String)storeAPIConfig.get("port") : "9390";
                url = host + ":" + port;
            } else {
                url = "0.0.0.0:9390";
            }
            return StoreQueryHTTPClient.executeStoreQuery(url, query);
        }
        catch (ConfigurationException e) {
            throw new SiddhiStoreQueryHelperException("Cannot read store query API configurations.", e);
        }
    }

    private String getStoreAPIHost() throws SiddhiStoreQueryHelperException {
        try {
            TransportsConfiguration transportsConfiguration = (TransportsConfiguration)this.configProvider.getConfigurationObject("transports", TransportsConfiguration.class);
            for (ListenerConfiguration listenerConfiguration : transportsConfiguration.getListenerConfigurations()) {
                if (!"default".equals(listenerConfiguration.getId())) continue;
                logger.debug((Object)"Default configurations found in listener configurations.");
                return listenerConfiguration.getHost() + ":" + listenerConfiguration.getPort();
            }
        }
        catch (ConfigurationException e) {
            throw new SiddhiStoreQueryHelperException("Cannot read store query API configurations.", e);
        }
        throw new SiddhiStoreQueryHelperException("Cannot find store query API configurations.");
    }
}

