/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.internal;

import io.siddhi.distribution.editor.core.util.HostAddressFinder;
import java.net.SocketException;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.MicroservicesServer;
import org.wso2.transport.http.netty.contract.config.ListenerConfiguration;

@Component(service={StartupComponent.class}, immediate=true)
public class StartupComponent {
    private static final Logger logger = LoggerFactory.getLogger(StartupComponent.class);

    @Activate
    protected void start(BundleContext bundleContext) {
        logger.debug("Editor Core Startup Listener Service Component is Activated");
    }

    @Deactivate
    protected void stop() {
        logger.debug("Editor Core Startup Listener Service Component is Deactivated");
    }

    @Reference(service=MicroservicesServer.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetMicroservicesServer")
    protected void setMicroservicesServer(MicroservicesServer microservicesServer) {
        microservicesServer.getListenerConfigurations().entrySet().stream().forEach(entry -> {
            if ("http".equals(((ListenerConfiguration)entry.getValue()).getScheme())) {
                String hostname;
                try {
                    hostname = HostAddressFinder.findAddress(((ListenerConfiguration)entry.getValue()).getHost());
                }
                catch (SocketException e) {
                    hostname = ((ListenerConfiguration)entry.getValue()).getHost();
                    logger.error("Error in finding address for provided hostname " + hostname + "." + e.getMessage(), (Throwable)e);
                }
                String startingURL = ((ListenerConfiguration)entry.getValue()).getScheme() + "://" + hostname + ":" + ((ListenerConfiguration)entry.getValue()).getPort() + "/editor";
                logger.info("Editor Started on : " + startingURL);
            }
        });
        logger.debug("Microservices server registered to startup component of editor");
    }

    protected void unsetMicroservicesServer(MicroservicesServer microservicesServer) {
        logger.debug("Microservices server unregistered from startup component of editor");
    }
}

