/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.internal;

import io.siddhi.distribution.common.common.EventStreamService;
import io.siddhi.distribution.editor.core.exception.SiddhiAppDeploymentException;
import io.siddhi.distribution.editor.core.internal.EditorDataHolder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.FilenameUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.deployment.engine.Artifact;
import org.wso2.carbon.deployment.engine.ArtifactType;
import org.wso2.carbon.deployment.engine.Deployer;
import org.wso2.carbon.deployment.engine.exception.CarbonDeploymentException;

@Component(name="workspace-artifact-deployer", immediate=true, service={Deployer.class})
public class WorkspaceDeployer
implements Deployer {
    private static final String WORKSPACE_DIRECTORY = "workspace";
    private static final Logger log = LoggerFactory.getLogger(WorkspaceDeployer.class);
    private static final String FILE_EXTENSION = "siddhi";
    private ArtifactType artifactType = new ArtifactType((Object)"siddhi");
    private URL directoryLocation;

    private static String getStringFromInputStream(InputStream is) throws SiddhiAppDeploymentException {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            while ((line = br.readLine()) != null) {
                sb.append(System.getProperty("line.separator")).append(line);
            }
        }
        catch (IOException e) {
            throw new SiddhiAppDeploymentException("Exception when reading the Siddhi QL file", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    throw new SiddhiAppDeploymentException("Exception when closing the Siddhi QL file stream", e);
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployConfigFile(File file) throws Exception {
        if (!file.getName().startsWith(".")) {
            InputStream inputStream = null;
            try {
                if (FilenameUtils.isExtension(file.getName(), FILE_EXTENSION)) {
                    String siddhiAppName = FilenameUtils.getBaseName(file.getName());
                    inputStream = new FileInputStream(file);
                    String siddhiApp = WorkspaceDeployer.getStringFromInputStream(inputStream);
                    EditorDataHolder.getDebugProcessorService().deploy(siddhiAppName, siddhiApp);
                    log.info("Siddhi App " + siddhiAppName + " successfully deployed.");
                } else {
                    log.error("Error: File extension not supported for file name " + file.getName() + ". Supports only '" + FILE_EXTENSION + "'.");
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        throw new SiddhiAppDeploymentException("Error when closing the Siddhi QL filestream", e);
                    }
                }
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
    }

    public void init() {
        try {
            this.directoryLocation = new URL("file:workspace");
            log.info("Workspace artifact deployer initiated.");
        }
        catch (MalformedURLException e) {
            log.error("Error while initializing workspace artifact directoryLocation : workspace", (Throwable)e);
        }
    }

    public Object deploy(Artifact artifact) throws CarbonDeploymentException {
        try {
            this.deployConfigFile(artifact.getFile());
        }
        catch (Exception e) {
            throw new CarbonDeploymentException(e.getMessage(), e);
        }
        return artifact.getFile().getName();
    }

    public void undeploy(Object key) throws CarbonDeploymentException {
        try {
            String siddhiAppName = FilenameUtils.getBaseName((String)key);
            if (EditorDataHolder.getSiddhiAppMap().containsKey(siddhiAppName)) {
                EditorDataHolder.getDebugProcessorService().undeploy(siddhiAppName);
            }
        }
        catch (Exception e) {
            throw new CarbonDeploymentException(e.getMessage(), e);
        }
    }

    public Object update(Artifact artifact) throws CarbonDeploymentException {
        try {
            this.deployConfigFile(artifact.getFile());
        }
        catch (Exception e) {
            throw new CarbonDeploymentException(e.getMessage(), e);
        }
        return artifact.getName();
    }

    public URL getLocation() {
        return this.directoryLocation;
    }

    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    @Reference(name="event.stream.service", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventStreamService")
    protected void setEventStreamService(EventStreamService eventStreamService) {
        if (log.isDebugEnabled()) {
            log.info("@Reference(bind) EventStreamService");
        }
    }

    protected void unsetEventStreamService(EventStreamService eventStreamService) {
        if (log.isDebugEnabled()) {
            log.info("@Reference(unbind) EventStreamService");
        }
    }
}

