/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.List;
import java.util.Random;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class SampleEventGenerator {
    private static double[] doubleValues = new double[]{1.23434, 4.504343, 5.443435, 20.44345, 90.34344};
    private static int[] intValues = new int[]{4, 50, 100, 45, 70};
    private static boolean[] booleanValues = new boolean[]{true, false};
    private static float[] floatValues = new float[]{6.6f, 4.5f, 8.9f, 2.3f, 9.8f};
    private static long[] longValues = new long[]{56783L, 545455L, 645565L, 323232L, 4354643L};
    private static String[] stringValues = new String[]{"data1", "data2", "data3", "data4", "data5"};

    private SampleEventGenerator() {
    }

    public static String generateXMLEvent(StreamDefinition streamDefinition) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement sampleEventsElement = factory.createOMElement(new QName("events"));
        OMElement sampleEventElement = factory.createOMElement(new QName("event"));
        List attributeList = streamDefinition.getAttributeList();
        if (attributeList != null && attributeList.size() > 0) {
            for (Attribute attribute : attributeList) {
                OMElement propertyElement = factory.createOMElement(new QName(attribute.getName()));
                propertyElement.setText(SampleEventGenerator.getSampleValue(attribute.getType()));
                sampleEventElement.addChild((OMNode)propertyElement);
            }
        }
        sampleEventsElement.addChild((OMNode)sampleEventElement);
        return sampleEventsElement.toString();
    }

    public static String generateJSONEvent(StreamDefinition streamDefinition) {
        JsonObject jsonEventObject = new JsonObject();
        JsonObject innerParentObject = new JsonObject();
        List attributeList = streamDefinition.getAttributeList();
        if (attributeList.size() > 0) {
            for (Attribute attribute : attributeList) {
                if (attribute.getType().name().toLowerCase().equals("string")) {
                    innerParentObject.addProperty(attribute.getName(), SampleEventGenerator.getSampleValue(attribute.getType()));
                    continue;
                }
                if (attribute.getType().name().toLowerCase().equals("bool")) {
                    innerParentObject.addProperty(attribute.getName(), Boolean.valueOf(Boolean.parseBoolean(SampleEventGenerator.getSampleValue(attribute.getType()))));
                    continue;
                }
                innerParentObject.addProperty(attribute.getName(), (Number)Double.parseDouble(SampleEventGenerator.getSampleValue(attribute.getType())));
            }
            jsonEventObject.add("event", (JsonElement)innerParentObject);
        }
        return jsonEventObject.toString();
    }

    public static String generateTextEvent(StreamDefinition streamDefinition) {
        StringBuilder sampleEvent = new StringBuilder();
        List attributeList = streamDefinition.getAttributeList();
        if (attributeList != null && attributeList.size() > 0) {
            for (int i = 0; i < attributeList.size(); ++i) {
                if (i != 0) {
                    sampleEvent.append(",\n");
                }
                if ("string".equals(((Attribute)attributeList.get(i)).getType().toString())) {
                    sampleEvent.append(((Attribute)attributeList.get(i)).getName()).append(":").append("'").append(SampleEventGenerator.getSampleValue(((Attribute)attributeList.get(i)).getType())).append("'");
                    continue;
                }
                sampleEvent.append(((Attribute)attributeList.get(i)).getName()).append(":").append(SampleEventGenerator.getSampleValue(((Attribute)attributeList.get(i)).getType()));
            }
        }
        return sampleEvent.toString();
    }

    private static String getSampleValue(Attribute.Type attributeType) {
        Random rand = new Random();
        switch (attributeType.name().toLowerCase()) {
            case "float": {
                int hostIndex = rand.nextInt(5);
                return floatValues[hostIndex] + "";
            }
            case "double": {
                int hostIndex = rand.nextInt(5);
                return doubleValues[hostIndex] + "";
            }
            case "int": {
                int hostIndex = rand.nextInt(5);
                return intValues[hostIndex] + "";
            }
            case "long": {
                int hostIndex = rand.nextInt(5);
                return longValues[hostIndex] + "";
            }
            case "bool": {
                int hostIndex = rand.nextInt(2);
                return booleanValues[hostIndex] + "";
            }
            case "string": {
                int hostIndex = rand.nextInt(5);
                return stringValues[hostIndex] + "";
            }
        }
        return "";
    }
}

