/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.beans.configs;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.CommentCodeSegment;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.ElementCodeSegment;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.FunctionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.SiddhiElementConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.StreamConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.TableConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.TriggerConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.WindowConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.AggregationConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.SourceSinkConfig;
import io.siddhi.distribution.editor.core.util.designview.constants.query.QueryListType;
import io.siddhi.query.api.annotation.Annotation;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SiddhiAppConfig {
    private int finalElementCount = 0;
    private String siddhiAppDescription = "";
    private String siddhiAppName = "";
    private List<String> appAnnotationList = new ArrayList<String>();
    private List<Annotation> appAnnotationListObjects = new ArrayList<Annotation>();
    private List<SourceSinkConfig> sourceList = new ArrayList<SourceSinkConfig>();
    private List<SourceSinkConfig> sinkList = new ArrayList<SourceSinkConfig>();
    private List<StreamConfig> streamList = new ArrayList<StreamConfig>();
    private List<TableConfig> tableList = new ArrayList<TableConfig>();
    private List<TriggerConfig> triggerList = new ArrayList<TriggerConfig>();
    private List<WindowConfig> windowList = new ArrayList<WindowConfig>();
    private List<AggregationConfig> aggregationList = new ArrayList<AggregationConfig>();
    private List<FunctionConfig> functionList = new ArrayList<FunctionConfig>();
    private Map<QueryListType, List<QueryConfig>> queryLists = new EnumMap<QueryListType, List<QueryConfig>>(QueryListType.class);
    private List<PartitionConfig> partitionList = new ArrayList<PartitionConfig>();
    private Set<ElementCodeSegment> elementCodeSegments = new HashSet<ElementCodeSegment>();
    private Set<CommentCodeSegment> commentCodeSegments = new HashSet<CommentCodeSegment>();

    public SiddhiAppConfig() {
        this.queryLists.put(QueryListType.WINDOW_FILTER_PROJECTION, new ArrayList());
        this.queryLists.put(QueryListType.JOIN, new ArrayList());
        this.queryLists.put(QueryListType.PATTERN, new ArrayList());
        this.queryLists.put(QueryListType.SEQUENCE, new ArrayList());
    }

    private String generateNextElementId() {
        return String.valueOf(++this.finalElementCount);
    }

    private String generatePartitionConnectorId(String partitionId, String connectorId) {
        return partitionId + "_pc" + connectorId;
    }

    private <T> void addElement(List<T> elementList, T elementConfig) {
        ((SiddhiElementConfig)elementConfig).setId(this.generateNextElementId());
        this.addElementCodeSegment((SiddhiElementConfig)elementConfig);
        elementList.add(elementConfig);
    }

    public void addElementCodeSegments(Set<ElementCodeSegment> elementCodeSegments) {
        this.elementCodeSegments.addAll(elementCodeSegments);
    }

    private void addElementCodeSegment(SiddhiElementConfig siddhiElementConfig) {
        ElementCodeSegment elementCodeSegment = new ElementCodeSegment(siddhiElementConfig.getQueryContextStartIndex(), siddhiElementConfig.getQueryContextEndIndex());
        if (elementCodeSegment.isValid()) {
            this.elementCodeSegments.add(elementCodeSegment);
        }
    }

    public void addQuery(QueryListType queryListType, QueryConfig queryConfig) {
        queryConfig.setId(this.generateNextElementId());
        this.addElementCodeSegment(queryConfig);
        this.queryLists.get((Object)queryListType).add(queryConfig);
    }

    public void addPartition(PartitionConfig partitionConfig) {
        partitionConfig.setId(this.generateNextElementId());
        HashMap<String, String> connectorsAndStreams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : partitionConfig.getConnectorsAndStreams().entrySet()) {
            connectorsAndStreams.put(this.generatePartitionConnectorId(partitionConfig.getId(), entry.getKey()), entry.getValue());
        }
        partitionConfig.setConnectorsAndStreams(connectorsAndStreams);
        for (List list : partitionConfig.getQueryLists().values()) {
            for (QueryConfig queryConfig : list) {
                queryConfig.setId(this.generateNextElementId());
                queryConfig.setPartitionId(partitionConfig.getId());
                queryConfig.setConnectorsAndStreams(connectorsAndStreams);
            }
        }
        for (StreamConfig streamConfig : partitionConfig.getStreamList()) {
            streamConfig.setId(this.generateNextElementId());
            streamConfig.setPartitionId(partitionConfig.getId());
            streamConfig.setConnectorsAndStreams(connectorsAndStreams);
        }
        this.addElementCodeSegment(partitionConfig);
        this.partitionList.add(partitionConfig);
    }

    public void addSource(SourceSinkConfig sourceConfig) {
        this.addElement(this.sourceList, sourceConfig);
    }

    public void addSink(SourceSinkConfig sinkConfig) {
        this.addElement(this.sinkList, sinkConfig);
    }

    public void add(StreamConfig streamConfig) {
        this.addElement(this.streamList, streamConfig);
    }

    public void add(TableConfig tableConfig) {
        this.addElement(this.tableList, tableConfig);
    }

    public void add(TriggerConfig triggerConfig) {
        this.addElement(this.triggerList, triggerConfig);
    }

    public void add(WindowConfig windowConfig) {
        this.addElement(this.windowList, windowConfig);
    }

    public void add(AggregationConfig aggregationConfig) {
        this.addElement(this.aggregationList, aggregationConfig);
    }

    public void add(FunctionConfig functionConfig) {
        this.addElement(this.functionList, functionConfig);
    }

    public void add(PartitionConfig partitionConfig) {
        this.addElement(this.partitionList, partitionConfig);
    }

    public String getSiddhiAppDescription() {
        return this.siddhiAppDescription;
    }

    public void setSiddhiAppDescription(String siddhiAppDescription) {
        this.siddhiAppDescription = siddhiAppDescription;
    }

    public String getSiddhiAppName() {
        return this.siddhiAppName;
    }

    public void setSiddhiAppName(String siddhiAppName) {
        this.siddhiAppName = siddhiAppName;
    }

    public List<String> getAppAnnotationList() {
        return this.appAnnotationList;
    }

    public void setAppAnnotationList(List<String> appAnnotationList) {
        this.appAnnotationList = appAnnotationList;
    }

    public List<Annotation> getAppAnnotationListObjects() {
        return this.appAnnotationListObjects;
    }

    public void setAppAnnotationListObjects(List<Annotation> appAnnotationListObjects) {
        this.appAnnotationListObjects = appAnnotationListObjects;
    }

    public List<SourceSinkConfig> getSourceList() {
        return this.sourceList;
    }

    public List<SourceSinkConfig> getSinkList() {
        return this.sinkList;
    }

    public List<StreamConfig> getStreamList() {
        return this.streamList;
    }

    public List<TableConfig> getTableList() {
        return this.tableList;
    }

    public List<TriggerConfig> getTriggerList() {
        return this.triggerList;
    }

    public List<WindowConfig> getWindowList() {
        return this.windowList;
    }

    public List<AggregationConfig> getAggregationList() {
        return this.aggregationList;
    }

    public Map<QueryListType, List<QueryConfig>> getQueryLists() {
        return this.queryLists;
    }

    public List<FunctionConfig> getFunctionList() {
        return this.functionList;
    }

    public List<PartitionConfig> getPartitionList() {
        return this.partitionList;
    }

    public Set<ElementCodeSegment> getElementCodeSegments() {
        return this.elementCodeSegments;
    }

    public Set<CommentCodeSegment> getCommentCodeSegments() {
        return this.commentCodeSegments;
    }

    public void assignCommentCodeSegments(List<CommentCodeSegment> commentCodeSegments) {
        this.commentCodeSegments.addAll(commentCodeSegments);
    }

    public void clearCommentCodeSegments() {
        this.commentCodeSegments = new HashSet<CommentCodeSegment>();
    }

    public int getFinalElementCount() {
        return this.finalElementCount;
    }
}

