/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.codegenerator.generators;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.AggregationConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.aggregationbytimeperiod.AggregateByTimePeriod;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.aggregationbytimeperiod.aggregationbytimerange.AggregateByTimeInterval;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.aggregationbytimeperiod.aggregationbytimerange.AggregateByTimeRange;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.SubElementCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.query.subelements.QuerySelectCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.query.subelements.QuerySubElementCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.CodeGeneratorUtils;
import java.util.List;

public class AggregationCodeGenerator {
    public String generateAggregation(AggregationConfig aggregation, boolean isGeneratingToolTip) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(aggregation);
        StringBuilder aggregationStringBuilder = new StringBuilder();
        if (!isGeneratingToolTip) {
            aggregationStringBuilder.append(SubElementCodeGenerator.generateComment(aggregation.getPreviousCommentSegment()));
        }
        aggregationStringBuilder.append(SubElementCodeGenerator.generateStore(aggregation.getStore())).append(this.generateAggregationAnnotations(aggregation.getAnnotationList())).append('\n').append("define aggregation").append(' ').append(aggregation.getName()).append('\n').append("from").append(' ').append(aggregation.getFrom()).append(QuerySelectCodeGenerator.generateQuerySelect(aggregation.getSelect())).append(QuerySubElementCodeGenerator.generateQueryGroupBy(aggregation.getGroupBy())).append('\n').append("aggregate");
        if (aggregation.getAggregateByAttribute() != null && !aggregation.getAggregateByAttribute().isEmpty()) {
            aggregationStringBuilder.append(' ').append("by").append(' ').append(aggregation.getAggregateByAttribute());
        }
        aggregationStringBuilder.append(' ').append("every").append(' ').append(this.generateAggregateByTimePeriod(aggregation.getAggregateByTimePeriod())).append(';');
        return aggregationStringBuilder.toString();
    }

    private String generateAggregationAnnotations(List<String> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return "";
        }
        StringBuilder annotationsStringBuilder = new StringBuilder();
        for (String annotation : annotations) {
            if (annotation.toUpperCase().contains("@PRIMARYKEY")) continue;
            annotationsStringBuilder.append(annotation);
        }
        return annotationsStringBuilder.toString();
    }

    private String generateAggregateByTimePeriod(AggregateByTimePeriod aggregateByTimePeriod) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(aggregateByTimePeriod);
        StringBuilder aggregateByTimePeriodStringBuilder = new StringBuilder();
        switch (aggregateByTimePeriod.getType().toUpperCase()) {
            case "RANGE": {
                aggregateByTimePeriodStringBuilder.append(this.generateAggregateByTimeRange((AggregateByTimeRange)aggregateByTimePeriod));
                break;
            }
            case "INTERVAL": {
                aggregateByTimePeriodStringBuilder.append(this.generateAggregateByTimeInterval((AggregateByTimeInterval)aggregateByTimePeriod));
                break;
            }
            default: {
                throw new CodeGenerationException("Unidentified aggregateByTimePeriod element type: " + aggregateByTimePeriod.getType());
            }
        }
        return aggregateByTimePeriodStringBuilder.toString();
    }

    private String generateAggregateByTimeInterval(AggregateByTimeInterval aggregateByTimeInterval) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(aggregateByTimeInterval);
        StringBuilder aggregateByTimeIntervalStringBuilder = new StringBuilder();
        int timeIntervalsLeft = aggregateByTimeInterval.getValue().size();
        for (String timeInterval : aggregateByTimeInterval.getValue()) {
            aggregateByTimeIntervalStringBuilder.append(timeInterval.toLowerCase());
            if (timeIntervalsLeft != 1) {
                aggregateByTimeIntervalStringBuilder.append(',');
            }
            --timeIntervalsLeft;
        }
        return aggregateByTimeIntervalStringBuilder.toString();
    }

    private String generateAggregateByTimeRange(AggregateByTimeRange aggregateByTimeRange) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(aggregateByTimeRange);
        return aggregateByTimeRange.getValue().getMin().toLowerCase() + "..." + aggregateByTimeRange.getValue().getMax().toLowerCase();
    }
}

