/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.codegenerator.generators;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.CommentCodeSegment;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.AttributeConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.StoreConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.streamhandler.FilterConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.streamhandler.FunctionWindowConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.streamhandler.StreamHandlerConfig;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.CodeGeneratorUtils;
import java.util.List;

public class SubElementCodeGenerator {
    private SubElementCodeGenerator() {
    }

    public static String generateComment(CommentCodeSegment comment) throws CodeGenerationException {
        if (comment == null) {
            return "";
        }
        if (comment.getContent() == null || comment.getContent().isEmpty()) {
            throw new CodeGenerationException("The content of a given comment object is empty");
        }
        return comment.getContent();
    }

    public static String generateQueryName(String queryName) {
        StringBuilder queryNameStringBuilder = new StringBuilder();
        if (queryName != null && !queryName.isEmpty()) {
            queryNameStringBuilder.append("@info(name='").append(queryName).append('\'').append(')');
        } else {
            queryNameStringBuilder.append("@info(name='query')");
        }
        return queryNameStringBuilder.toString();
    }

    static String generateAttributes(List<AttributeConfig> attributes) throws CodeGenerationException {
        if (attributes == null || attributes.isEmpty()) {
            throw new CodeGenerationException("A given attribute list is empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int attributesLeft = attributes.size();
        for (AttributeConfig attribute : attributes) {
            CodeGeneratorUtils.NullValidator.validateConfigObject(attribute);
            stringBuilder.append(attribute.getName()).append(' ').append(attribute.getType().toLowerCase());
            if (attributesLeft != 1) {
                stringBuilder.append(',');
            }
            --attributesLeft;
        }
        return stringBuilder.toString();
    }

    public static String generateAnnotations(List<String> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return "";
        }
        StringBuilder annotationsStringBuilder = new StringBuilder();
        for (String annotation : annotations) {
            annotationsStringBuilder.append(annotation);
        }
        return annotationsStringBuilder.toString();
    }

    static String generateStore(StoreConfig store) throws CodeGenerationException {
        if (store == null) {
            return "";
        }
        CodeGeneratorUtils.NullValidator.validateConfigObject(store);
        StringBuilder storeStringBuilder = new StringBuilder();
        storeStringBuilder.append("@store(type='").append(store.getType()).append('\'');
        List<String> options = store.getOptions();
        storeStringBuilder.append(',');
        storeStringBuilder.append(SubElementCodeGenerator.generateParameterList(options));
        storeStringBuilder.append(')');
        return storeStringBuilder.toString();
    }

    public static String generateParameterList(List<String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        StringBuilder parametersStringBuilder = new StringBuilder();
        int parametersLeft = parameters.size();
        for (String parameter : parameters) {
            String[] parameterArray = parameter.split(Character.toString('='));
            if (parameterArray.length > 1) {
                parametersStringBuilder.append(parameterArray[0]).append('=');
                parameter = parameterArray[1];
            }
            if (parameter.matches("(.*)\"(.*)\"(.*)\"")) {
                parametersStringBuilder.append("\"\"").append(parameter.trim()).append("\"\"");
            } else {
                parametersStringBuilder.append(parameter);
            }
            if (parametersLeft != 1) {
                parametersStringBuilder.append(',');
            }
            --parametersLeft;
        }
        return parametersStringBuilder.toString();
    }

    public static String generateStreamHandlerList(List<StreamHandlerConfig> streamHandlerList) throws CodeGenerationException {
        if (streamHandlerList == null || streamHandlerList.isEmpty()) {
            return "";
        }
        StringBuilder streamHandlerListStringBuilder = new StringBuilder();
        for (StreamHandlerConfig streamHandler : streamHandlerList) {
            streamHandlerListStringBuilder.append(SubElementCodeGenerator.generateStreamHandler(streamHandler));
        }
        return streamHandlerListStringBuilder.toString();
    }

    private static String generateStreamHandler(StreamHandlerConfig streamHandler) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(streamHandler);
        StringBuilder streamHandlerStringBuilder = new StringBuilder();
        switch (streamHandler.getType().toUpperCase()) {
            case "FILTER": {
                FilterConfig filter = (FilterConfig)streamHandler;
                streamHandlerStringBuilder.append('[').append(filter.getValue()).append(']');
                break;
            }
            case "FUNCTION": {
                FunctionWindowConfig function = (FunctionWindowConfig)streamHandler;
                streamHandlerStringBuilder.append('#').append(function.getValue().getFunction()).append('(').append(SubElementCodeGenerator.generateParameterList(function.getValue().getParameters())).append(')');
                break;
            }
            case "WINDOW": {
                FunctionWindowConfig window = (FunctionWindowConfig)streamHandler;
                streamHandlerStringBuilder.append('#').append("window").append('.').append(window.getValue().getFunction()).append('(').append(SubElementCodeGenerator.generateParameterList(window.getValue().getParameters())).append(')');
                break;
            }
            default: {
                throw new CodeGenerationException("Unidentified stream handler type: " + streamHandler.getType());
            }
        }
        return streamHandlerStringBuilder.toString();
    }

    public static String generateForEventType(String eventType) throws CodeGenerationException {
        if (eventType == null || eventType.isEmpty()) {
            return "";
        }
        StringBuilder forEventTypeStringBuilder = new StringBuilder();
        forEventTypeStringBuilder.append(' ').append("for").append(' ');
        switch (eventType.toUpperCase()) {
            case "CURRENT_EVENTS": {
                forEventTypeStringBuilder.append("current events");
                break;
            }
            case "EXPIRED_EVENTS": {
                forEventTypeStringBuilder.append("expired events");
                break;
            }
            case "ALL_EVENTS": {
                forEventTypeStringBuilder.append("all events");
                break;
            }
            default: {
                throw new CodeGenerationException("Unidentified 'for' event type: " + eventType);
            }
        }
        return forEventTypeStringBuilder.toString();
    }

    private static String toStringWithEscapeChars(String elementStr) {
        String value;
        String key = null;
        if (elementStr == null || elementStr.isEmpty()) {
            throw new IllegalArgumentException("Input string is either null or empty.");
        }
        String[] keyValuePair = elementStr.split(" = ");
        if (keyValuePair.length == 1) {
            value = keyValuePair[0].trim().substring(1, keyValuePair[0].length() - 1);
        } else if (keyValuePair.length == 2) {
            key = keyValuePair[0];
            value = keyValuePair[1].trim().substring(1, keyValuePair[1].length() - 1);
        } else {
            throw new IllegalArgumentException("Could not convert to Element object. String format is invalid: " + elementStr);
        }
        StringBuilder valueWithQuotes = new StringBuilder();
        if (value != null && (value.contains("\"") || value.contains("\n"))) {
            valueWithQuotes.append("\"\"\"").append(value).append("\"\"\"");
        } else {
            valueWithQuotes.append('\"').append(value).append('\"');
        }
        if (key != null) {
            return key + " = " + valueWithQuotes.toString();
        }
        return valueWithQuotes.toString();
    }
}

