/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.query.subelements;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.QueryInputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.join.JoinConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.join.JoinElementConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.patternsequence.PatternSequenceConditionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.patternsequence.PatternSequenceConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.windowfilterprojection.WindowFilterProjectionConfig;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.SubElementCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.CodeGeneratorUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryInputCodeGenerator {
    private QueryInputCodeGenerator() {
    }

    public static String generateQueryInput(QueryInputConfig queryInput) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(queryInput);
        StringBuilder queryInputStringBuilder = new StringBuilder();
        switch (queryInput.getType().toUpperCase()) {
            case "WINDOW": 
            case "FILTER": 
            case "PROJECTION": 
            case "FUNCTION": {
                WindowFilterProjectionConfig windowFilterProjectionQuery = (WindowFilterProjectionConfig)queryInput;
                queryInputStringBuilder.append(QueryInputCodeGenerator.generateWindowFilterProjectionQueryInput(windowFilterProjectionQuery));
                break;
            }
            case "JOIN": {
                JoinConfig joinQuery = (JoinConfig)queryInput;
                queryInputStringBuilder.append(QueryInputCodeGenerator.generateJoinQueryInput(joinQuery));
                break;
            }
            case "PATTERN": 
            case "SEQUENCE": {
                PatternSequenceConfig patternSequence = (PatternSequenceConfig)queryInput;
                queryInputStringBuilder.append(QueryInputCodeGenerator.generatePatternSequenceInput(patternSequence));
                break;
            }
            default: {
                throw new CodeGenerationException("Unidentified query input type: " + queryInput.getType());
            }
        }
        return queryInputStringBuilder.toString();
    }

    private static String generateWindowFilterProjectionQueryInput(WindowFilterProjectionConfig windowFilterProjection) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(windowFilterProjection);
        return "\nfrom " + windowFilterProjection.getFrom() + SubElementCodeGenerator.generateStreamHandlerList(windowFilterProjection.getStreamHandlerList());
    }

    private static String generateJoinQueryInput(JoinConfig join) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(join);
        StringBuilder joinStringBuilder = new StringBuilder();
        joinStringBuilder.append('\n').append("from").append(' ').append(QueryInputCodeGenerator.generateJoinElement(join.getLeft())).append(' ').append(QueryInputCodeGenerator.generateJoinType(join.getJoinType())).append(' ').append(QueryInputCodeGenerator.generateJoinElement(join.getRight()));
        if (join.getOn() != null && !join.getOn().isEmpty()) {
            joinStringBuilder.append(' ').append("on").append(' ').append(join.getOn());
        }
        if (join.getJoinWith().equalsIgnoreCase("AGGREGATION")) {
            if (join.getWithin() == null || join.getWithin().isEmpty()) {
                throw new CodeGenerationException("The 'within' value for a given join aggregation query is empty");
            }
            if (join.getPer() == null || join.getPer().isEmpty()) {
                throw new CodeGenerationException("The 'per' attribute for a given join aggregation query is empty");
            }
            joinStringBuilder.append('\n').append("within").append(' ').append(join.getWithin()).append('\n').append("per").append(' ').append(join.getPer());
        }
        return joinStringBuilder.toString();
    }

    private static String generateJoinElement(JoinElementConfig joinElement) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(joinElement);
        StringBuilder joinElementStringBuilder = new StringBuilder();
        joinElementStringBuilder.append(joinElement.getFrom()).append(SubElementCodeGenerator.generateStreamHandlerList(joinElement.getStreamHandlerList()));
        if (joinElement.getAs() != null && !joinElement.getAs().isEmpty()) {
            joinElementStringBuilder.append(' ').append("as").append(' ').append(joinElement.getAs());
        }
        if (joinElement.isUnidirectional()) {
            joinElementStringBuilder.append(' ').append("unidirectional");
        }
        return joinElementStringBuilder.toString();
    }

    private static String generateJoinType(String joinType) throws CodeGenerationException {
        if (joinType == null || joinType.isEmpty()) {
            throw new CodeGenerationException("The 'joinType' value of a given join query is empty");
        }
        switch (joinType.toUpperCase()) {
            case "JOIN": {
                return "\njoin";
            }
            case "LEFT_OUTER_JOIN": {
                return "\nleft outer join";
            }
            case "RIGHT_OUTER_JOIN": {
                return "\nright outer join";
            }
            case "FULL_OUTER_JOIN": {
                return "\nfull outer join";
            }
        }
        throw new CodeGenerationException("Invalid Join Type: " + joinType);
    }

    private static String generatePatternSequenceInput(PatternSequenceConfig patternSequence) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(patternSequence);
        StringBuilder patternSequenceInputStringBuilder = new StringBuilder();
        patternSequenceInputStringBuilder.append('\n').append("from").append(' ');
        String logic = patternSequence.getLogic();
        for (PatternSequenceConditionConfig condition : patternSequence.getConditionList()) {
            if (!logic.contains(condition.getConditionId())) continue;
            Pattern pattern = Pattern.compile("not\\s+" + condition.getConditionId());
            Matcher matcher = pattern.matcher(logic);
            if (matcher.find()) {
                logic = logic.replace(condition.getConditionId(), QueryInputCodeGenerator.generatePatternSequenceConditionLogic(condition, true));
                continue;
            }
            logic = logic.replace(condition.getConditionId(), QueryInputCodeGenerator.generatePatternSequenceConditionLogic(condition, false));
        }
        patternSequenceInputStringBuilder.append(logic);
        return patternSequenceInputStringBuilder.toString();
    }

    private static String generatePatternSequenceConditionLogic(PatternSequenceConditionConfig condition, boolean hasNot) throws CodeGenerationException {
        CodeGeneratorUtils.NullValidator.validateConfigObject(condition);
        StringBuilder patternSequenceConditionStringBuilder = new StringBuilder();
        if (!hasNot) {
            patternSequenceConditionStringBuilder.append(condition.getConditionId()).append('=');
        }
        patternSequenceConditionStringBuilder.append(condition.getStreamName()).append(SubElementCodeGenerator.generateStreamHandlerList(condition.getStreamHandlerList()));
        return patternSequenceConditionStringBuilder.toString();
    }
}

