/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.query.subelements;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryOrderByConfig;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.generators.SubElementCodeGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.CodeGeneratorUtils;
import java.util.List;

public class QuerySubElementCodeGenerator {
    private QuerySubElementCodeGenerator() {
    }

    public static String generateQueryGroupBy(List<String> groupByList) {
        if (groupByList == null || groupByList.isEmpty()) {
            return "";
        }
        return "\ngroup by " + SubElementCodeGenerator.generateParameterList(groupByList);
    }

    public static String generateQueryOrderBy(List<QueryOrderByConfig> orderByList) throws CodeGenerationException {
        if (orderByList == null || orderByList.isEmpty()) {
            return "";
        }
        StringBuilder orderByListStringBuilder = new StringBuilder();
        orderByListStringBuilder.append('\n').append("order").append(' ').append("by").append(' ');
        int orderByAttributesLeft = orderByList.size();
        for (QueryOrderByConfig orderByAttribute : orderByList) {
            CodeGeneratorUtils.NullValidator.validateConfigObject(orderByAttribute);
            orderByListStringBuilder.append(orderByAttribute.getValue());
            if (orderByAttribute.getOrder() != null && !orderByAttribute.getOrder().isEmpty()) {
                orderByListStringBuilder.append(' ').append(orderByAttribute.getOrder());
            }
            if (orderByAttributesLeft != 1) {
                orderByListStringBuilder.append(',');
            }
            --orderByAttributesLeft;
        }
        return orderByListStringBuilder.toString();
    }

    public static String generateQueryLimit(long limit) {
        if (limit != 0L) {
            return "\nlimit " + limit;
        }
        return "";
    }

    public static String generateQueryOffset(long offset) {
        if (offset != 0L) {
            return "\noffset " + offset;
        }
        return "";
    }

    public static String generateQueryHaving(String having) {
        if (having == null || having.isEmpty()) {
            return "";
        }
        return "\nhaving " + having;
    }

    public static String generateQueryOutputRateLimit(String outputRateLimit) {
        if (outputRateLimit == null || outputRateLimit.isEmpty()) {
            return "";
        }
        return "\noutput " + outputRateLimit;
    }
}

