/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.deserializers.types;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.QueryOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.DeleteOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.InsertOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.OutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.UpdateInsertIntoOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.constants.query.QueryOutputType;
import java.lang.reflect.Type;

public class QueryOutputConfigDeSerializer
implements JsonDeserializer {
    private static final String TYPE = "type";
    private static final String OUTPUT = "output";
    private static final String TARGET = "target";

    public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonObject.get(TYPE);
        if (jsonPrimitive == null) {
            throw new JsonParseException("Unable to find type of the QueryOutputConfig");
        }
        String queryOutputType = jsonPrimitive.getAsString();
        if (jsonObject.get(TARGET) == null) {
            return null;
        }
        String target = jsonObject.get(TARGET).getAsString();
        if (queryOutputType.equalsIgnoreCase(QueryOutputType.INSERT.toString())) {
            return new QueryOutputConfig(queryOutputType, (OutputConfig)jsonDeserializationContext.deserialize(jsonObject.get(OUTPUT), InsertOutputConfig.class), target);
        }
        if (queryOutputType.equalsIgnoreCase(QueryOutputType.UPDATE.toString())) {
            return new QueryOutputConfig(queryOutputType, (OutputConfig)jsonDeserializationContext.deserialize(jsonObject.get(OUTPUT), UpdateInsertIntoOutputConfig.class), target);
        }
        if (queryOutputType.equalsIgnoreCase(QueryOutputType.UPDATE_OR_INSERT_INTO.toString())) {
            return new QueryOutputConfig(queryOutputType, (OutputConfig)jsonDeserializationContext.deserialize(jsonObject.get(OUTPUT), UpdateInsertIntoOutputConfig.class), target);
        }
        if (queryOutputType.equalsIgnoreCase(QueryOutputType.DELETE.toString())) {
            return new QueryOutputConfig(queryOutputType, (OutputConfig)jsonDeserializationContext.deserialize(jsonObject.get(OUTPUT), DeleteOutputConfig.class), target);
        }
        throw new JsonParseException("Unable to de-serialize the QueryOutputConfig JSON since its type is unknown");
    }
}

