/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.ElementCodeSegment;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.SiddhiElementConfig;
import io.siddhi.query.api.SiddhiElement;
import java.util.HashSet;
import java.util.Set;

public abstract class CodeSegmentsPreserver {
    private Set<ElementCodeSegment> preservedCodeSegments = new HashSet<ElementCodeSegment>();

    public Set<ElementCodeSegment> getPreservedCodeSegments() {
        return this.preservedCodeSegments;
    }

    public void preserveCodeSegment(SiddhiElement siddhiElement) {
        if (this.isCodeSegmentValid(siddhiElement)) {
            this.preservedCodeSegments.add(new ElementCodeSegment(siddhiElement.getQueryContextStartIndex(), siddhiElement.getQueryContextEndIndex()));
        }
    }

    protected void preserveAndBindCodeSegment(SiddhiElement bindFromElement, SiddhiElementConfig bindToElementConfig) {
        this.preserveCodeSegment(bindFromElement);
        this.bindCodeSegmentIndexes(bindFromElement, bindToElementConfig);
    }

    protected void bindCodeSegmentIndexes(SiddhiElement bindFromElement, SiddhiElementConfig bindToElementConfig) {
        if (this.isCodeSegmentValid(bindFromElement)) {
            bindToElementConfig.setQueryContextStartIndex(bindFromElement.getQueryContextStartIndex());
            bindToElementConfig.setQueryContextEndIndex(bindFromElement.getQueryContextEndIndex());
        }
    }

    protected void preserveCodeSegmentsOf(CodeSegmentsPreserver ... codeSegmentsPreservers) {
        for (CodeSegmentsPreserver codeSegmentsPreserver : codeSegmentsPreservers) {
            this.preservedCodeSegments.addAll(codeSegmentsPreserver.getPreservedCodeSegments());
        }
    }

    private boolean isCodeSegmentValid(SiddhiElement siddhiElement) {
        return siddhiElement != null && siddhiElement.getQueryContextStartIndex() != null && siddhiElement.getQueryContextEndIndex() != null;
    }
}

