/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.Edge;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.SiddhiAppConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.SiddhiElementConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.StreamConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.TableConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.TriggerConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.WindowConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.AggregationConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.QueryInputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.join.JoinConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.patternsequence.PatternSequenceConditionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.patternsequence.PatternSequenceConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.windowfilterprojection.WindowFilterProjectionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.SourceSinkConfig;
import io.siddhi.distribution.editor.core.util.designview.constants.NodeType;
import io.siddhi.distribution.editor.core.util.designview.constants.query.QueryInputType;
import io.siddhi.distribution.editor.core.util.designview.constants.query.QueryListType;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EdgesGenerator {
    private SiddhiAppConfig siddhiAppConfig;

    public EdgesGenerator(SiddhiAppConfig siddhiAppConfig) {
        this.siddhiAppConfig = siddhiAppConfig;
    }

    private static String generateEdgeId(String parentID, String childID) {
        return String.format("%s_%s", parentID, childID);
    }

    public Set<Edge> generateEdges() throws DesignGenerationException {
        HashSet<Edge> edges = new HashSet<Edge>();
        edges.addAll(this.generateSourceEdges(this.siddhiAppConfig.getSourceList()));
        edges.addAll(this.generateSinkEdges(this.siddhiAppConfig.getSinkList()));
        edges.addAll(this.generateWindowFilterProjectionQueryEdges(this.getCompleteQueryTypeList(QueryListType.WINDOW_FILTER_PROJECTION)));
        edges.addAll(this.generateJoinQueryEdges(this.getCompleteQueryTypeList(QueryListType.JOIN)));
        edges.addAll(this.generatePatternSequenceQueryEdges(this.getCompleteQueryTypeList(QueryListType.PATTERN)));
        edges.addAll(this.generatePatternSequenceQueryEdges(this.getCompleteQueryTypeList(QueryListType.SEQUENCE)));
        edges.addAll(this.generateAggregationEdges(this.siddhiAppConfig.getAggregationList()));
        edges.addAll(this.generatePartitionEdges(this.siddhiAppConfig.getPartitionList()));
        return edges;
    }

    private List<QueryConfig> getCompleteQueryTypeList(QueryListType queryListType) {
        ArrayList<QueryConfig> queryList = new ArrayList<QueryConfig>((Collection)this.siddhiAppConfig.getQueryLists().get((Object)queryListType));
        for (PartitionConfig partitionConfig : this.siddhiAppConfig.getPartitionList()) {
            queryList.addAll((Collection<QueryConfig>)partitionConfig.getQueryLists().get((Object)queryListType));
        }
        return queryList;
    }

    private Set<Edge> generateSourceEdges(List<SourceSinkConfig> sourceList) throws DesignGenerationException {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (SourceSinkConfig source : sourceList) {
            edges.add(this.generateEdge(source, this.getElementWithStreamName(source.getConnectedElementName(), null)));
        }
        return edges;
    }

    private Set<Edge> generateSinkEdges(List<SourceSinkConfig> sinkList) throws DesignGenerationException {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (SourceSinkConfig sink : sinkList) {
            List<SiddhiElementConfig> sourceElementList;
            if (sink.isCorrelationIdExist() && (sourceElementList = this.getElementWithSinkCorrelationId(sink.getCorrelationId())) != null && !sourceElementList.isEmpty()) {
                for (SiddhiElementConfig sourceElement : sourceElementList) {
                    edges.add(this.generateEdge(sink, sourceElement));
                }
            }
            edges.add(this.generateEdge(this.getElementWithStreamName(sink.getConnectedElementName(), null), sink));
        }
        return edges;
    }

    private Set<Edge> generateWindowFilterProjectionQueryEdges(List<QueryConfig> windowFilterProjectionQueryList) throws DesignGenerationException {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (QueryConfig query : windowFilterProjectionQueryList) {
            String inputStreamName = ((WindowFilterProjectionConfig)query.getQueryInput()).getFrom();
            if (query.getPartitionId() != null && query.getConnectorsAndStreams() != null && query.getConnectorsAndStreams().values().contains(((WindowFilterProjectionConfig)query.getQueryInput()).getFrom())) {
                edges.add(this.generateEdgeToPartitionConnector(this.getElementWithStreamName(inputStreamName, query.getPartitionId()), query.getConnectorIdByStreamName(inputStreamName)));
                edges.add(this.generateEdgeFromPartitionConnector(query.getConnectorIdByStreamName(inputStreamName), query));
            } else {
                edges.add(this.generateEdge(this.getElementWithStreamName(inputStreamName, query.getPartitionId()), query));
            }
            edges.add(this.generateEdge(query, this.getElementWithStreamName(query.getQueryOutput().getTarget(), query.getPartitionId())));
        }
        return edges;
    }

    private Set<Edge> generateJoinQueryEdges(List<QueryConfig> joinQueryList) throws DesignGenerationException {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (QueryConfig query : joinQueryList) {
            String leftInputStreamName = ((JoinConfig)query.getQueryInput()).getLeft().getFrom();
            if (query.getPartitionId() != null && query.getConnectorsAndStreams() != null && query.getConnectorsAndStreams().values().contains(leftInputStreamName)) {
                edges.add(this.generateEdgeToPartitionConnector(this.getElementWithStreamName(leftInputStreamName, query.getPartitionId()), query.getConnectorIdByStreamName(leftInputStreamName)));
                edges.add(this.generateEdgeFromPartitionConnector(query.getConnectorIdByStreamName(leftInputStreamName), query));
            } else {
                edges.add(this.generateEdge(this.getElementWithStreamName(leftInputStreamName, query.getPartitionId()), query));
            }
            String rightInputStream = ((JoinConfig)query.getQueryInput()).getRight().getFrom();
            if (query.getPartitionId() != null && query.getConnectorsAndStreams() != null && query.getConnectorsAndStreams().values().contains(rightInputStream)) {
                edges.add(this.generateEdgeToPartitionConnector(this.getElementWithStreamName(rightInputStream, query.getPartitionId()), query.getConnectorIdByStreamName(rightInputStream)));
                edges.add(this.generateEdgeFromPartitionConnector(query.getConnectorIdByStreamName(rightInputStream), query));
            } else {
                edges.add(this.generateEdge(this.getElementWithStreamName(rightInputStream, query.getPartitionId()), query));
            }
            edges.add(this.generateEdge(query, this.getElementWithStreamName(query.getQueryOutput().getTarget(), query.getPartitionId())));
        }
        return edges;
    }

    private Set<Edge> generatePatternSequenceQueryEdges(List<QueryConfig> patternSequenceQueryList) throws DesignGenerationException {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (QueryConfig query : patternSequenceQueryList) {
            ArrayList<String> inputStreamNames = new ArrayList<String>();
            for (PatternSequenceConditionConfig condition : ((PatternSequenceConfig)query.getQueryInput()).getConditionList()) {
                inputStreamNames.add(condition.getStreamName());
            }
            for (String inputStreamName : inputStreamNames) {
                if (query.getPartitionId() != null && query.getConnectorsAndStreams() != null && query.getConnectorsAndStreams().values().contains(inputStreamName)) {
                    edges.add(this.generateEdgeToPartitionConnector(this.getElementWithStreamName(inputStreamName, query.getPartitionId()), query.getConnectorIdByStreamName(inputStreamName)));
                    edges.add(this.generateEdgeFromPartitionConnector(query.getConnectorIdByStreamName(inputStreamName), query));
                    continue;
                }
                edges.add(this.generateEdge(this.getElementWithStreamName(inputStreamName, query.getPartitionId()), query));
            }
            edges.add(this.generateEdge(query, this.getElementWithStreamName(query.getQueryOutput().getTarget(), query.getPartitionId())));
        }
        return edges;
    }

    private Set<Edge> generateAggregationEdges(List<AggregationConfig> aggregationConfigList) throws DesignGenerationException {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (AggregationConfig aggregation : aggregationConfigList) {
            edges.add(this.generateEdge(this.getElementWithStreamName(aggregation.getFrom(), null), aggregation));
        }
        return edges;
    }

    private Set<Edge> generatePartitionEdges(List<PartitionConfig> partitionConfigList) throws DesignGenerationException {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (PartitionConfig partitionConfig : partitionConfigList) {
            for (Map.Entry<String, String> connectorsAndStreamsEntry : partitionConfig.getConnectorsAndStreams().entrySet()) {
                edges.add(this.generateEdgeToPartitionConnector(this.getElementWithStreamName(connectorsAndStreamsEntry.getValue(), null), connectorsAndStreamsEntry.getKey()));
            }
        }
        return edges;
    }

    private Edge generateEdgeToPartitionConnector(SiddhiElementConfig parentElement, String partitionConnectorId) throws DesignGenerationException {
        return new Edge(EdgesGenerator.generateEdgeId(parentElement.getId(), partitionConnectorId), parentElement.getId(), this.getSiddhiElementType(parentElement), partitionConnectorId, NodeType.PARTITION);
    }

    private Edge generateEdgeFromPartitionConnector(String partitionConnectorId, SiddhiElementConfig childElement) throws DesignGenerationException {
        return new Edge(EdgesGenerator.generateEdgeId(partitionConnectorId, childElement.getId()), partitionConnectorId, NodeType.PARTITION, childElement.getId(), this.getSiddhiElementType(childElement));
    }

    private Edge generateEdge(Object parentElementOrId, Object childElementOrId) throws DesignGenerationException {
        SiddhiElementConfig parentElement = this.getOrAcceptSiddhiElement(parentElementOrId);
        SiddhiElementConfig childElement = this.getOrAcceptSiddhiElement(childElementOrId);
        return this.generateEdgeForElements(parentElement, childElement);
    }

    private SiddhiElementConfig getOrAcceptSiddhiElement(Object elementOrId) throws DesignGenerationException {
        if (elementOrId instanceof SiddhiElementConfig) {
            return (SiddhiElementConfig)elementOrId;
        }
        if (elementOrId instanceof String) {
            return this.getElementWithId((String)elementOrId);
        }
        throw new DesignGenerationException("SiddhiElement ID or SiddhiElement object is expected, to find the element or accept the given one");
    }

    private Edge generateEdgeForElements(SiddhiElementConfig parentElement, SiddhiElementConfig childElement) throws DesignGenerationException {
        NodeType parentType = this.getSiddhiElementType(parentElement);
        NodeType childType = this.getSiddhiElementType(childElement);
        String edgeId = EdgesGenerator.generateEdgeId(parentElement.getId(), childElement.getId());
        return new Edge(edgeId, parentElement.getId(), parentType, childElement.getId(), childType);
    }

    private SiddhiElementConfig getElementWithStreamName(String streamName, String scopedPartitionId) throws DesignGenerationException {
        for (StreamConfig streamConfig : this.siddhiAppConfig.getStreamList()) {
            if (!streamConfig.getName().equals(streamName)) continue;
            return streamConfig;
        }
        for (TableConfig tableConfig : this.siddhiAppConfig.getTableList()) {
            if (!tableConfig.getName().equals(streamName)) continue;
            return tableConfig;
        }
        for (TriggerConfig triggerConfig : this.siddhiAppConfig.getTriggerList()) {
            if (!triggerConfig.getName().equals(streamName)) continue;
            return triggerConfig;
        }
        for (WindowConfig windowConfig : this.siddhiAppConfig.getWindowList()) {
            if (!windowConfig.getName().equals(streamName)) continue;
            return windowConfig;
        }
        for (AggregationConfig aggregationConfig : this.siddhiAppConfig.getAggregationList()) {
            if (!aggregationConfig.getName().equals(streamName)) continue;
            return aggregationConfig;
        }
        if (scopedPartitionId != null) {
            for (PartitionConfig partitionConfig : this.siddhiAppConfig.getPartitionList()) {
                if (!partitionConfig.getId().equals(scopedPartitionId)) continue;
                for (StreamConfig streamConfig : partitionConfig.getStreamList()) {
                    if (!streamConfig.getName().equals(streamName)) continue;
                    return streamConfig;
                }
            }
        }
        throw new DesignGenerationException("Unable to find an element with related stream name '" + streamName + "'");
    }

    private SiddhiElementConfig getElementWithId(String id) throws DesignGenerationException {
        for (QueryListType queryListType : this.siddhiAppConfig.getQueryLists().keySet()) {
            for (SiddhiElementConfig siddhiElementConfig : this.siddhiAppConfig.getQueryLists().get((Object)queryListType)) {
                if (!siddhiElementConfig.getId().equals(id)) continue;
                return siddhiElementConfig;
            }
        }
        ArrayList<SiddhiElementConfig> siddhiElementLists = new ArrayList<SiddhiElementConfig>();
        siddhiElementLists.addAll(this.siddhiAppConfig.getSinkList());
        siddhiElementLists.addAll(this.siddhiAppConfig.getSourceList());
        siddhiElementLists.addAll(this.siddhiAppConfig.getStreamList());
        siddhiElementLists.addAll(this.siddhiAppConfig.getTableList());
        siddhiElementLists.addAll(this.siddhiAppConfig.getTriggerList());
        siddhiElementLists.addAll(this.siddhiAppConfig.getWindowList());
        siddhiElementLists.addAll(this.siddhiAppConfig.getAggregationList());
        for (Map.Entry<QueryListType, List<QueryConfig>> queryList : this.siddhiAppConfig.getQueryLists().entrySet()) {
            siddhiElementLists.addAll((Collection)queryList.getValue());
        }
        siddhiElementLists.addAll(this.siddhiAppConfig.getPartitionList());
        for (PartitionConfig partitionConfig : this.siddhiAppConfig.getPartitionList()) {
            siddhiElementLists.addAll(partitionConfig.getStreamList());
            for (Map.Entry<QueryListType, List<QueryConfig>> queryList : partitionConfig.getQueryLists().entrySet()) {
                siddhiElementLists.addAll((Collection)queryList.getValue());
            }
        }
        for (SiddhiElementConfig siddhiElementConfig : siddhiElementLists) {
            if (!siddhiElementConfig.getId().equals(id)) continue;
            return siddhiElementConfig;
        }
        throw new DesignGenerationException("Unable to find element with id '" + id + "'");
    }

    private NodeType getSiddhiElementType(SiddhiElementConfig siddhiElementConfig) throws DesignGenerationException {
        if (siddhiElementConfig instanceof StreamConfig) {
            return NodeType.STREAM;
        }
        if (siddhiElementConfig instanceof TableConfig) {
            return NodeType.TABLE;
        }
        if (siddhiElementConfig instanceof WindowConfig) {
            return NodeType.WINDOW;
        }
        if (siddhiElementConfig instanceof SourceSinkConfig) {
            String annotationType = ((SourceSinkConfig)siddhiElementConfig).getAnnotationType().toUpperCase();
            return NodeType.valueOf(annotationType);
        }
        if (siddhiElementConfig instanceof AggregationConfig) {
            return NodeType.AGGREGATION;
        }
        if (siddhiElementConfig instanceof TriggerConfig) {
            return NodeType.TRIGGER;
        }
        if (siddhiElementConfig instanceof QueryConfig) {
            QueryInputConfig queryInputConfig = ((QueryConfig)siddhiElementConfig).getQueryInput();
            if (queryInputConfig instanceof WindowFilterProjectionConfig) {
                return NodeType.WINDOW_FILTER_PROJECTION_QUERY;
            }
            if (queryInputConfig instanceof JoinConfig) {
                return NodeType.JOIN_QUERY;
            }
            if (queryInputConfig instanceof PatternSequenceConfig) {
                if (queryInputConfig.getType().equalsIgnoreCase(QueryInputType.PATTERN.toString())) {
                    return NodeType.PATTERN_QUERY;
                }
                return NodeType.SEQUENCE_QUERY;
            }
        }
        throw new DesignGenerationException("Type is unknown for Siddhi Element with id '" + siddhiElementConfig.getId() + "'");
    }

    private List<SiddhiElementConfig> getElementWithSinkCorrelationId(String correlateId) {
        ArrayList<SiddhiElementConfig> siddhiElementConfigList = new ArrayList<SiddhiElementConfig>();
        for (SourceSinkConfig sourceConfig : this.siddhiAppConfig.getSourceList()) {
            if (sourceConfig.getCorrelationId() == null || !sourceConfig.getCorrelationId().equals(correlateId)) continue;
            siddhiElementConfigList.add(sourceConfig);
        }
        return siddhiElementConfigList;
    }
}

