/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators;

import io.siddhi.core.stream.input.source.Source;
import io.siddhi.core.stream.output.sink.Sink;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.SourceSinkConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.mapper.MapperConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.mapper.attribute.MapperListPayloadOrAttribute;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.mapper.attribute.MapperMapPayloadOrAttribute;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.mapper.attribute.MapperPayloadOrAttribute;
import io.siddhi.distribution.editor.core.util.designview.constants.MapperPayloadOrAttributeType;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.AnnotationConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.CodeSegmentsPreserver;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.annotation.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SourceSinkConfigsGenerator
extends CodeSegmentsPreserver {
    private static final String TYPE = "TYPE";
    private static final String SINK_ID = "SINK.ID";
    private static final String MAP = "MAP";

    public List<SourceSinkConfig> generateSourceConfigs(List<Source> sourceList) throws DesignGenerationException {
        return this.generateSourceOrSinkConfigs(SourceOrSinkAnnotation.SOURCE, sourceList);
    }

    public List<SourceSinkConfig> generateSinkConfigs(List<Sink> sinkList) throws DesignGenerationException {
        return this.generateSourceOrSinkConfigs(SourceOrSinkAnnotation.SINK, sinkList);
    }

    private <T> List<SourceSinkConfig> generateSourceOrSinkConfigs(SourceOrSinkAnnotation sourceOrSinkAnnotation, List<T> sourceOrSinkList) throws DesignGenerationException {
        Map<Annotation, String> connectedElementsMap = this.getSourceOrSinkAnnotationStreamIdMap(sourceOrSinkAnnotation, sourceOrSinkList);
        ArrayList<SourceSinkConfig> sourceOrSinkConfigs = new ArrayList<SourceSinkConfig>();
        for (Map.Entry<Annotation, String> connectedElement : connectedElementsMap.entrySet()) {
            sourceOrSinkConfigs.add(this.generateSourceOrSinkConfig(sourceOrSinkAnnotation, connectedElement));
        }
        return sourceOrSinkConfigs;
    }

    private SourceSinkConfig generateSourceOrSinkConfig(SourceOrSinkAnnotation annotationType, Map.Entry<Annotation, String> sourceOrSinkAndConnectedElement) throws DesignGenerationException {
        String connectedElementName = sourceOrSinkAndConnectedElement.getValue();
        String type = null;
        String correlationId = null;
        ArrayList<String> options = new ArrayList<String>();
        for (Element element : sourceOrSinkAndConnectedElement.getKey().getElements()) {
            if (element.getKey().equalsIgnoreCase(TYPE)) {
                type = element.getValue();
            } else {
                options.add(element.toString());
            }
            if (!element.getKey().equalsIgnoreCase(SINK_ID)) continue;
            correlationId = element.getValue();
        }
        if (type == null) {
            throw new DesignGenerationException("Unable to find the 'type' of the " + annotationType.toString().toLowerCase());
        }
        MapperConfig map = null;
        AnnotationConfigGenerator annotationConfigGenerator = new AnnotationConfigGenerator();
        for (Annotation sourceOrSinkAnnotation : sourceOrSinkAndConnectedElement.getKey().getAnnotations()) {
            if (MAP.equalsIgnoreCase(sourceOrSinkAnnotation.getName())) {
                map = this.generateMapperConfig(sourceOrSinkAnnotation);
                continue;
            }
            options.add(annotationConfigGenerator.generateAnnotationConfig(sourceOrSinkAnnotation));
        }
        boolean isCorrelationIdExist = correlationId != null;
        SourceSinkConfig sourceSinkConfig = new SourceSinkConfig(annotationType.toString(), connectedElementName, type, options, map, isCorrelationIdExist, correlationId);
        this.preserveCodeSegmentsOf(annotationConfigGenerator);
        this.preserveAndBindCodeSegment((SiddhiElement)sourceOrSinkAndConnectedElement.getKey(), sourceSinkConfig);
        return sourceSinkConfig;
    }

    private MapperConfig generateMapperConfig(Annotation mapAnnotation) throws DesignGenerationException {
        String type = null;
        ArrayList<String> options = new ArrayList<String>();
        for (Element element : mapAnnotation.getElements()) {
            if (element.getKey().equalsIgnoreCase(TYPE)) {
                type = element.getValue();
                continue;
            }
            options.add(element.toString());
        }
        if (type == null) {
            throw new DesignGenerationException("Unable to find 'type' of the mapper");
        }
        MapperPayloadOrAttribute payloadOrAttribute = null;
        if (!mapAnnotation.getAnnotations().isEmpty()) {
            payloadOrAttribute = this.generateMapperPayloadOrAttributes((Annotation)mapAnnotation.getAnnotations().get(0));
        }
        MapperConfig mapperConfig = new MapperConfig(type, options, payloadOrAttribute);
        this.preserveAndBindCodeSegment((SiddhiElement)mapAnnotation, mapperConfig);
        return mapperConfig;
    }

    private MapperPayloadOrAttribute generateMapperPayloadOrAttributes(Annotation attributesOrPayloadAnnotation) {
        ArrayList<PayloadOrAttributeElement> elements = new ArrayList<PayloadOrAttributeElement>();
        for (Element element : attributesOrPayloadAnnotation.getElements()) {
            elements.add(this.generatePayloadOrAttributesElement(element));
        }
        MapperPayloadOrAttributeType mapperPayloadOrAttributesType = this.getMapperAttributeOrPayloadType(elements);
        if (mapperPayloadOrAttributesType == MapperPayloadOrAttributeType.MAP) {
            return this.generateMapperMapAttribute(attributesOrPayloadAnnotation.getName(), elements);
        }
        return this.generateMapperListAttribute(attributesOrPayloadAnnotation.getName(), elements);
    }

    private PayloadOrAttributeElement generatePayloadOrAttributesElement(Element element) {
        PayloadOrAttributeElement payloadOrAttributeElement = new PayloadOrAttributeElement();
        payloadOrAttributeElement.key = element.getKey();
        payloadOrAttributeElement.value = element.getValue();
        return payloadOrAttributeElement;
    }

    private MapperPayloadOrAttributeType getMapperAttributeOrPayloadType(List<PayloadOrAttributeElement> elements) {
        for (PayloadOrAttributeElement element : elements) {
            if (element.key == null) continue;
            return MapperPayloadOrAttributeType.MAP;
        }
        return MapperPayloadOrAttributeType.LIST;
    }

    private MapperListPayloadOrAttribute generateMapperListAttribute(String annotationType, List<PayloadOrAttributeElement> elements) {
        ArrayList<String> values = new ArrayList<String>();
        for (PayloadOrAttributeElement element : elements) {
            values.add(element.value);
        }
        return new MapperListPayloadOrAttribute(annotationType.toUpperCase(), values);
    }

    private MapperMapPayloadOrAttribute generateMapperMapAttribute(String annotationType, List<PayloadOrAttributeElement> elements) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (PayloadOrAttributeElement element : elements) {
            values.put(element.key, element.value);
        }
        return new MapperMapPayloadOrAttribute(annotationType.toUpperCase(), values);
    }

    private <T> Map<Annotation, String> getSourceOrSinkAnnotationStreamIdMap(SourceOrSinkAnnotation sourceOrSinkAnnotation, List<T> sourceOrSinkList) throws DesignGenerationException {
        HashMap<Annotation, String> connectedElements = new HashMap<Annotation, String>();
        for (T sourceOrSink : sourceOrSinkList) {
            List streamDefinitionAnnotations = null;
            String streamId = null;
            if (sourceOrSink instanceof Source) {
                streamId = ((Source)sourceOrSink).getStreamDefinition().getId();
                streamDefinitionAnnotations = ((Source)sourceOrSink).getStreamDefinition().getAnnotations();
            } else if (sourceOrSink instanceof Sink) {
                streamId = ((Sink)sourceOrSink).getStreamDefinition().getId();
                streamDefinitionAnnotations = ((Sink)sourceOrSink).getStreamDefinition().getAnnotations();
            }
            if (streamDefinitionAnnotations == null) {
                throw new DesignGenerationException("Unable to find annotations for the stream definition");
            }
            if (streamId == null) {
                throw new DesignGenerationException("Unable to find the name for the stream definition");
            }
            for (Annotation streamDefinitionAnnotation : streamDefinitionAnnotations) {
                if (!streamDefinitionAnnotation.getName().equalsIgnoreCase(sourceOrSinkAnnotation.toString())) continue;
                connectedElements.put(streamDefinitionAnnotation, streamId);
            }
        }
        return connectedElements;
    }

    private static class PayloadOrAttributeElement {
        private String key;
        private String value;

        private PayloadOrAttributeElement() {
        }
    }

    private static enum SourceOrSinkAnnotation {
        SOURCE,
        SINK;

    }
}

