/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.QueryInputConfig;
import io.siddhi.distribution.editor.core.util.designview.constants.query.QueryInputType;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.JoinConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.PatternSequenceConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.WindowFilterProjectionConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.query.api.SiddhiApp;
import io.siddhi.query.api.execution.query.input.stream.InputStream;
import io.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import io.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import io.siddhi.query.api.execution.query.input.stream.StateInputStream;

public class QueryInputConfigGenerator {
    private String siddhiAppString;
    private SiddhiApp siddhiApp;

    public QueryInputConfigGenerator(String siddhiAppString, SiddhiApp siddhiApp) {
        this.siddhiAppString = siddhiAppString;
        this.siddhiApp = siddhiApp;
    }

    public QueryInputConfig generateQueryInputConfig(InputStream queryInputStream) throws DesignGenerationException {
        QueryInputType queryInputType = this.getQueryInputType(queryInputStream);
        if (queryInputType == QueryInputType.WINDOW_FILTER_PROJECTION) {
            return new WindowFilterProjectionConfigGenerator(this.siddhiAppString).generateWindowFilterProjectionConfig(queryInputStream);
        }
        if (queryInputType == QueryInputType.JOIN) {
            return new JoinConfigGenerator().getJoinQueryConfig(queryInputStream, this.siddhiApp, this.siddhiAppString);
        }
        if (queryInputType == QueryInputType.PATTERN || queryInputType == QueryInputType.SEQUENCE) {
            return new PatternSequenceConfigGenerator(this.siddhiAppString, queryInputType).generatePatternSequenceConfig(queryInputStream);
        }
        throw new DesignGenerationException("Unable to generate QueryInputConfig for type: " + (Object)((Object)queryInputType));
    }

    private QueryInputType getQueryInputType(InputStream queryInputStream) {
        if (queryInputStream instanceof SingleInputStream) {
            return QueryInputType.WINDOW_FILTER_PROJECTION;
        }
        if (queryInputStream instanceof JoinInputStream) {
            return QueryInputType.JOIN;
        }
        if (queryInputStream instanceof StateInputStream) {
            return QueryInputType.valueOf(((StateInputStream)queryInputStream).getStateType().name());
        }
        throw new IllegalArgumentException("Type of query is unknown for generating query input");
    }
}

