/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.patternsequence.PatternSequenceConditionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.patternsequence.PatternSequenceConfig;
import io.siddhi.distribution.editor.core.util.designview.constants.query.QueryInputType;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.AbsentStreamStateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.CountStateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.EveryStateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.LogicalStateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.NextStateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.PatternSequenceConfigTreeInfo;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.PatternSequenceConfigTreeInfoGenerator;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.StateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.StreamStateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.query.api.execution.query.input.stream.InputStream;
import io.siddhi.query.api.execution.query.input.stream.StateInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PatternSequenceConfigGenerator {
    private static final String PATTERN_DELIMITER = " -> ";
    private static final String SEQUENCE_DELIMITER = " , ";
    private static final String WHITE_SPACE = " ";
    private static final String COUNT_MIN = "<";
    private static final String COUNT_MAX = ">";
    private static final String COUNT_MIN_MAX_SEPARATOR = ":";
    private static final String WITHIN = "within";
    private static final String EVERY = "every";
    private static final String NOT = "not";
    private static final String FOR = "for";
    private static final String ONE_OR_MORE_POSTFIX_SYMBOL = "+";
    private static final String ZERO_OR_MORE_POSTFIX_SYMBOL = "*";
    private static final String ZERO_OR_ONE_POSTFIX_SYMBOL = "?";
    private String siddhiAppString;
    private QueryInputType mode;
    private List<PatternSequenceConditionConfig> conditionList = new ArrayList<PatternSequenceConditionConfig>();
    private List<String> logicComponentList = new ArrayList<String>();
    private List<String> availableEventReferences = new ArrayList<String>();
    private int eventReferenceCounter = 0;

    public PatternSequenceConfigGenerator(String siddhiAppString, QueryInputType mode) {
        this.siddhiAppString = siddhiAppString;
        this.mode = mode;
    }

    private static String getDelimiter(QueryInputType mode) throws DesignGenerationException {
        if (mode == QueryInputType.PATTERN) {
            return PATTERN_DELIMITER;
        }
        if (mode == QueryInputType.SEQUENCE) {
            return SEQUENCE_DELIMITER;
        }
        throw new DesignGenerationException("Invalid QueryInputType for generating PatternSequenceConfig");
    }

    private static String buildMinMax(int min, int max, QueryInputType mode) {
        String acceptedMin = String.valueOf(min);
        String acceptedMax = String.valueOf(max);
        if (mode == QueryInputType.PATTERN) {
            if (min == -1) {
                acceptedMin = "";
            }
            if (max == -1) {
                acceptedMax = "";
            }
        } else if (mode == QueryInputType.SEQUENCE) {
            if (min == 1 && max == -1) {
                return ONE_OR_MORE_POSTFIX_SYMBOL;
            }
            if (min == 0 && max == -1) {
                return ZERO_OR_MORE_POSTFIX_SYMBOL;
            }
            if (min == 0 && max == 1) {
                return ZERO_OR_ONE_POSTFIX_SYMBOL;
            }
        }
        if (acceptedMin.equals(acceptedMax)) {
            return COUNT_MIN + acceptedMax + COUNT_MAX;
        }
        return COUNT_MIN + acceptedMin + COUNT_MIN_MAX_SEPARATOR + acceptedMax + COUNT_MAX;
    }

    private static String buildWithin(String nullableWithin) {
        if (nullableWithin == null) {
            return "";
        }
        return " within " + nullableWithin;
    }

    public PatternSequenceConfig generatePatternSequenceConfig(InputStream inputStream) throws DesignGenerationException {
        String delimiter = PatternSequenceConfigGenerator.getDelimiter(this.mode);
        PatternSequenceConfigTreeInfo patternSequenceConfigTreeInfo = new PatternSequenceConfigTreeInfoGenerator(this.siddhiAppString).generatePatternSequenceConfigTreeInfo(((StateInputStream)inputStream).getStateElement());
        StateElementConfig patternSequenceConfigTree = patternSequenceConfigTreeInfo.getPatternSequenceConfigTree();
        this.availableEventReferences = patternSequenceConfigTreeInfo.getAvailableEventReferences();
        this.traverseInOrder(patternSequenceConfigTree);
        return new PatternSequenceConfig(this.mode.toString(), this.conditionList, String.join((CharSequence)delimiter, this.logicComponentList));
    }

    private void traverseInOrder(StateElementConfig currentElement) throws DesignGenerationException {
        if (currentElement instanceof NextStateElementConfig) {
            this.traverseInOrder(((NextStateElementConfig)currentElement).getStateElement());
            this.traverseInOrder(((NextStateElementConfig)currentElement).getNextStateElement());
        } else {
            this.addElementComponent(currentElement);
        }
    }

    private PatternSequenceConditionConfig generateConditionConfig(StateElementConfig element) throws DesignGenerationException {
        PatternSequenceConditionConfig conditionConfig = new PatternSequenceConditionConfig();
        if (element instanceof AbsentStreamStateElementConfig) {
            conditionConfig.setConditionId(this.acceptOrGenerateNextStreamReference(((AbsentStreamStateElementConfig)element).getStreamReference()));
            conditionConfig.setStreamName(((AbsentStreamStateElementConfig)element).getStreamName());
            conditionConfig.setStreamHandlerList(((AbsentStreamStateElementConfig)element).getStreamHandlerList());
            return conditionConfig;
        }
        if (element instanceof CountStateElementConfig) {
            conditionConfig.setConditionId(this.acceptOrGenerateNextStreamReference(((CountStateElementConfig)element).getStreamStateElement().getStreamReference()));
            conditionConfig.setStreamName(((CountStateElementConfig)element).getStreamStateElement().getStreamName());
            conditionConfig.setStreamHandlerList(((CountStateElementConfig)element).getStreamStateElement().getStreamHandlerList());
            return conditionConfig;
        }
        if (element instanceof EveryStateElementConfig) {
            conditionConfig.setConditionId(this.acceptOrGenerateNextStreamReference(this.generateConditionConfig(((EveryStateElementConfig)element).getStateElement()).getConditionId()));
            conditionConfig.setStreamName(this.generateConditionConfig(((EveryStateElementConfig)element).getStateElement()).getStreamName());
            conditionConfig.setStreamHandlerList(this.generateConditionConfig(((EveryStateElementConfig)element).getStateElement()).getStreamHandlerList());
            return conditionConfig;
        }
        if (element instanceof StreamStateElementConfig) {
            conditionConfig.setConditionId(this.acceptOrGenerateNextStreamReference(((StreamStateElementConfig)element).getStreamReference()));
            conditionConfig.setStreamName(((StreamStateElementConfig)element).getStreamName());
            conditionConfig.setStreamHandlerList(((StreamStateElementConfig)element).getStreamHandlerList());
            return conditionConfig;
        }
        throw new DesignGenerationException("Unable to generate condition config for element of type unknown");
    }

    private String acceptOrGenerateNextStreamReference(String nullableStreamReference) {
        if (nullableStreamReference != null) {
            return nullableStreamReference;
        }
        return this.generateNextUnavailableStreamReference();
    }

    private String generateNextUnavailableStreamReference() {
        String eventReference;
        while (this.availableEventReferences.contains(eventReference = this.generateNextStreamReference())) {
        }
        this.availableEventReferences.add(eventReference);
        return eventReference;
    }

    private String generateNextStreamReference() {
        return "e" + ++this.eventReferenceCounter;
    }

    private void addElementComponent(StateElementConfig element) throws DesignGenerationException {
        ElementComponent elementComponent = this.generateElementComponent(element);
        this.conditionList.addAll(elementComponent.conditions);
        this.logicComponentList.addAll(elementComponent.logicComponents);
    }

    private ElementComponent generateElementComponent(StateElementConfig element) throws DesignGenerationException {
        if (element instanceof CountStateElementConfig) {
            return this.generateCountStateElementComponent((CountStateElementConfig)element);
        }
        if (element instanceof EveryStateElementConfig) {
            return this.generateEveryStateElementComponent((EveryStateElementConfig)element);
        }
        if (element instanceof LogicalStateElementConfig) {
            return this.generateLogicalStateElementComponent((LogicalStateElementConfig)element);
        }
        if (element instanceof StreamStateElementConfig) {
            return this.generateStreamStateElementComponent((StreamStateElementConfig)element);
        }
        if (element instanceof NextStateElementConfig) {
            return this.generateNextStateElementComponent((NextStateElementConfig)element);
        }
        throw new IllegalArgumentException("Failed to generate config for Pattern/Sequence element, since type is unknown");
    }

    private ElementComponent generateCountStateElementComponent(CountStateElementConfig element) throws DesignGenerationException {
        PatternSequenceConditionConfig conditionConfig = this.generateConditionConfig(element);
        ArrayList<PatternSequenceConditionConfig> conditions = new ArrayList<PatternSequenceConditionConfig>();
        conditions.add(conditionConfig);
        String logicComponent = conditionConfig.getConditionId() + PatternSequenceConfigGenerator.buildMinMax(element.getMin(), element.getMax(), this.mode) + PatternSequenceConfigGenerator.buildWithin(element.getWithin());
        return new ElementComponent(conditions, new ArrayList<String>(Arrays.asList(logicComponent)));
    }

    private ElementComponent generateEveryStateElementComponent(EveryStateElementConfig element) throws DesignGenerationException {
        ElementComponent containedElement = this.generateElementComponent(element.getStateElement());
        ArrayList<PatternSequenceConditionConfig> conditions = new ArrayList<PatternSequenceConditionConfig>(containedElement.conditions);
        String logicComponent = "every " + containedElement.getLogicComponentsString(this.mode) + PatternSequenceConfigGenerator.buildWithin(element.getWithin());
        return new ElementComponent(conditions, new ArrayList<String>(Arrays.asList(logicComponent)));
    }

    private ElementComponent generateNextStateElementComponent(NextStateElementConfig element) throws DesignGenerationException {
        ElementComponent stateElement = this.generateElementComponent(element.getStateElement());
        ElementComponent nextStateElement = this.generateElementComponent(element.getNextStateElement());
        ArrayList<PatternSequenceConditionConfig> conditions = new ArrayList<PatternSequenceConditionConfig>(stateElement.conditions);
        conditions.addAll(nextStateElement.conditions);
        ArrayList<String> logicComponents = new ArrayList<String>(stateElement.logicComponents);
        logicComponents.addAll(nextStateElement.logicComponents);
        return new ElementComponent(conditions, logicComponents);
    }

    private ElementComponent generateLogicalStateElementComponent(LogicalStateElementConfig element) throws DesignGenerationException {
        ElementComponent condition1Component = this.generateStreamStateElementComponent(element.getStreamStateElement1());
        ElementComponent condition2Component = this.generateStreamStateElementComponent(element.getStreamStateElement2());
        String logicComponent = condition1Component.getLogicComponentsString(this.mode) + WHITE_SPACE + element.getType().toLowerCase() + WHITE_SPACE + condition2Component.getLogicComponentsString(this.mode) + PatternSequenceConfigGenerator.buildWithin(element.getWithin());
        ArrayList<PatternSequenceConditionConfig> conditions = new ArrayList<PatternSequenceConditionConfig>();
        conditions.addAll(condition1Component.conditions);
        conditions.addAll(condition2Component.conditions);
        return new ElementComponent(conditions, new ArrayList<String>(Arrays.asList(logicComponent)));
    }

    private ElementComponent generateStreamStateElementComponent(StreamStateElementConfig element) throws DesignGenerationException {
        PatternSequenceConditionConfig conditionConfig = this.generateConditionConfig(element);
        StringBuilder logicComponent = new StringBuilder();
        if (element instanceof AbsentStreamStateElementConfig) {
            logicComponent.append(NOT);
            logicComponent.append(WHITE_SPACE);
        }
        logicComponent.append(conditionConfig.getConditionId());
        if (element instanceof AbsentStreamStateElementConfig && ((AbsentStreamStateElementConfig)element).getWaitingTime() != null) {
            logicComponent.append(WHITE_SPACE);
            logicComponent.append(FOR);
            logicComponent.append(WHITE_SPACE);
            logicComponent.append(((AbsentStreamStateElementConfig)element).getWaitingTime());
        }
        logicComponent.append(PatternSequenceConfigGenerator.buildWithin(element.getWithin()));
        ArrayList<PatternSequenceConditionConfig> conditions = new ArrayList<PatternSequenceConditionConfig>();
        conditions.add(conditionConfig);
        return new ElementComponent(conditions, new ArrayList<String>(Arrays.asList(logicComponent.toString())));
    }

    private static class ElementComponent {
        List<PatternSequenceConditionConfig> conditions;
        List<String> logicComponents;

        private ElementComponent(List<PatternSequenceConditionConfig> conditions, List<String> logicComponents) {
            this.conditions = conditions;
            this.logicComponents = logicComponents;
        }

        private String getLogicComponentsString(QueryInputType mode) throws DesignGenerationException {
            return String.join((CharSequence)PatternSequenceConfigGenerator.getDelimiter(mode), this.logicComponents);
        }
    }
}

