/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters;

import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.AbsentStreamStateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.CountStateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.EveryStateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.LogicalStateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.NextStateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.PatternSequenceConfigTreeInfo;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.StateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.input.types.patternsequencesupporters.StreamStateElementConfig;
import io.siddhi.distribution.editor.core.util.designview.designgenerator.generators.query.streamhandler.StreamHandlerConfigGenerator;
import io.siddhi.distribution.editor.core.util.designview.exceptions.DesignGenerationException;
import io.siddhi.distribution.editor.core.util.designview.utilities.ConfigBuildingUtilities;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.execution.query.input.state.AbsentStreamStateElement;
import io.siddhi.query.api.execution.query.input.state.CountStateElement;
import io.siddhi.query.api.execution.query.input.state.EveryStateElement;
import io.siddhi.query.api.execution.query.input.state.LogicalStateElement;
import io.siddhi.query.api.execution.query.input.state.NextStateElement;
import io.siddhi.query.api.execution.query.input.state.StateElement;
import io.siddhi.query.api.execution.query.input.state.StreamStateElement;
import io.siddhi.query.api.execution.query.input.stream.BasicSingleInputStream;
import java.util.ArrayList;
import java.util.List;

public class PatternSequenceConfigTreeInfoGenerator {
    private String siddhiAppString;
    private List<String> availableEventReferences = new ArrayList<String>();

    public PatternSequenceConfigTreeInfoGenerator(String siddhiAppString) {
        this.siddhiAppString = siddhiAppString;
    }

    public PatternSequenceConfigTreeInfo generatePatternSequenceConfigTreeInfo(StateElement stateElement) throws DesignGenerationException {
        StateElementConfig patternSequenceConfigTree = this.generateStateElementConfigTree(stateElement);
        return new PatternSequenceConfigTreeInfo(patternSequenceConfigTree, this.availableEventReferences);
    }

    private void addToAvailableStreamReferences(String streamReference) {
        if (streamReference != null) {
            this.availableEventReferences.add(streamReference);
        }
    }

    private StateElementConfig generateStateElementConfigTree(StateElement stateElement) throws DesignGenerationException {
        if (stateElement instanceof StreamStateElement) {
            return this.generateStreamStateElementConfig((StreamStateElement)stateElement);
        }
        if (stateElement instanceof CountStateElement) {
            return this.generateCountStateElementConfig((CountStateElement)stateElement);
        }
        if (stateElement instanceof LogicalStateElement) {
            return this.generateLogicalStateElementConfig((LogicalStateElement)stateElement);
        }
        if (stateElement instanceof EveryStateElement) {
            return this.generateEveryStateElementConfig((EveryStateElement)stateElement);
        }
        if (stateElement instanceof NextStateElement) {
            return this.generateNextStateElementConfig((NextStateElement)stateElement);
        }
        throw new DesignGenerationException("Unknown type of StateElement");
    }

    private String generateNullableElementDefinition(SiddhiElement siddhiElement) throws DesignGenerationException {
        if (siddhiElement == null) {
            return null;
        }
        return ConfigBuildingUtilities.getDefinition(siddhiElement, this.siddhiAppString);
    }

    private StreamStateElementConfig generateStreamStateElementConfig(StreamStateElement streamStateElement) throws DesignGenerationException {
        if (streamStateElement instanceof AbsentStreamStateElement) {
            return this.generateAbsentStreamStateElementConfig((AbsentStreamStateElement)streamStateElement);
        }
        BasicSingleInputStream basicSingleInputStream = streamStateElement.getBasicSingleInputStream();
        StreamStateElementConfig streamStateElementConfig = new StreamStateElementConfig();
        streamStateElementConfig.setStreamReference(streamStateElement.getBasicSingleInputStream().getStreamReferenceId());
        streamStateElementConfig.setStreamName(basicSingleInputStream.getStreamId());
        streamStateElementConfig.setStreamHandlerList(new StreamHandlerConfigGenerator(this.siddhiAppString).generateStreamHandlerConfigList(basicSingleInputStream.getStreamHandlers()));
        this.addToAvailableStreamReferences(streamStateElement.getBasicSingleInputStream().getStreamReferenceId());
        return streamStateElementConfig;
    }

    private CountStateElementConfig generateCountStateElementConfig(CountStateElement countStateElement) throws DesignGenerationException {
        CountStateElementConfig countStateElementConfig = new CountStateElementConfig();
        countStateElementConfig.setStreamStateElement(this.generateStreamStateElementConfig(countStateElement.getStreamStateElement()));
        countStateElementConfig.setMin(countStateElement.getMinCount());
        countStateElementConfig.setMax(countStateElement.getMaxCount());
        return countStateElementConfig;
    }

    private LogicalStateElementConfig generateLogicalStateElementConfig(LogicalStateElement logicalStateElement) throws DesignGenerationException {
        LogicalStateElementConfig logicalStateElementConfig = new LogicalStateElementConfig();
        logicalStateElementConfig.setStreamStateElement1(this.generateStreamStateElementConfig(logicalStateElement.getStreamStateElement1()));
        logicalStateElementConfig.setType(logicalStateElement.getType().toString().toLowerCase());
        logicalStateElementConfig.setStreamStateElement2(this.generateStreamStateElementConfig(logicalStateElement.getStreamStateElement2()));
        return logicalStateElementConfig;
    }

    private EveryStateElementConfig generateEveryStateElementConfig(EveryStateElement everyStateElement) throws DesignGenerationException {
        EveryStateElementConfig everyStateElementConfig = new EveryStateElementConfig();
        everyStateElementConfig.setStateElement(this.generateStateElementConfigTree(everyStateElement.getStateElement()));
        return everyStateElementConfig;
    }

    private NextStateElementConfig generateNextStateElementConfig(NextStateElement nextStateElement) throws DesignGenerationException {
        NextStateElementConfig nextStateElementConfig = new NextStateElementConfig();
        nextStateElementConfig.setStateElement(this.generateStateElementConfigTree(nextStateElement.getStateElement()));
        nextStateElementConfig.setNextStateElement(this.generateStateElementConfigTree(nextStateElement.getNextStateElement()));
        return nextStateElementConfig;
    }

    private AbsentStreamStateElementConfig generateAbsentStreamStateElementConfig(AbsentStreamStateElement absentStreamStateElement) throws DesignGenerationException {
        BasicSingleInputStream basicSingleInputStream = absentStreamStateElement.getBasicSingleInputStream();
        AbsentStreamStateElementConfig absentStreamStateElementConfig = new AbsentStreamStateElementConfig();
        absentStreamStateElementConfig.setStreamReference(absentStreamStateElement.getBasicSingleInputStream().getStreamReferenceId());
        absentStreamStateElementConfig.setStreamName(basicSingleInputStream.getStreamId());
        absentStreamStateElementConfig.setStreamHandlerList(new StreamHandlerConfigGenerator(this.siddhiAppString).generateStreamHandlerConfigList(basicSingleInputStream.getStreamHandlers()));
        absentStreamStateElementConfig.setWaitingTime(this.generateNullableElementDefinition((SiddhiElement)absentStreamStateElement.getWaitingTime()));
        this.addToAvailableStreamReferences(absentStreamStateElement.getBasicSingleInputStream().getStreamReferenceId());
        return absentStreamStateElementConfig;
    }
}

