/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.utilities;

import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.AttributeConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.FunctionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.StoreConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.StreamConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.TableConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.TriggerConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.WindowConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.AggregationConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.aggregationbytimeperiod.AggregateByTimePeriod;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.aggregationbytimeperiod.aggregationbytimerange.AggregateByTimeInterval;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.aggregation.aggregationbytimeperiod.aggregationbytimerange.AggregateByTimeRange;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.attributesselection.AttributesSelectionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.attributesselection.SelectedAttribute;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.partition.PartitionWithElement;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.QueryOrderByConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.QueryInputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.join.JoinConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.join.JoinElementConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.patternsequence.PatternSequenceConditionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.patternsequence.PatternSequenceConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.input.windowfilterprojection.WindowFilterProjectionConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.QueryOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.DeleteOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.InsertOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.UpdateInsertIntoOutputConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.output.types.setattribute.SetAttributeConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.query.streamhandler.StreamHandlerConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.SourceSinkConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.mapper.MapperConfig;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.mapper.attribute.MapperListPayloadOrAttribute;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.mapper.attribute.MapperMapPayloadOrAttribute;
import io.siddhi.distribution.editor.core.util.designview.beans.configs.siddhielements.sourcesink.mapper.attribute.MapperPayloadOrAttribute;
import io.siddhi.distribution.editor.core.util.designview.codegenerator.elements.ExecutionElementConfig;
import io.siddhi.distribution.editor.core.util.designview.exceptions.CodeGenerationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CodeGeneratorUtils {
    private CodeGeneratorUtils() {
    }

    public static List<QueryConfig> reorderQueries(List<QueryConfig> queries, List<String> definitionNames) throws CodeGenerationException {
        if (queries == null) {
            throw new CodeGenerationException("A given list of queries for a partition is empty");
        }
        HashSet<String> existingInputs = new HashSet<String>(definitionNames);
        LinkedList<QueryConfig> reorderedQueries = new LinkedList<QueryConfig>();
        while (!queries.isEmpty()) {
            Iterator<QueryConfig> queryIterator = queries.iterator();
            while (queryIterator.hasNext()) {
                QueryConfig query = queryIterator.next();
                List<String> queryInputStreams = CodeGeneratorUtils.getInputStreams(query);
                queryInputStreams.removeAll(existingInputs);
                if (!queryInputStreams.isEmpty()) continue;
                reorderedQueries.add(query);
                queryIterator.remove();
                existingInputs.add(query.getQueryOutput().getTarget());
            }
        }
        return reorderedQueries;
    }

    public static List<String> getInputStreams(QueryConfig query) throws CodeGenerationException {
        NullValidator.validateConfigObject(query);
        NullValidator.validateConfigObject(query.getQueryInput());
        LinkedList<String> inputStreamList = new LinkedList<String>();
        switch (query.getQueryInput().getType().toUpperCase()) {
            case "WINDOW": 
            case "FILTER": 
            case "PROJECTION": 
            case "FUNCTION": {
                WindowFilterProjectionConfig windowFilterProjection = (WindowFilterProjectionConfig)query.getQueryInput();
                NullValidator.validateConfigObject(windowFilterProjection);
                inputStreamList.add(windowFilterProjection.getFrom());
                break;
            }
            case "JOIN": {
                JoinConfig join = (JoinConfig)query.getQueryInput();
                NullValidator.validateConfigObject(join);
                inputStreamList.add(join.getLeft().getFrom());
                inputStreamList.add(join.getRight().getFrom());
                break;
            }
            case "PATTERN": 
            case "SEQUENCE": {
                PatternSequenceConfig patternSequence = (PatternSequenceConfig)query.getQueryInput();
                NullValidator.validateConfigObject(patternSequence);
                for (PatternSequenceConditionConfig condition : patternSequence.getConditionList()) {
                    NullValidator.validateConfigObject(condition);
                    inputStreamList.add(condition.getStreamName());
                }
                break;
            }
            default: {
                throw new CodeGenerationException("Unidentified query type: " + query.getQueryInput().getType());
            }
        }
        return inputStreamList;
    }

    public static List<StreamConfig> getStreamsToBeGenerated(List<StreamConfig> streamList, List<SourceSinkConfig> sourceList, List<SourceSinkConfig> sinkList, List<QueryConfig> queryList) {
        ArrayList<StreamConfig> definedStreams = new ArrayList<StreamConfig>();
        for (StreamConfig stream : streamList) {
            if (stream.getPreviousCommentSegment() != null && stream.getPreviousCommentSegment().getContent() != null && !stream.getPreviousCommentSegment().getContent().isEmpty()) {
                definedStreams.add(stream);
                continue;
            }
            if (stream.getAnnotationList() != null && !stream.getAnnotationList().isEmpty()) {
                definedStreams.add(stream);
                continue;
            }
            boolean hasSourceSink = false;
            ArrayList<SourceSinkConfig> sourceSinkList = new ArrayList<SourceSinkConfig>();
            sourceSinkList.addAll(sourceList);
            sourceSinkList.addAll(sinkList);
            for (SourceSinkConfig source : sourceSinkList) {
                if (!stream.getName().equals(source.getConnectedElementName())) continue;
                hasSourceSink = true;
                break;
            }
            if (hasSourceSink) {
                definedStreams.add(stream);
                continue;
            }
            boolean isQueryOutput = false;
            for (QueryConfig query : queryList) {
                if (!query.getQueryOutput().getTarget().equals(stream.getName())) continue;
                isQueryOutput = true;
                break;
            }
            if (isQueryOutput) continue;
            definedStreams.add(stream);
        }
        return definedStreams;
    }

    public static List<String> getDefinitionNames(List<StreamConfig> streams, List<TableConfig> tables, List<WindowConfig> windows, List<TriggerConfig> triggers, List<AggregationConfig> aggregations, List<PartitionConfig> partitions) {
        LinkedList<String> definitionNames = new LinkedList<String>();
        for (StreamConfig stream : streams) {
            definitionNames.add(stream.getName());
        }
        for (TableConfig table : tables) {
            definitionNames.add(table.getName());
        }
        for (WindowConfig window : windows) {
            definitionNames.add(window.getName());
        }
        for (TriggerConfig trigger : triggers) {
            definitionNames.add(trigger.getName());
        }
        for (AggregationConfig aggregation : aggregations) {
            definitionNames.add(aggregation.getName());
        }
        for (PartitionConfig partition : partitions) {
            for (StreamConfig stream : partition.getStreamList()) {
                definitionNames.add(stream.getName());
            }
        }
        return definitionNames;
    }

    public static List<ExecutionElementConfig> convertToExecutionElements(List<QueryConfig> queries, List<PartitionConfig> partitions) throws CodeGenerationException {
        LinkedList<ExecutionElementConfig> executionElements = new LinkedList<ExecutionElementConfig>();
        for (QueryConfig query : queries) {
            executionElements.add(new ExecutionElementConfig(query));
        }
        for (PartitionConfig partition : partitions) {
            executionElements.add(new ExecutionElementConfig(partition));
        }
        return executionElements;
    }

    public static List<ExecutionElementConfig> reorderExecutionElements(List<ExecutionElementConfig> executionElements, List<String> definitionNames) throws CodeGenerationException {
        if (executionElements == null) {
            throw new CodeGenerationException("The given list of execution elements is empty");
        }
        HashSet<String> existingInputs = new HashSet<String>(definitionNames);
        LinkedList<ExecutionElementConfig> reorderedExecutionElements = new LinkedList<ExecutionElementConfig>();
        while (!executionElements.isEmpty()) {
            Iterator<ExecutionElementConfig> executionElementIterator = executionElements.iterator();
            while (executionElementIterator.hasNext()) {
                ExecutionElementConfig executionElement = executionElementIterator.next();
                List<String> executionElementInputStreams = executionElement.getInputStreams();
                executionElementInputStreams.removeAll(existingInputs);
                if (!executionElementInputStreams.isEmpty()) continue;
                reorderedExecutionElements.add(executionElement);
                executionElementIterator.remove();
                existingInputs.addAll(executionElement.getOutputStreams());
            }
        }
        return reorderedExecutionElements;
    }

    public static class NullValidator {
        private NullValidator() {
        }

        public static void validateConfigObject(StreamConfig stream) throws CodeGenerationException {
            if (stream == null) {
                throw new CodeGenerationException("A given stream element is empty");
            }
            if (stream.getName() == null || stream.getName().isEmpty()) {
                throw new CodeGenerationException("The name of a given stream element is empty");
            }
        }

        public static void validateConfigObject(JoinConfig join) throws CodeGenerationException {
            if (join == null) {
                throw new CodeGenerationException("A given join query is empty");
            }
            if (join.getJoinWith() == null || join.getJoinType().isEmpty()) {
                throw new CodeGenerationException("The 'joinWith' value of a given join query is empty");
            }
            if (join.getJoinType() == null || join.getJoinType().isEmpty()) {
                throw new CodeGenerationException("The 'joinType' value of a given join query is empty");
            }
            if (join.getLeft() == null || join.getRight() == null) {
                throw new CodeGenerationException("The left/right join element for a given join query is empty");
            }
            if (join.getLeft().getType() == null || join.getLeft().getType().isEmpty()) {
                throw new CodeGenerationException("The 'type' value of the left join element of a given join query is empty");
            }
            if (join.getRight().getType() == null || join.getRight().getType().isEmpty()) {
                throw new CodeGenerationException("The 'type' value of the right join element of a given join query is empty");
            }
        }

        public static void validateConfigObject(JoinElementConfig joinElement) throws CodeGenerationException {
            if (joinElement == null) {
                throw new CodeGenerationException("A given join element is empty");
            }
            if (joinElement.getFrom() == null || joinElement.getFrom().isEmpty()) {
                throw new CodeGenerationException("The 'from' value of a given join element is empty");
            }
        }

        public static void validateConfigObject(PatternSequenceConditionConfig condition) throws CodeGenerationException {
            if (condition == null) {
                throw new CodeGenerationException("A given pattern/sequence query condition is empty");
            }
            if (condition.getStreamName() == null || condition.getStreamName().isEmpty()) {
                throw new CodeGenerationException("The stream name of a given pattern/sequence query condition is empty");
            }
        }

        public static void validateConfigObject(PatternSequenceConfig patternSequence) throws CodeGenerationException {
            if (patternSequence == null) {
                throw new CodeGenerationException("A given pattern/sequence query is empty");
            }
            if (patternSequence.getLogic() == null || patternSequence.getLogic().isEmpty()) {
                throw new CodeGenerationException("The 'logic' value for a given pattern/sequence query is empty");
            }
            if (patternSequence.getConditionList() == null || patternSequence.getConditionList().isEmpty()) {
                throw new CodeGenerationException("The condition list for a given pattern/sequence query is empty");
            }
        }

        public static void validateConfigObject(QueryInputConfig queryInput) throws CodeGenerationException {
            if (queryInput == null) {
                throw new CodeGenerationException("A given query input element is empty");
            }
            if (queryInput.getType() == null || queryInput.getType().isEmpty()) {
                throw new CodeGenerationException("The 'type' value of a given query input element is empty");
            }
        }

        public static void validateConfigObject(WindowFilterProjectionConfig windowFilterProjection) throws CodeGenerationException {
            if (windowFilterProjection == null) {
                throw new CodeGenerationException("A given window/filter/project element is empty");
            }
            if (windowFilterProjection.getFrom() == null || windowFilterProjection.getFrom().isEmpty()) {
                throw new CodeGenerationException("The 'from' value of a given window/filter/project element is empty");
            }
        }

        public static void validateConfigObject(QueryOutputConfig queryOutput) throws CodeGenerationException {
            if (queryOutput == null) {
                throw new CodeGenerationException("A given query output element is empty");
            }
            if (queryOutput.getType() == null || queryOutput.getType().isEmpty()) {
                throw new CodeGenerationException("The 'type' value of a given query output element is empty");
            }
        }

        public static void validateConfigObject(DeleteOutputConfig deleteOutput) throws CodeGenerationException {
            if (deleteOutput == null) {
                throw new CodeGenerationException("A given delete query output element is empty");
            }
            if (deleteOutput.getOn() == null || deleteOutput.getOn().isEmpty()) {
                throw new CodeGenerationException("The 'on' statement of a given delete query output element is null/empty");
            }
        }

        public static void validateConfigObject(UpdateInsertIntoOutputConfig updateInsertIntoOutput) throws CodeGenerationException {
            if (updateInsertIntoOutput == null) {
                throw new CodeGenerationException("A given update/insert query output element is empty");
            }
            if (updateInsertIntoOutput.getOn() == null || updateInsertIntoOutput.getOn().isEmpty()) {
                throw new CodeGenerationException("The 'on' value of a given update/insert query element is empty");
            }
        }

        public static void validateConfigObject(SetAttributeConfig setAttribute) throws CodeGenerationException {
            if (setAttribute == null) {
                throw new CodeGenerationException("A given set attribute element given is empty");
            }
            if (setAttribute.getAttribute() == null || setAttribute.getAttribute().isEmpty()) {
                throw new CodeGenerationException("The 'attribute' value of a given set attribute element is empty");
            }
            if (setAttribute.getValue() == null || setAttribute.getValue().isEmpty()) {
                throw new CodeGenerationException("The 'value' attribute of a given set attribute element is empty");
            }
        }

        public static void validateConfigObject(AggregationConfig aggregation) throws CodeGenerationException {
            if (aggregation == null) {
                throw new CodeGenerationException("A given aggregation element is empty");
            }
            if (aggregation.getName() == null || aggregation.getName().isEmpty()) {
                throw new CodeGenerationException("The name of a given aggregation element is empty");
            }
            if (aggregation.getFrom() == null || aggregation.getFrom().isEmpty()) {
                throw new CodeGenerationException("The 'from' value of " + aggregation.getName() + " is empty");
            }
            if (aggregation.getAggregateByTimePeriod() == null) {
                throw new CodeGenerationException("The 'aggregateByTimePeriod' value of " + aggregation.getName() + " is empty");
            }
            if (aggregation.getAggregateByTimePeriod().getType() == null || aggregation.getAggregateByTimePeriod().getType().isEmpty()) {
                throw new CodeGenerationException("The aggregateByTimePeriod 'type' value of " + aggregation.getName() + " is empty");
            }
        }

        public static void validateConfigObject(AggregateByTimePeriod aggregateByTimePeriod) throws CodeGenerationException {
            if (aggregateByTimePeriod == null) {
                throw new CodeGenerationException("A given aggregateByTimePeriod element is empty");
            }
            if (aggregateByTimePeriod.getType() == null || aggregateByTimePeriod.getType().isEmpty()) {
                throw new CodeGenerationException("The 'type' value of a given aggregateByTimePeriod element is empty");
            }
        }

        public static void validateConfigObject(AggregateByTimeRange aggregateByTimeRange) throws CodeGenerationException {
            if (aggregateByTimeRange.getValue() == null) {
                throw new CodeGenerationException("The 'value' attribute of a given aggregateByTimeRange element is empty");
            }
            if (aggregateByTimeRange.getValue().getMin() == null || aggregateByTimeRange.getValue().getMin().isEmpty()) {
                throw new CodeGenerationException("The 'min' value of a given aggregateByTimeRange element is empty");
            }
            if (aggregateByTimeRange.getValue().getMax() == null || aggregateByTimeRange.getValue().getMax().isEmpty()) {
                throw new CodeGenerationException("The 'max' value of a given aggregateByTimeRange element is empty");
            }
        }

        public static void validateConfigObject(FunctionConfig function) throws CodeGenerationException {
            if (function == null) {
                throw new CodeGenerationException("A given function element is empty");
            }
            if (function.getName() == null || function.getName().isEmpty()) {
                throw new CodeGenerationException("The name of a given function element is empty");
            }
            if (function.getScriptType() == null || function.getScriptType().isEmpty()) {
                throw new CodeGenerationException("The 'script type' of " + function.getName() + " is empty");
            }
            if (function.getReturnType() == null || function.getReturnType().isEmpty()) {
                throw new CodeGenerationException("The return type of " + function.getName() + " is empty");
            }
            if (function.getBody() == null || function.getBody().isEmpty()) {
                throw new CodeGenerationException("The 'body' value of " + function.getName() + " is empty");
            }
        }

        public static void validateConfigObject(PartitionConfig partition) throws CodeGenerationException {
            if (partition == null) {
                throw new CodeGenerationException("A given partition object is empty");
            }
            if (partition.getPartitionWith() == null || partition.getPartitionWith().isEmpty()) {
                throw new CodeGenerationException("The 'partitionWith' value of a given partition element is empty");
            }
            if (partition.getQueryLists() == null || partition.getQueryLists().isEmpty()) {
                throw new CodeGenerationException("The query lists of a given partition element is empty");
            }
        }

        public static void validateConfigObject(PartitionWithElement partitionWithElement) throws CodeGenerationException {
            if (partitionWithElement == null) {
                throw new CodeGenerationException("A given 'partition with' element is empty");
            }
            if (partitionWithElement.getExpression() == null || partitionWithElement.getExpression().isEmpty()) {
                throw new CodeGenerationException("The 'expression' value of a given 'partition with' element is empty");
            }
            if (partitionWithElement.getStreamName() == null || partitionWithElement.getStreamName().isEmpty()) {
                throw new CodeGenerationException("The stream name of a given 'partition with' element is empty");
            }
        }

        public static void validateConfigObject(SourceSinkConfig sourceSink) throws CodeGenerationException {
            if (sourceSink == null) {
                throw new CodeGenerationException("A given source/sink element is empty");
            }
            if (sourceSink.getAnnotationType() == null || sourceSink.getAnnotationType().isEmpty()) {
                throw new CodeGenerationException("The annotation type for a given source/sink element is empty");
            }
            if (sourceSink.getType() == null || sourceSink.getType().isEmpty()) {
                throw new CodeGenerationException("The type attribute for a given source/sink element is empty");
            }
        }

        public static void validateConfigObject(StoreConfig store) throws CodeGenerationException {
            if (store.getType() == null || store.getType().isEmpty()) {
                throw new CodeGenerationException("The 'type' value of a given store element is empty");
            }
        }

        public static void validateConfigObject(StreamHandlerConfig streamHandler) throws CodeGenerationException {
            if (streamHandler == null) {
                throw new CodeGenerationException("A given stream handler element is empty");
            }
            if (streamHandler.getType() == null || streamHandler.getType().isEmpty()) {
                throw new CodeGenerationException("The 'type' value of a given stream handler element is empty");
            }
        }

        public static void validateConfigObject(TableConfig table) throws CodeGenerationException {
            if (table == null) {
                throw new CodeGenerationException("A given table element is empty");
            }
            if (table.getName() == null || table.getName().isEmpty()) {
                throw new CodeGenerationException("The name of a given table element is empty");
            }
        }

        public static void validateConfigObject(TriggerConfig trigger) throws CodeGenerationException {
            if (trigger == null) {
                throw new CodeGenerationException("A given trigger element is empty");
            }
            if (trigger.getName() == null || trigger.getName().isEmpty()) {
                throw new CodeGenerationException("The name of a given trigger element is empty");
            }
            if (trigger.getCriteria() == null || trigger.getCriteria().isEmpty()) {
                throw new CodeGenerationException("The 'at' value of " + trigger.getName() + " is empty");
            }
        }

        public static void validateConfigObject(WindowConfig window) throws CodeGenerationException {
            if (window == null) {
                throw new CodeGenerationException("A given window element is empty");
            }
            if (window.getName() == null || window.getName().isEmpty()) {
                throw new CodeGenerationException("The name of a given window element is empty");
            }
            if (window.getType() == null || window.getType().isEmpty()) {
                throw new CodeGenerationException("The function name of the window " + window.getName() + " is empty");
            }
        }

        public static void validateConfigObject(InsertOutputConfig insertOutput) throws CodeGenerationException {
            if (insertOutput == null) {
                throw new CodeGenerationException("A given insert query output element is empty");
            }
        }

        public static void validateConfigObject(AttributesSelectionConfig attributesSelection) throws CodeGenerationException {
            if (attributesSelection == null) {
                throw new CodeGenerationException("A given attribute selection element is empty");
            }
            if (attributesSelection.getType() == null || attributesSelection.getType().isEmpty()) {
                throw new CodeGenerationException("The 'type' value of a given attribute selection element is empty");
            }
        }

        public static void validateConfigObject(SelectedAttribute attribute) throws CodeGenerationException {
            if (attribute.getExpression() == null || attribute.getExpression().isEmpty()) {
                throw new CodeGenerationException("The 'expression' value of a given select attribute element is empty");
            }
        }

        public static void validateConfigObject(QueryOrderByConfig orderByAttribute) throws CodeGenerationException {
            if (orderByAttribute == null) {
                throw new CodeGenerationException("A given query 'order by' value is empty");
            }
            if (orderByAttribute.getValue() == null || orderByAttribute.getValue().isEmpty()) {
                throw new CodeGenerationException("The 'value' attribute for a given query order by element is empty");
            }
        }

        public static void validateConfigObject(QueryConfig query) throws CodeGenerationException {
            if (query == null) {
                throw new CodeGenerationException("A given query element is empty");
            }
        }

        public static void validateConfigObject(AggregateByTimeInterval aggregateByTimeInterval) throws CodeGenerationException {
            if (aggregateByTimeInterval.getValue() == null || aggregateByTimeInterval.getValue().isEmpty()) {
                throw new CodeGenerationException("The 'value' attribute of a given attributeByTimeInterval element is empty");
            }
        }

        public static void validateConfigObject(List<PartitionWithElement> partitionWith) throws CodeGenerationException {
            if (partitionWith == null || partitionWith.isEmpty()) {
                throw new CodeGenerationException("A given 'partitionWith' list is empty");
            }
        }

        public static void validateConfigObject(MapperConfig mapper) throws CodeGenerationException {
            if (mapper.getType() == null || mapper.getType().isEmpty()) {
                throw new CodeGenerationException("The map type of a given source/sink map element is empty");
            }
        }

        public static void validateConfigObject(MapperPayloadOrAttribute payloadOrAttribute) throws CodeGenerationException {
            if (payloadOrAttribute.getType() == null || payloadOrAttribute.getType().isEmpty()) {
                throw new CodeGenerationException("The 'type' value of a given source/sink map attribute element is empty");
            }
        }

        public static void validateConfigObject(MapperListPayloadOrAttribute mapperListAttribute) throws CodeGenerationException {
            if (mapperListAttribute.getValue() == null || mapperListAttribute.getValue().isEmpty()) {
                throw new CodeGenerationException("The list values of a given sink/source map attribute element is empty");
            }
        }

        public static void validateConfigObject(MapperMapPayloadOrAttribute mapperMapAttribute) throws CodeGenerationException {
            if (mapperMapAttribute.getValue() == null || mapperMapAttribute.getValue().isEmpty()) {
                throw new CodeGenerationException("The key-value pair values of a given source/sink map attribute element is empty");
            }
        }

        public static void validateConfigObject(AttributeConfig attribute) throws CodeGenerationException {
            if (attribute == null) {
                throw new CodeGenerationException("A given attribute element is empty");
            }
            if (attribute.getName() == null || attribute.getName().isEmpty()) {
                throw new CodeGenerationException("The 'name' of a given attribute element is empty");
            }
            if (attribute.getType() == null || attribute.getType().isEmpty()) {
                throw new CodeGenerationException("The 'type' value of a given attribute element is empty");
            }
        }
    }
}

