/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.distribution.editor.core.util.designview.utilities;

import io.siddhi.query.api.SiddhiElement;
import org.apache.log4j.Logger;

public class ConfigBuildingUtilities {
    private static final Logger log = Logger.getLogger(ConfigBuildingUtilities.class);

    private ConfigBuildingUtilities() {
    }

    public static String getDefinition(SiddhiElement siddhiElement, String siddhiAppString) {
        int[] startIndex = siddhiElement.getQueryContextStartIndex();
        int[] endIndex = siddhiElement.getQueryContextEndIndex();
        if (startIndex == null || endIndex == null) {
            log.debug((Object)"Failed to get the string since Start index and/or End index of the SiddhiElement are/is null");
            return null;
        }
        return ConfigBuildingUtilities.getStringWithQueryContextIndexes(startIndex, endIndex, siddhiAppString);
    }

    public static String getStringWithQueryContextIndexes(int[] startIndex, int[] endIndex, String siddhiAppString) {
        int startLinePosition = ConfigBuildingUtilities.ordinalIndexOf(startIndex[0], siddhiAppString);
        int endLinePosition = ConfigBuildingUtilities.ordinalIndexOf(endIndex[0], siddhiAppString);
        return siddhiAppString.substring(startLinePosition + startIndex[1], endLinePosition + endIndex[1]);
    }

    private static int ordinalIndexOf(int lineNumber, String siddhiAppString) {
        int position = 0;
        while (lineNumber >= 0 && --lineNumber > 0) {
            position = siddhiAppString.indexOf(10, position) + 1;
        }
        return position;
    }
}

