/* ***** BEGIN LICENSE BLOCK *****
 * Distributed under the BSD license:
 *
 * Copyright (c) 2013 Matthew Christopher Kastor-Inare III, Atropa Inc. Intl
 * All rights reserved.
 *
 * Contributed to Ajax.org under the BSD license.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ***** END LICENSE BLOCK ***** */

/*jslint indent: 4, maxerr: 50, white: true, browser: true, vars: true*/
/*global define, require */

/**
 * Overlay Page
 * @fileOverview Overlay Page <br />
 * Generates an overlay for displaying menus. The overlay is an absolutely
 *  positioned div.
 * @author <a href="mailto:matthewkastor@gmail.com">
 *  Matthew Christopher Kastor-Inare III </a><br />
 *  ☭ Hial Atropa!! ☭
 */

define(function (require, exports, module) {
    'use strict';
    var dom = require("../../lib/dom");
    var cssText = require("../../requirejs/text!./settings_menu.css");
    dom.importCssString(cssText);

    /**
     * Generates an overlay for displaying menus. The overlay is an absolutely
     *  positioned div.
     * @author <a href="mailto:matthewkastor@gmail.com">
     *  Matthew Christopher Kastor-Inare III </a><br />
     *  ☭ Hial Atropa!! ☭
     * @param {DOMElement} contentElement Any element which may be presented inside
     *  a div.
     * @param {string|number} top absolute position value.
     * @param {string|number} right absolute position value.
     * @param {string|number} bottom absolute position value.
     * @param {string|number} left absolute position value.
     */
    module.exports.overlayPage = function overlayPage(editor, contentElement, top, right, bottom, left) {
        top = top ? 'top: ' + top + ';' : '';
        bottom = bottom ? 'bottom: ' + bottom + ';' : '';
        right = right ? 'right: ' + right + ';' : '';
        left = left ? 'left: ' + left + ';' : '';

        var closer = document.createElement('div');
        var contentContainer = document.createElement('div');

        function documentEscListener(e) {
            if (e.keyCode === 27) {
                closer.click();
            }
        }

        closer.style.cssText = 'margin: 0; padding: 0; ' +
            'position: fixed; top:0; bottom:0; left:0; right:0;' +
            'z-index: 9990; ' +
            'background-color: rgba(0, 0, 0, 0.3);';
        closer.addEventListener('click', function () {
            document.removeEventListener('keydown', documentEscListener);
            closer.parentNode.removeChild(closer);
            editor.focus();
            closer = null;
        });
        // click closer if esc key is pressed
        document.addEventListener('keydown', documentEscListener);

        contentContainer.style.cssText = top + right + bottom + left;
        contentContainer.addEventListener('click', function (e) {
            e.stopPropagation();
        });

        var wrapper = dom.createElement("div");
        wrapper.style.position = "relative";

        var closeButton = dom.createElement("div");
        closeButton.className = "ace_closeButton";
        closeButton.addEventListener('click', function () {
            closer.click();
        });

        wrapper.appendChild(closeButton);
        contentContainer.appendChild(wrapper);

        contentContainer.appendChild(contentElement);
        closer.appendChild(contentContainer);
        document.body.appendChild(closer);
        editor.blur();
    };

});