/* ***** BEGIN LICENSE BLOCK *****
 * Distributed under the BSD license:
 *
 * Copyright (c) 2012, Ajax.org B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ***** END LICENSE BLOCK ***** */

/* This file was autogenerated from Hjson.tmLanguage (uuid: ) */
/****************************************************************************************
 * IT MIGHT NOT BE PERFECT ...But it's a good start from an existing *.tmlanguage file. *
 * fileTypes                                                                            *
 ****************************************************************************************/

define(function (require, exports, module) {
    "use strict";

    var oop = require("../lib/oop");
    var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;

    var HjsonHighlightRules = function () {
        // regexp must not have capturing parentheses. Use (?:) instead.
        // regexps are ordered -> the first match is used

        this.$rules = {
            start: [{
                include: "#comments"
            }, {
                include: "#rootObject"
            }, {
                include: "#value"
            }],
            "#array": [{
                token: "paren.lparen",
                regex: /\[/,
                push: [{
                    token: "paren.rparen",
                    regex: /\]/,
                    next: "pop"
                }, {
                    include: "#value"
                }, {
                    include: "#comments"
                }, {
                    token: "text",
                    regex: /,|$/
                }, {
                    token: "invalid.illegal",
                    regex: /[^\s\]]/
                }, {
                    defaultToken: "array"
                }]
            }],
            "#comments": [{
                token: [
                    "comment.punctuation",
                    "comment.line"
                ],
                regex: /(#)(.*$)/
            }, {
                token: "comment.punctuation",
                regex: /\/\*/,
                push: [{
                    token: "comment.punctuation",
                    regex: /\*\//,
                    next: "pop"
                }, {
                    defaultToken: "comment.block"
                }]
            }, {
                token: [
                    "comment.punctuation",
                    "comment.line"
                ],
                regex: /(\/\/)(.*$)/
            }],
            "#constant": [{
                token: "constant",
                regex: /\b(?:true|false|null)\b/
            }],
            "#keyname": [{
                token: "keyword",
                regex: /(?:[^,\{\[\}\]\s]+|"(?:[^"\\]|\\.)*")\s*(?=:)/
            }],
            "#mstring": [{
                token: "string",
                regex: /'''/,
                push: [{
                    token: "string",
                    regex: /'''/,
                    next: "pop"
                }, {
                    defaultToken: "string"
                }]
            }],
            "#number": [{
                token: "constant.numeric",
                regex: /-?(?:0|[1-9]\d*)(?:(?:\.\d+)?(?:[eE][+-]?\d+)?)?/,
                comment: "handles integer and decimal numbers"
            }],
            "#object": [{
                token: "paren.lparen",
                regex: /\{/,
                push: [{
                    token: "paren.rparen",
                    regex: /\}/,
                    next: "pop"
                }, {
                    include: "#keyname"
                }, {
                    include: "#value"
                }, {
                    token: "text",
                    regex: /:/
                }, {
                    token: "text",
                    regex: /,/
                }, {
                    defaultToken: "paren"
                }]
            }],
            "#rootObject": [{
                token: "paren",
                regex: /(?=\s*(?:[^,\{\[\}\]\s]+|"(?:[^"\\]|\\.)*")\s*:)/,
                push: [{
                    token: "paren.rparen",
                    regex: /---none---/,
                    next: "pop"
                }, {
                    include: "#keyname"
                }, {
                    include: "#value"
                }, {
                    token: "text",
                    regex: /:/
                }, {
                    token: "text",
                    regex: /,/
                }, {
                    defaultToken: "paren"
                }]
            }],
            "#string": [{
                token: "string",
                regex: /"/,
                push: [{
                    token: "string",
                    regex: /"/,
                    next: "pop"
                }, {
                    token: "constant.language.escape",
                    regex: /\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/
                }, {
                    token: "invalid.illegal",
                    regex: /\\./
                }, {
                    defaultToken: "string"
                }]
            }],
            "#ustring": [{
                token: "string",
                regex: /\b[^:,0-9\-\{\[\}\]\s].*$/
            }],
            "#value": [{
                include: "#constant"
            }, {
                include: "#number"
            }, {
                include: "#string"
            }, {
                include: "#array"
            }, {
                include: "#object"
            }, {
                include: "#comments"
            }, {
                include: "#mstring"
            }, {
                include: "#ustring"
            }]
        }

        this.normalizeRules();
    };

    HjsonHighlightRules.metaData = {
        fileTypes: ["hjson"],
        foldingStartMarker: "(?x:     # turn on extended mode\n              ^    # a line beginning with\n              \\s*    # some optional space\n              [{\\[]  # the start of an object or array\n              (?!    # but not followed by\n              .*   # whatever\n              [}\\]]  # and the close of an object or array\n              ,?   # an optional comma\n              \\s*  # some optional space\n              $    # at the end of the line\n              )\n              |    # ...or...\n              [{\\[]  # the start of an object or array\n              \\s*    # some optional space\n              $    # at the end of the line\n            )",
        foldingStopMarker: "(?x:   # turn on extended mode\n             ^    # a line beginning with\n             \\s*  # some optional space\n             [}\\]]  # and the close of an object or array\n             )",
        keyEquivalent: "^~J",
        name: "Hjson",
        scopeName: "source.hjson"
    }


    oop.inherits(HjsonHighlightRules, TextHighlightRules);

    exports.HjsonHighlightRules = HjsonHighlightRules;
});